/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution.impl;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.hyperledger.fabric.contract.Context;
import org.hyperledger.fabric.contract.ContractInterface;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.annotation.Serializer;
import org.hyperledger.fabric.contract.execution.ExecutionService;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.contract.execution.SerializerInterface;
import org.hyperledger.fabric.contract.metadata.TypeSchema;
import org.hyperledger.fabric.contract.routing.ParameterDefinition;
import org.hyperledger.fabric.contract.routing.TxFunction;
import org.hyperledger.fabric.contract.routing.impl.SerializerRegistryImpl;
import org.hyperledger.fabric.shim.Chaincode;
import org.hyperledger.fabric.shim.ChaincodeException;
import org.hyperledger.fabric.shim.ChaincodeStub;
import org.hyperledger.fabric.shim.ResponseUtils;

public class ContractExecutionService
implements ExecutionService {
    private static final Logger LOGGER = Logger.getLogger(ContractExecutionService.class.getName());
    private final SerializerRegistryImpl serializers;

    public ContractExecutionService(SerializerRegistryImpl serializers) {
        this.serializers = serializers;
    }

    @Override
    public Chaincode.Response executeRequest(TxFunction txFn, InvocationRequest req, ChaincodeStub stub) {
        Chaincode.Response response;
        LOGGER.fine(() -> "Routing Request" + String.valueOf(txFn));
        TxFunction.Routing rd = txFn.getRouting();
        try {
            ContractInterface contractObject = rd.getContractInstance();
            Context context = contractObject.createContext(stub);
            List<Object> args = this.convertArgs(req.getArgs(), txFn);
            args.add(0, context);
            contractObject.beforeTransaction(context);
            Object value = rd.getMethod().invoke((Object)contractObject, args.toArray());
            contractObject.afterTransaction(context, value);
            response = value == null ? ResponseUtils.newSuccessResponse() : ResponseUtils.newSuccessResponse(this.convertReturn(value, txFn));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException e) {
            String message = String.format("Could not execute contract method: %s", rd.toString());
            throw new ContractRuntimeException(message, e);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof ChaincodeException) {
                response = ResponseUtils.newErrorResponse(cause);
            }
            throw new ContractRuntimeException("Error during contract method execution", cause);
        }
        return response;
    }

    private byte[] convertReturn(Object obj, TxFunction txFn) {
        SerializerInterface serializer = this.serializers.getSerializer(txFn.getRouting().getSerializerName(), Serializer.TARGET.TRANSACTION);
        TypeSchema ts = txFn.getReturnSchema();
        return serializer.toBuffer(obj, ts);
    }

    private List<Object> convertArgs(List<byte[]> stubArgs, TxFunction txFn) {
        SerializerInterface serializer = this.serializers.getSerializer(txFn.getRouting().getSerializerName(), Serializer.TARGET.TRANSACTION);
        List<ParameterDefinition> schemaParams = txFn.getParamsList();
        ArrayList<Object> args = new ArrayList<Object>(stubArgs.size() + 1);
        for (int i = 0; i < schemaParams.size(); ++i) {
            args.add(i, serializer.fromBuffer(stubArgs.get(i), schemaParams.get(i).getSchema()));
        }
        return args;
    }
}

