/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.shim.impl;

import com.google.protobuf.ByteString;
import org.hyperledger.fabric.protos.ledger.queryresult.KV;
import org.hyperledger.fabric.shim.ledger.KeyValue;

class KeyValueImpl
implements KeyValue {
    private final String key;
    private final ByteString value;

    KeyValueImpl(KV kv) {
        this.key = kv.getKey();
        this.value = kv.getValue();
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public byte[] getValue() {
        return this.value.toByteArray();
    }

    @Override
    public String getStringValue() {
        return this.value.toStringUtf8();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        KeyValueImpl other = (KeyValueImpl)obj;
        if (!this.key.equals(other.key)) {
            return false;
        }
        return this.value.equals((Object)other.value);
    }
}

