/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.metadata;

import java.lang.reflect.Array;
import java.util.HashMap;
import java.util.Map;
import org.everit.json.schema.Schema;
import org.everit.json.schema.ValidationException;
import org.everit.json.schema.loader.SchemaLoader;
import org.hyperledger.fabric.Logger;
import org.hyperledger.fabric.contract.ContractRuntimeException;
import org.hyperledger.fabric.contract.metadata.MetadataBuilder;
import org.hyperledger.fabric.contract.routing.TypeRegistry;
import org.json.JSONObject;

public final class TypeSchema
extends HashMap<String, Object> {
    private static Logger logger = Logger.getLogger(TypeSchema.class.getName());

    private Object putInternal(String key, Object value) {
        if (value != null && !value.toString().isEmpty()) {
            return this.put(key, value);
        }
        return null;
    }

    String putIfNotNull(String key, String value) {
        return (String)this.putInternal(key, value);
    }

    String[] putIfNotNull(String key, String[] value) {
        return (String[])this.putInternal(key, value);
    }

    TypeSchema putIfNotNull(String key, TypeSchema value) {
        return (TypeSchema)this.putInternal(key, value);
    }

    TypeSchema[] putIfNotNull(String key, TypeSchema[] value) {
        return (TypeSchema[])this.putInternal(key, value);
    }

    public String getType() {
        if (this.containsKey("schema")) {
            Map intermediateMap = (Map)this.get("schema");
            return (String)intermediateMap.get("type");
        }
        return (String)this.get("type");
    }

    public TypeSchema getItems() {
        if (this.containsKey("schema")) {
            Map intermediateMap = (Map)this.get("schema");
            return (TypeSchema)intermediateMap.get("items");
        }
        return (TypeSchema)this.get("items");
    }

    public String getRef() {
        if (this.containsKey("schema")) {
            Map intermediateMap = (Map)this.get("schema");
            return (String)intermediateMap.get("$ref");
        }
        return (String)this.get("$ref");
    }

    public String getFormat() {
        if (this.containsKey("schema")) {
            Map intermediateMap = (Map)this.get("schema");
            return (String)intermediateMap.get("format");
        }
        return (String)this.get("format");
    }

    public Class<?> getTypeClass(TypeRegistry typeRegistry) {
        Class clz = null;
        String type = this.getType();
        if (type == null) {
            type = "object";
        }
        if (type.contentEquals("string")) {
            String format = this.getFormat();
            clz = format != null && format.contentEquals("uint16") ? Character.TYPE : String.class;
        } else if (type.contentEquals("integer")) {
            String format;
            switch (format = this.getFormat()) {
                case "int8": {
                    clz = Byte.TYPE;
                    break;
                }
                case "int16": {
                    clz = Short.TYPE;
                    break;
                }
                case "int32": {
                    clz = Integer.TYPE;
                    break;
                }
                case "int64": {
                    clz = Long.TYPE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown format for integer of " + format);
                }
            }
        } else if (type.contentEquals("number")) {
            String format;
            switch (format = this.getFormat()) {
                case "double": {
                    clz = Double.TYPE;
                    break;
                }
                case "float": {
                    clz = Float.TYPE;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown format for number of " + format);
                }
            }
        } else if (type.contentEquals("boolean")) {
            clz = Boolean.TYPE;
        } else if (type.contentEquals("object")) {
            String ref = this.getRef();
            String format = ref.substring(ref.lastIndexOf("/") + 1);
            clz = typeRegistry.getDataType(format).getTypeClass();
        } else if (type.contentEquals("array")) {
            TypeSchema typdef = this.getItems();
            Class<?> arrayType = typdef.getTypeClass(typeRegistry);
            clz = Array.newInstance(arrayType, 0).getClass();
        }
        return clz;
    }

    public static TypeSchema typeConvert(Class<?> clz) {
        TypeSchema schema;
        TypeSchema returnschema = new TypeSchema();
        String className = clz.getTypeName();
        if (className == "void") {
            return null;
        }
        if (clz.isArray()) {
            returnschema.put("type", "array");
            schema = new TypeSchema();
            Class<?> componentClass = clz.getComponentType();
            if (componentClass.isArray()) {
                returnschema.put("items", TypeSchema.typeConvert(componentClass));
            } else {
                returnschema.put("items", schema);
            }
            className = componentClass.getTypeName();
        } else {
            schema = returnschema;
        }
        switch (className) {
            case "java.lang.String": {
                schema.put("type", "string");
                break;
            }
            case "char": 
            case "java.lang.Character": {
                schema.put("type", "string");
                schema.put("format", "uint16");
                break;
            }
            case "byte": 
            case "java.lang.Byte": {
                schema.put("type", "integer");
                schema.put("format", "int8");
                break;
            }
            case "short": 
            case "java.lang.Short": {
                schema.put("type", "integer");
                schema.put("format", "int16");
                break;
            }
            case "int": 
            case "java.lang.Integer": {
                schema.put("type", "integer");
                schema.put("format", "int32");
                break;
            }
            case "long": 
            case "java.lang.Long": {
                schema.put("type", "integer");
                schema.put("format", "int64");
                break;
            }
            case "double": 
            case "java.lang.Double": {
                schema.put("type", "number");
                schema.put("format", "double");
                break;
            }
            case "float": 
            case "java.lang.Float": {
                schema.put("type", "number");
                schema.put("format", "float");
                break;
            }
            case "boolean": 
            case "java.lang.Boolean": {
                schema.put("type", "boolean");
                break;
            }
            default: {
                schema.put("$ref", "#/components/schemas/" + className.substring(className.lastIndexOf(46) + 1));
            }
        }
        return returnschema;
    }

    public void validate(JSONObject obj) {
        JSONObject toValidate = new JSONObject();
        toValidate.put("prop", (Object)obj);
        JSONObject schemaJSON = this.containsKey("schema") ? new JSONObject((Map)this.get("schema")) : new JSONObject((Map)this);
        JSONObject rawSchema = new JSONObject();
        rawSchema.put("properties", (Object)new JSONObject().put("prop", (Object)schemaJSON));
        rawSchema.put("components", (Object)new JSONObject().put("schemas", MetadataBuilder.getComponents()));
        Schema schema = SchemaLoader.load((JSONObject)rawSchema);
        try {
            schema.validate((Object)toValidate);
        }
        catch (ValidationException e) {
            StringBuilder sb = new StringBuilder("Validation Errors::");
            e.getCausingExceptions().stream().map(ValidationException::getMessage).forEach(sb::append);
            logger.info(sb.toString());
            throw new ContractRuntimeException(sb.toString(), e);
        }
    }
}

