/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.fabric.contract.execution.impl;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperledger.fabric.contract.execution.InvocationRequest;
import org.hyperledger.fabric.shim.ChaincodeStub;

public class ContractInvocationRequest
implements InvocationRequest {
    private String namespace;
    private String method;
    private List<byte[]> args = Collections.emptyList();
    private static Log logger = LogFactory.getLog(ContractInvocationRequest.class);

    public ContractInvocationRequest(ChaincodeStub context) {
        String func = context.getStringArgs().size() > 0 ? context.getStringArgs().get(0) : null;
        String[] funcParts = func.split(":");
        logger.debug((Object)func);
        if (funcParts.length == 2) {
            this.namespace = funcParts[0];
            this.method = funcParts[1];
        } else {
            this.namespace = "default";
            this.method = funcParts[0];
        }
        this.args = context.getArgs().stream().skip(1L).collect(Collectors.toList());
        logger.debug((Object)(this.namespace + " " + this.method + " " + this.args));
    }

    @Override
    public String getNamespace() {
        return this.namespace;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public List<byte[]> getArgs() {
        return this.args;
    }

    @Override
    public String getRequestName() {
        return this.namespace + ":" + this.method;
    }

    public String toString() {
        return this.namespace + ":" + this.method + " @" + Integer.toHexString(System.identityHashCode(this));
    }
}

