/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import com.google.common.collect.ListMultimap;
import hudson.AbortException;
import hudson.EnvVars;
import hudson.Extension;
import hudson.Launcher;
import hudson.Util;
import hudson.console.HyperlinkNote;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.Action;
import hudson.model.BuildListener;
import hudson.model.DependecyDeclarer;
import hudson.model.DependencyGraph;
import hudson.model.TaskListener;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BuildInfoExporterAction;
import hudson.plugins.parameterizedtrigger.ParameterizedDependency;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Builder;
import hudson.util.IOException2;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.kohsuke.stapler.DataBoundConstructor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TriggerBuilder
extends Builder
implements DependecyDeclarer {
    private final ArrayList<BlockableBuildTriggerConfig> configs;

    @DataBoundConstructor
    public TriggerBuilder(List<BlockableBuildTriggerConfig> configs) {
        this.configs = new ArrayList(Util.fixNull(configs));
    }

    public TriggerBuilder(BlockableBuildTriggerConfig ... configs) {
        this(Arrays.asList(configs));
    }

    public List<BlockableBuildTriggerConfig> getConfigs() {
        return this.configs;
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    public boolean perform(AbstractBuild<?, ?> build, Launcher launcher, BuildListener listener) throws InterruptedException, IOException {
        EnvVars env = build.getEnvironment((TaskListener)listener);
        env.overrideAll(build.getBuildVariables());
        boolean buildStepResult = true;
        try {
            for (BlockableBuildTriggerConfig config : this.configs) {
                ListMultimap<AbstractProject, Future<AbstractBuild>> futures = config.perform2(build, launcher, listener);
                List<AbstractProject> projectList = config.getProjectList(build.getProject().getParent(), env);
                if (!projectList.isEmpty()) {
                    if (futures.isEmpty()) {
                        listener.getLogger().println("Triggering projects: " + this.getProjectListAsString(projectList));
                        continue;
                    }
                    for (AbstractProject p : projectList) {
                        if (!p.isBuildable()) {
                            listener.getLogger().println("Skipping " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()) + ". The project is either disabled or the configuration has not been saved yet.");
                            continue;
                        }
                        for (Future future : futures.get((Object)p)) {
                            try {
                                listener.getLogger().println("Waiting for the completion of " + HyperlinkNote.encodeTo((String)('/' + p.getUrl()), (String)p.getFullDisplayName()));
                                AbstractBuild b = (AbstractBuild)future.get();
                                listener.getLogger().println(HyperlinkNote.encodeTo((String)('/' + b.getUrl()), (String)b.getFullDisplayName()) + " completed. Result was " + b.getResult());
                                build.getActions().add(new BuildInfoExporterAction(b.getProject().getFullName(), b.getNumber()));
                                if (buildStepResult && config.getBlock().mapBuildStepResult(b.getResult())) {
                                    build.setResult(config.getBlock().mapBuildResult(b.getResult()));
                                    continue;
                                }
                                buildStepResult = false;
                            }
                            catch (CancellationException x) {
                                throw new AbortException(p.getFullDisplayName() + " aborted.");
                            }
                        }
                    }
                    continue;
                }
                throw new AbortException("Build aborted. No projects to trigger. Check your configuration!");
            }
        }
        catch (ExecutionException e) {
            throw new IOException2((Throwable)e);
        }
        return buildStepResult;
    }

    private String getProjectListAsString(List<AbstractProject> projectList) {
        StringBuffer projectListString = new StringBuffer();
        Iterator<AbstractProject> iterator = projectList.iterator();
        while (iterator.hasNext()) {
            AbstractProject project = iterator.next();
            projectListString.append(HyperlinkNote.encodeTo((String)('/' + project.getUrl()), (String)project.getFullDisplayName()));
            if (!iterator.hasNext()) continue;
            projectListString.append(", ");
        }
        return projectListString.toString();
    }

    public void buildDependencyGraph(AbstractProject owner, DependencyGraph graph) {
        for (BlockableBuildTriggerConfig config : this.configs) {
            for (AbstractProject project : config.getProjectList(owner.getParent(), null)) {
                graph.addDependency((DependencyGraph.Dependency)new ParameterizedDependency(owner, project, config){

                    @Override
                    public boolean shouldTriggerBuild(AbstractBuild build, TaskListener listener, List<Action> actions) {
                        return false;
                    }
                });
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public String getDisplayName() {
            return "Trigger/call builds on other projects";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

