/*
 * Decompiled with CFR 0.152.
 */
package hudson.plugins.parameterizedtrigger;

import hudson.Extension;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Project;
import hudson.model.listeners.ItemListener;
import hudson.plugins.parameterizedtrigger.BlockableBuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.BuildTrigger;
import hudson.plugins.parameterizedtrigger.BuildTriggerConfig;
import hudson.plugins.parameterizedtrigger.ResultCondition;
import hudson.plugins.parameterizedtrigger.TriggerBuilder;
import hudson.util.EnumConverter;
import java.io.IOException;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.stapler.Stapler;

public class Plugin
extends hudson.Plugin {
    public void start() throws Exception {
        Stapler.CONVERT_UTILS.register((Converter)new EnumConverter(), ResultCondition.class);
    }

    @Extension
    public static final class RenameListener
    extends ItemListener {
        public void onRenamed(Item item, String oldName, String newName) {
            for (Project p : Hudson.getInstance().getProjects()) {
                TriggerBuilder tb;
                boolean changed = false;
                BuildTrigger bt = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (bt != null) {
                    for (BuildTriggerConfig c : bt.getConfigs()) {
                        changed |= c.onJobRenamed(oldName, newName);
                    }
                }
                if ((tb = (TriggerBuilder)p.getBuildersList().get(TriggerBuilder.class)) != null) {
                    for (BlockableBuildTriggerConfig co : tb.getConfigs()) {
                        changed |= co.onJobRenamed(oldName, newName);
                    }
                }
                if (!changed) continue;
                try {
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during rename from " + oldName + " to " + newName, e);
                }
            }
        }

        public void onDeleted(Item item) {
            for (Project p : Hudson.getInstance().getProjects()) {
                TriggerBuilder tb;
                String oldName = item.getName();
                boolean changed = false;
                BuildTrigger bt = (BuildTrigger)p.getPublishersList().get(BuildTrigger.class);
                if (bt != null) {
                    ListIterator<BuildTriggerConfig> btc = bt.getConfigs().listIterator();
                    while (btc.hasNext()) {
                        BuildTriggerConfig c = btc.next();
                        if (!c.onDeleted(oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        btc.remove();
                    }
                }
                if ((tb = (TriggerBuilder)p.getBuildersList().get(TriggerBuilder.class)) != null) {
                    ListIterator<BlockableBuildTriggerConfig> bbtc = tb.getConfigs().listIterator();
                    while (bbtc.hasNext()) {
                        BuildTriggerConfig c = bbtc.next();
                        if (!c.onDeleted(oldName)) continue;
                        changed = true;
                        if (c.getProjects().length() != 0) continue;
                        bbtc.remove();
                    }
                }
                if (!changed) continue;
                try {
                    if (bt != null && bt.getConfigs().isEmpty()) {
                        p.getPublishersList().remove((Object)bt);
                    }
                    if (tb != null && tb.getConfigs().isEmpty()) {
                        p.getBuildersList().remove((Object)tb);
                    }
                    p.save();
                }
                catch (IOException e) {
                    Logger.getLogger(RenameListener.class.getName()).log(Level.WARNING, "Failed to persist project setting during remove of " + oldName, e);
                }
            }
        }
    }
}

