/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.groovy;

import groovy.lang.Binding;
import groovy.lang.Closure;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.Hudson;
import hudson.remoting.ChannelClosedException;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Locale;
import jline.Terminal;
import jline.UnsupportedTerminal;
import org.codehaus.groovy.tools.shell.Groovysh;
import org.codehaus.groovy.tools.shell.IO;
import org.codehaus.groovy.tools.shell.Shell;
import org.codehaus.groovy.tools.shell.util.XmlCommandRegistrar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Extension
public class GroovyshCommand
extends CLICommand {
    public String getShortDescription() {
        return "Runs an interactive groovy shell";
    }

    public int main(List<String> args, Locale locale, InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        System.setProperty("jline.terminal", UnsupportedTerminal.class.getName());
        Terminal.resetTerminal();
        Groovysh shell = this.createShell(stdin, stdout, stderr);
        return shell.run(args.toArray(new String[args.size()]));
    }

    protected Groovysh createShell(InputStream stdin, PrintStream stdout, PrintStream stderr) {
        Binding binding = new Binding();
        binding.setProperty("out", (Object)new PrintWriter(stdout, true));
        binding.setProperty("hudson", (Object)Hudson.getInstance());
        IO io = new IO((InputStream)new BufferedInputStream(stdin), (OutputStream)stdout, (OutputStream)stderr);
        final ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Closure registrar = new Closure(null, null){

            public Object doCall(Object[] args) {
                assert (args.length == 1);
                assert (args[0] instanceof Shell);
                Shell shell = (Shell)args[0];
                XmlCommandRegistrar r = new XmlCommandRegistrar(shell, cl);
                r.register(GroovyshCommand.class.getResource("commands.xml"));
                return null;
            }
        };
        Groovysh shell = new Groovysh(cl, binding, io, registrar);
        shell.getImports().add("import hudson.model.*");
        final Closure originalErrorHook = shell.getErrorHook();
        shell.setErrorHook(new Closure(shell, shell){

            public Object doCall(Object[] args) throws ChannelClosedException {
                if (args.length == 1 && args[0] instanceof ChannelClosedException) {
                    throw (ChannelClosedException)args[0];
                }
                return originalErrorHook.call(args);
            }
        });
        return shell;
    }

    protected int run() {
        throw new UnsupportedOperationException();
    }
}

