/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.Extension;
import java.io.PrintWriter;
import java.util.Map;
import org.eclipse.hudson.script.ScriptSupport;
import org.eclipse.hudson.script.ScriptSupportDescriptor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroovyScriptSupport
extends ScriptSupport {
    public boolean hasSupport(String scriptType) {
        return ScriptSupport.SCRIPT_GROOVY.equals(scriptType);
    }

    public String getType() {
        return ScriptSupport.SCRIPT_GROOVY;
    }

    public Object evaluateExpression(String expression) {
        return this.evaluateExpression(expression, null);
    }

    public Object evaluateExpression(String expression, Map<String, Object> variableMap) {
        Binding binding = new Binding();
        if (variableMap != null) {
            for (Map.Entry<String, Object> e : variableMap.entrySet()) {
                binding.setVariable(e.getKey(), e.getValue());
            }
        }
        GroovyShell shell = new GroovyShell(binding);
        return shell.evaluate(expression);
    }

    public void evaluate(String script, PrintWriter printWriter) {
        this.evaluate(script, null, printWriter);
    }

    public void evaluate(String script, Map<String, Object> variableMap, PrintWriter printWriter) {
        this.evaluate(null, script, variableMap, printWriter);
    }

    public void evaluate(ClassLoader parentClassLoader, String script, Map<String, Object> variableMap, PrintWriter printWriter) {
        if (parentClassLoader == null) {
            parentClassLoader = Thread.currentThread().getContextClassLoader();
        }
        GroovyShell shell = new GroovyShell(parentClassLoader);
        if (variableMap != null) {
            for (Map.Entry<String, Object> e : variableMap.entrySet()) {
                shell.setVariable(e.getKey(), e.getValue());
            }
        }
        shell.setVariable("out", (Object)printWriter);
        try {
            Object output = shell.evaluate(script);
            if (output != null) {
                printWriter.print(output);
            }
        }
        catch (Throwable t) {
            t.printStackTrace(printWriter);
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ScriptSupportDescriptor {
        public String getDisplayName() {
            return "Groovy";
        }

        public String getConfigPage() {
            return this.getViewPage(this.clazz, "scriptConsole.jelly");
        }
    }
}

