/*
 * Decompiled with CFR 0.152.
 */
package org.hudsonci.plugins.groovy;

import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.Item;
import hudson.model.Run;
import hudson.remoting.Callable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.kohsuke.args4j.Argument;
import org.kohsuke.args4j.CmdLineException;

@Extension
public class GroovyCommand
extends CLICommand
implements Serializable {
    @Argument(metaVar="SCRIPT", usage="Script to be executed. File, URL or '=' to represent stdin.")
    public String script;
    @Argument(index=1)
    public List<String> remaining = new ArrayList<String>();

    public String getShortDescription() {
        return "Executes the specified Groovy script";
    }

    protected int run() throws Exception {
        Hudson.getInstance().checkPermission(Hudson.ADMINISTER);
        Binding binding = new Binding();
        binding.setProperty("out", (Object)new PrintWriter(this.stdout, true));
        String j = this.getClientEnvironmentVariable("JOB_NAME");
        if (j != null) {
            Item job = Hudson.getInstance().getItemByFullName(j);
            binding.setProperty("currentJob", (Object)job);
            String b = this.getClientEnvironmentVariable("BUILD_NUMBER");
            if (b != null && job instanceof AbstractProject) {
                Run r = ((AbstractProject)job).getBuildByNumber(Integer.parseInt(b));
                binding.setProperty("currentBuild", (Object)r);
            }
        }
        GroovyShell groovy = new GroovyShell(binding);
        groovy.run(this.loadScript(), "RemoteClass", this.remaining.toArray(new String[this.remaining.size()]));
        return 0;
    }

    private String loadScript() throws CmdLineException, IOException, InterruptedException {
        if (this.script == null) {
            throw new CmdLineException(null, "No script is specified");
        }
        return (String)this.channel.call((Callable)new Callable<String, IOException>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public String call() throws IOException {
                URL url;
                if (GroovyCommand.this.script.equals("=")) {
                    return IOUtils.toString((InputStream)System.in);
                }
                File f = new File(GroovyCommand.this.script);
                if (f.exists()) {
                    return FileUtils.readFileToString((File)f);
                }
                try {
                    url = new URL(GroovyCommand.this.script);
                }
                catch (MalformedURLException e) {
                    throw new AbortException("Unable to find a script " + GroovyCommand.this.script);
                }
                InputStream s = url.openStream();
                try {
                    String string = IOUtils.toString((InputStream)s);
                    return string;
                }
                finally {
                    s.close();
                }
            }
        });
    }
}

