/*
 * Decompiled with CFR 0.152.
 */
package net.uaznia.lukanus.hudson.plugins.gitparameter;

import hudson.EnvVars;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.AbstractProject;
import hudson.model.Hudson;
import hudson.model.ParameterDefinition;
import hudson.model.ParameterValue;
import hudson.model.ParametersDefinitionProperty;
import hudson.model.TaskListener;
import hudson.plugins.git.GitAPI;
import hudson.plugins.git.GitException;
import hudson.plugins.git.GitSCM;
import hudson.plugins.git.GitTool;
import hudson.plugins.git.Revision;
import hudson.remoting.Future;
import hudson.remoting.VirtualChannel;
import hudson.scm.SCM;
import hudson.util.StreamTaskListener;
import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import net.sf.json.JSONArray;
import net.sf.json.JSONObject;
import net.uaznia.lukanus.hudson.plugins.gitparameter.GitParameterValue;
import org.apache.commons.lang.StringUtils;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.transport.RemoteConfig;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.StaplerRequest;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GitParameterDefinition
extends ParameterDefinition
implements Comparable<GitParameterDefinition> {
    private static final long serialVersionUID = 9157832967140868122L;
    public static final String PARAMETER_TYPE_TAG = "PT_TAG";
    public static final String PARAMETER_TYPE_REVISION = "PT_REVISION";
    private final UUID uuid;
    private String type;
    private String branch;
    private String errorMessage;
    private String defaultValue;
    public boolean hasError = false;

    @DataBoundConstructor
    public GitParameterDefinition(String name, String type, String defaultValue, String description, String branch) {
        super(name, description);
        this.type = type;
        this.defaultValue = defaultValue;
        this.branch = branch;
        this.uuid = UUID.randomUUID();
    }

    public ParameterValue createValue(StaplerRequest request) {
        String[] value = request.getParameterValues(this.getName());
        if (value == null) {
            return this.getDefaultParameterValue();
        }
        return null;
    }

    public ParameterValue createValue(StaplerRequest request, JSONObject jO) {
        Object value = jO.get("value");
        String strValue = "";
        if (value instanceof String) {
            strValue = (String)value;
        } else if (value instanceof JSONArray) {
            JSONArray jsonValues = (JSONArray)value;
            for (int i = 0; i < jsonValues.size(); ++i) {
                strValue = strValue + jsonValues.getString(i);
                if (i >= jsonValues.size() - 1) continue;
                strValue = strValue + ",";
            }
        }
        if ("".equals(strValue)) {
            strValue = this.defaultValue;
        }
        GitParameterValue gitParameterValue = new GitParameterValue(jO.getString("name"), strValue);
        return gitParameterValue;
    }

    public ParameterValue getDefaultParameterValue() {
        String defValue = this.getDefaultValue();
        if (!StringUtils.isBlank((String)defValue)) {
            return new GitParameterValue(this.getName(), defValue);
        }
        return super.getDefaultParameterValue();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (type.equals(PARAMETER_TYPE_TAG) || type.equals(PARAMETER_TYPE_REVISION)) {
            this.type = type;
        } else {
            this.errorMessage = "wrongType";
        }
    }

    public String getBranch() {
        return this.branch;
    }

    public void setBranch(String nameOfBranch) {
        this.branch = nameOfBranch;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public AbstractProject<?, ?> getParentProject() {
        AbstractProject context = null;
        List jobs = Hudson.getInstance().getItems(AbstractProject.class);
        block0: for (AbstractProject project : jobs) {
            List parameterDefinitions;
            ParametersDefinitionProperty property = (ParametersDefinitionProperty)project.getProperty(ParametersDefinitionProperty.class);
            if (property == null || (parameterDefinitions = property.getParameterDefinitions()) == null) continue;
            for (ParameterDefinition pd : parameterDefinitions) {
                if (!(pd instanceof GitParameterDefinition) || ((GitParameterDefinition)pd).compareTo(this) != 0) continue;
                context = project;
                continue block0;
            }
        }
        return context;
    }

    @Override
    public int compareTo(GitParameterDefinition pd) {
        if (pd.uuid.equals(this.uuid)) {
            return 0;
        }
        return -1;
    }

    private String getGitExe() {
        GitTool[] installations;
        String defaultGitExe = File.separatorChar != '/' ? "git.exe" : "git";
        GitTool.DescriptorImpl descriptor = (GitTool.DescriptorImpl)Hudson.getInstance().getDescriptor(GitTool.class);
        for (GitTool gt : installations = (GitTool[])descriptor.getInstallations()) {
            if (gt.getGitExe() == null) continue;
            defaultGitExe = gt.getGitExe();
            break;
        }
        return defaultGitExe;
    }

    public Map<String, String> generateContents(String contenttype) throws IOException, InterruptedException, ExecutionException {
        LinkedHashMap<String, String> revTagMap = new LinkedHashMap<String, String>();
        this.hasError = false;
        AbstractProject<?, ?> project = this.getParentProject();
        if (project.getSomeBuildWithWorkspace() == null) {
            this.errorMessage = "No workspace yet!. Perform at least one build to create workspace.";
            this.hasError = true;
            revTagMap.put(this.errorMessage, this.errorMessage);
            return revTagMap;
        }
        SCM scm = project.getScm();
        if (!(scm instanceof GitSCM)) {
            this.errorMessage = "No Git configured in this job.";
            this.hasError = true;
            revTagMap.put(this.errorMessage, this.errorMessage);
            return revTagMap;
        }
        GitSCM git = (GitSCM)scm;
        final String gitExe = this.getGitExe();
        for (final RemoteConfig repository : git.getRepositories()) {
            FilePath workingDirectory = project.getSomeBuildWithWorkspace().getWorkspace();
            Future future = workingDirectory.actAsync((FilePath.FileCallable)new FilePath.FileCallable<Map>(){
                private static final long serialVersionUID = 1L;

                public Map invoke(File workspace, VirtualChannel channel) throws IOException {
                    LinkedHashMap<String, String> revTagMap;
                    block8: {
                        GitAPI newgit;
                        block7: {
                            newgit = new GitAPI(gitExe, new FilePath(workspace), (TaskListener)new StreamTaskListener(System.out), new EnvVars());
                            revTagMap = new LinkedHashMap<String, String>();
                            try {
                                newgit.fetch(repository);
                            }
                            catch (GitException ge) {
                                newgit.clone(repository);
                            }
                            if (!GitParameterDefinition.this.type.equalsIgnoreCase(GitParameterDefinition.PARAMETER_TYPE_REVISION)) break block7;
                            List oid = GitParameterDefinition.this.branch != null && !GitParameterDefinition.this.branch.isEmpty() ? newgit.revListBranch(GitParameterDefinition.this.branch) : newgit.revListAll();
                            for (ObjectId noid : oid) {
                                Revision r = new Revision(noid);
                                List details = newgit.showRevision(r);
                                String author = "";
                                for (String detail : details) {
                                    if (!detail.startsWith("author")) continue;
                                    author = detail;
                                    break;
                                }
                                String[] authorDate = author.split(">");
                                String authorInfo = authorDate[0].replaceFirst("author ", "").replaceFirst("committer ", "") + ">";
                                String goodDate = "";
                                try {
                                    String totmp = authorDate[1].trim();
                                    totmp = totmp.contains("+") ? totmp.split("\\+")[0].trim() : totmp.split("\\-")[0].trim();
                                    long timestamp = Long.parseLong(totmp, 10) * 1000L;
                                    Date date = new Date();
                                    date.setTime(timestamp);
                                    goodDate = new SimpleDateFormat("yyyy-MM-dd hh:mm").format(date);
                                }
                                catch (Exception e) {
                                    e.toString();
                                }
                                revTagMap.put(r.getSha1String(), r.getSha1String() + " " + authorInfo + " " + goodDate);
                            }
                            break block8;
                        }
                        if (!GitParameterDefinition.this.type.equalsIgnoreCase(GitParameterDefinition.PARAMETER_TYPE_TAG)) break block8;
                        for (String tagName : newgit.getTagNames("*")) {
                            revTagMap.put(tagName, tagName);
                        }
                    }
                    return revTagMap;
                }
            });
            revTagMap.putAll((Map)future.get());
        }
        return revTagMap;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Map<String, String> getRevisionMap() throws IOException, InterruptedException, ExecutionException {
        return this.generateContents(PARAMETER_TYPE_REVISION);
    }

    public Map<String, String> getTagMap() throws IOException, InterruptedException, ExecutionException {
        return this.generateContents(PARAMETER_TYPE_TAG);
    }

    @Extension
    public static class DescriptorImpl
    extends ParameterDefinition.ParameterDescriptor {
        public String getDisplayName() {
            return "Git Parameter";
        }
    }
}

