/*
 * Decompiled with CFR 0.152.
 */
package hudson.os.windows;

import hudson.tools.JDKInstaller;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.util.Arrays;
import java.util.List;
import jcifs.smb.NtlmPasswordAuthentication;
import jcifs.smb.SmbFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WindowsRemoteFileSystem
implements JDKInstaller.FileSystem {
    private final String hostName;
    private final NtlmPasswordAuthentication auth;

    public WindowsRemoteFileSystem(String hostName, NtlmPasswordAuthentication auth) {
        this.hostName = hostName;
        this.auth = auth;
    }

    private SmbFile $(String path) throws MalformedURLException {
        return new SmbFile("smb://" + this.hostName + "/" + path.replace('\\', '/').replace(':', '$') + "/", this.auth);
    }

    public void delete(String file) throws IOException, InterruptedException {
        this.$(file).delete();
    }

    public void chmod(String file, int mode) throws IOException, InterruptedException {
    }

    public InputStream read(String file) throws IOException {
        return this.$(file).getInputStream();
    }

    public List<String> listSubDirectories(String dir) throws IOException, InterruptedException {
        return Arrays.asList(this.$(dir).list());
    }

    public void pullUp(String from, String to) throws IOException, InterruptedException {
        SmbFile src = this.$(from);
        SmbFile dst = this.$(to);
        for (SmbFile e : src.listFiles()) {
            e.renameTo(new SmbFile(dst, e.getName()));
        }
        src.delete();
    }

    public void mkdirs(String path) throws IOException {
        this.$(path).mkdirs();
    }
}

