/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko.xerces.xni.parser;

import org.htmlunit.cyberneko.xerces.xni.XMLLocator;
import org.htmlunit.cyberneko.xerces.xni.XNIException;

public class XMLParseException
extends XNIException {
    private static final long serialVersionUID = -1306660736099956209L;
    private String fPublicId;
    private String fLiteralSystemId;
    private String fExpandedSystemId;
    private String fBaseSystemId;
    private int fLineNumber = -1;
    private int fColumnNumber = -1;
    private int fCharacterOffset = -1;

    public XMLParseException(XMLLocator locator, String message) {
        super(message);
        if (locator != null) {
            this.fPublicId = locator.getPublicId();
            this.fLiteralSystemId = locator.getLiteralSystemId();
            this.fExpandedSystemId = locator.getExpandedSystemId();
            this.fBaseSystemId = locator.getBaseSystemId();
            this.fLineNumber = locator.getLineNumber();
            this.fColumnNumber = locator.getColumnNumber();
            this.fCharacterOffset = locator.getCharacterOffset();
        }
    }

    public XMLParseException(XMLLocator locator, String message, Exception exception) {
        super(message, exception);
        if (locator != null) {
            this.fPublicId = locator.getPublicId();
            this.fLiteralSystemId = locator.getLiteralSystemId();
            this.fExpandedSystemId = locator.getExpandedSystemId();
            this.fBaseSystemId = locator.getBaseSystemId();
            this.fLineNumber = locator.getLineNumber();
            this.fColumnNumber = locator.getColumnNumber();
            this.fCharacterOffset = locator.getCharacterOffset();
        }
    }

    public String getPublicId() {
        return this.fPublicId;
    }

    public String getExpandedSystemId() {
        return this.fExpandedSystemId;
    }

    public String getLiteralSystemId() {
        return this.fLiteralSystemId;
    }

    public String getBaseSystemId() {
        return this.fBaseSystemId;
    }

    public int getLineNumber() {
        return this.fLineNumber;
    }

    public int getColumnNumber() {
        return this.fColumnNumber;
    }

    public int getCharacterOffset() {
        return this.fCharacterOffset;
    }

    @Override
    public String toString() {
        Exception exception;
        StringBuilder str = new StringBuilder();
        if (this.fPublicId != null) {
            str.append(this.fPublicId);
        }
        str.append(':');
        if (this.fLiteralSystemId != null) {
            str.append(this.fLiteralSystemId);
        }
        str.append(':');
        if (this.fExpandedSystemId != null) {
            str.append(this.fExpandedSystemId);
        }
        str.append(':');
        if (this.fBaseSystemId != null) {
            str.append(this.fBaseSystemId);
        }
        str.append(':');
        str.append(this.fLineNumber);
        str.append(':');
        str.append(this.fColumnNumber);
        str.append(':');
        str.append(this.fCharacterOffset);
        str.append(':');
        String message = this.getMessage();
        if (message == null && (exception = this.getException()) != null) {
            message = exception.getMessage();
        }
        if (message != null) {
            str.append(message);
        }
        return str.toString();
    }
}

