/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.cyberneko;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.htmlunit.cyberneko.HTMLComponent;
import org.htmlunit.cyberneko.HTMLElements;
import org.htmlunit.cyberneko.HTMLErrorReporter;
import org.htmlunit.cyberneko.HTMLScanner;
import org.htmlunit.cyberneko.HTMLTagBalancer;
import org.htmlunit.cyberneko.HTMLTagBalancingListener;
import org.htmlunit.cyberneko.filters.NamespaceBinder;
import org.htmlunit.cyberneko.xerces.util.ParserConfigurationSettings;
import org.htmlunit.cyberneko.xerces.xni.XMLDocumentHandler;
import org.htmlunit.cyberneko.xerces.xni.XNIException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLConfigurationException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLDocumentFilter;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLDocumentSource;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLErrorHandler;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLInputSource;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLParseException;
import org.htmlunit.cyberneko.xerces.xni.parser.XMLParserConfiguration;

public class HTMLConfiguration
extends ParserConfigurationSettings
implements XMLParserConfiguration {
    protected static final String NAMESPACES = "http://xml.org/sax/features/namespaces";
    protected static final String AUGMENTATIONS = "http://cyberneko.org/html/features/augmentations";
    protected static final String REPORT_ERRORS = "http://cyberneko.org/html/features/report-errors";
    protected static final String SIMPLE_ERROR_FORMAT = "http://cyberneko.org/html/features/report-errors/simple";
    protected static final String NAMES_ELEMS = "http://cyberneko.org/html/properties/names/elems";
    protected static final String NAMES_ATTRS = "http://cyberneko.org/html/properties/names/attrs";
    protected static final String FILTERS = "http://cyberneko.org/html/properties/filters";
    protected static final String ERROR_REPORTER = "http://cyberneko.org/html/properties/error-reporter";
    protected static final String ERROR_DOMAIN = "http://cyberneko.org/html";
    private XMLDocumentHandler fDocumentHandler;
    private XMLErrorHandler fErrorHandler;
    private boolean fCloseStream;
    private final List<HTMLComponent> fHTMLComponents = new ArrayList<HTMLComponent>(2);
    private final HTMLScanner fDocumentScanner = this.createDocumentScanner();
    private final HTMLTagBalancer fTagBalancer = new HTMLTagBalancer(this);
    private final NamespaceBinder fNamespaceBinder = new NamespaceBinder(this);
    private final HTMLErrorReporter fErrorReporter = new ErrorReporter();
    public final HTMLElements htmlElements_;

    public HTMLConfiguration() {
        this(new HTMLElements());
    }

    public HTMLConfiguration(HTMLElements htmlElements) {
        this.htmlElements_ = htmlElements;
        this.addComponent(this.fDocumentScanner);
        this.addComponent(this.fTagBalancer);
        this.addComponent(this.fNamespaceBinder);
        String[] recognizedFeatures = new String[]{AUGMENTATIONS, NAMESPACES, REPORT_ERRORS, SIMPLE_ERROR_FORMAT};
        this.addRecognizedFeatures(recognizedFeatures);
        this.setFeature(AUGMENTATIONS, false);
        this.setFeature(NAMESPACES, true);
        this.setFeature(REPORT_ERRORS, false);
        this.setFeature(SIMPLE_ERROR_FORMAT, false);
        String[] recognizedProperties = new String[]{NAMES_ELEMS, NAMES_ATTRS, FILTERS, ERROR_REPORTER};
        this.addRecognizedProperties(recognizedProperties);
        this.setProperty(NAMES_ELEMS, "default");
        this.setProperty(NAMES_ATTRS, "lower");
        this.setProperty(ERROR_REPORTER, this.fErrorReporter);
    }

    protected HTMLScanner createDocumentScanner() {
        return new HTMLScanner(this);
    }

    public void pushInputSource(XMLInputSource inputSource) {
        this.fDocumentScanner.pushInputSource(inputSource);
    }

    public void evaluateInputSource(XMLInputSource inputSource) {
        this.fDocumentScanner.evaluateInputSource(inputSource);
    }

    @Override
    public void setFeature(String featureId, boolean state) throws XMLConfigurationException {
        super.setFeature(featureId, state);
        for (HTMLComponent component : this.fHTMLComponents) {
            component.setFeature(featureId, state);
        }
    }

    @Override
    public void setProperty(String propertyId, Object value) throws XMLConfigurationException {
        XMLDocumentFilter[] filters;
        super.setProperty(propertyId, value);
        if (propertyId.equals(FILTERS) && (filters = (XMLDocumentFilter[])this.getProperty(FILTERS)) != null) {
            XMLDocumentFilter[] xMLDocumentFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                XMLDocumentFilter filter = xMLDocumentFilterArray[n2];
                if (filter instanceof HTMLComponent) {
                    this.addComponent((HTMLComponent)((Object)filter));
                }
                ++n2;
            }
        }
        for (HTMLComponent component : this.fHTMLComponents) {
            component.setProperty(propertyId, value);
        }
    }

    @Override
    public void setDocumentHandler(XMLDocumentHandler handler) {
        this.fDocumentHandler = handler;
        if (handler instanceof HTMLTagBalancingListener) {
            this.fTagBalancer.setTagBalancingListener((HTMLTagBalancingListener)((Object)handler));
        }
    }

    @Override
    public XMLDocumentHandler getDocumentHandler() {
        return this.fDocumentHandler;
    }

    @Override
    public void setErrorHandler(XMLErrorHandler handler) {
        this.fErrorHandler = handler;
    }

    @Override
    public XMLErrorHandler getErrorHandler() {
        return this.fErrorHandler;
    }

    @Override
    public void parse(XMLInputSource source) throws XNIException, IOException {
        this.setInputSource(source);
        this.parse(true);
    }

    @Override
    public void setInputSource(XMLInputSource inputSource) throws XMLConfigurationException, IOException {
        this.reset();
        this.fCloseStream = inputSource.getByteStream() == null && inputSource.getCharacterStream() == null;
        this.fDocumentScanner.setInputSource(inputSource);
    }

    @Override
    public boolean parse(boolean complete) throws XNIException, IOException {
        try {
            boolean more = this.fDocumentScanner.scanDocument(complete);
            if (!more) {
                this.cleanup();
            }
            return more;
        }
        catch (IOException | XNIException e) {
            this.cleanup();
            throw e;
        }
    }

    @Override
    public void cleanup() {
        this.fDocumentScanner.cleanup(this.fCloseStream);
    }

    protected void addComponent(HTMLComponent component) {
        int n;
        this.fHTMLComponents.add(component);
        String[] features = component.getRecognizedFeatures();
        this.addRecognizedFeatures(features);
        if (features != null) {
            String[] stringArray = features;
            n = features.length;
            int n2 = 0;
            while (n2 < n) {
                String feature = stringArray[n2];
                Boolean state = component.getFeatureDefault(feature);
                if (state != null) {
                    this.setFeature(feature, state);
                }
                ++n2;
            }
        }
        String[] properties = component.getRecognizedProperties();
        this.addRecognizedProperties(properties);
        if (properties != null) {
            String[] stringArray = properties;
            int n3 = properties.length;
            n = 0;
            while (n < n3) {
                String property = stringArray[n];
                Object value = component.getPropertyDefault(property);
                if (value != null) {
                    this.setProperty(property, value);
                }
                ++n;
            }
        }
    }

    protected void reset() throws XMLConfigurationException {
        for (HTMLComponent component : this.fHTMLComponents) {
            component.reset(this);
        }
        XMLDocumentSource lastSource = this.fDocumentScanner;
        if (this.getFeature(NAMESPACES)) {
            lastSource.setDocumentHandler(this.fNamespaceBinder);
            this.fNamespaceBinder.setDocumentSource(this.fTagBalancer);
            lastSource = this.fNamespaceBinder;
        }
        lastSource.setDocumentHandler(this.fTagBalancer);
        this.fTagBalancer.setDocumentSource(this.fDocumentScanner);
        lastSource = this.fTagBalancer;
        XMLDocumentFilter[] filters = (XMLDocumentFilter[])this.getProperty(FILTERS);
        if (filters != null) {
            XMLDocumentFilter[] xMLDocumentFilterArray = filters;
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                XMLDocumentFilter filter = xMLDocumentFilterArray[n2];
                filter.setDocumentSource(lastSource);
                lastSource.setDocumentHandler(filter);
                lastSource = filter;
                ++n2;
            }
        }
        lastSource.setDocumentHandler(this.fDocumentHandler);
    }

    protected class ErrorReporter
    implements HTMLErrorReporter {
        private ResourceBundle fErrorMessages;

        protected ErrorReporter() {
        }

        @Override
        public String formatMessage(String key, Object[] args) {
            if (!HTMLConfiguration.this.getFeature(HTMLConfiguration.SIMPLE_ERROR_FORMAT)) {
                if (this.fErrorMessages == null) {
                    this.fErrorMessages = ResourceBundle.getBundle("org/htmlunit/cyberneko/res/ErrorMessages");
                }
                try {
                    String value = this.fErrorMessages.getString(key);
                    return MessageFormat.format(value, args);
                }
                catch (MissingResourceException missingResourceException) {
                    // empty catch block
                }
            }
            return this.formatSimpleMessage(key, args);
        }

        @Override
        public void reportWarning(String key, Object[] args) throws XMLParseException {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.warning(HTMLConfiguration.ERROR_DOMAIN, key, this.createException(key, args));
            }
        }

        @Override
        public void reportError(String key, Object[] args) throws XMLParseException {
            if (HTMLConfiguration.this.fErrorHandler != null) {
                HTMLConfiguration.this.fErrorHandler.error(HTMLConfiguration.ERROR_DOMAIN, key, this.createException(key, args));
            }
        }

        protected XMLParseException createException(String key, Object[] args) {
            String message = this.formatMessage(key, args);
            return new XMLParseException(HTMLConfiguration.this.fDocumentScanner, message);
        }

        protected String formatSimpleMessage(String key, Object[] args) {
            StringBuilder str = new StringBuilder();
            str.append(HTMLConfiguration.ERROR_DOMAIN);
            str.append('#');
            str.append(key);
            if (args != null && args.length > 0) {
                str.append('\t');
                int i = 0;
                while (i < args.length) {
                    if (i > 0) {
                        str.append('\t');
                    }
                    str.append(args[i]);
                    ++i;
                }
            }
            return str.toString();
        }
    }
}

