/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.patterns;

import javax.xml.transform.TransformerException;
import org.htmlunit.xpath.Expression;
import org.htmlunit.xpath.XPathContext;
import org.htmlunit.xpath.XPathVisitor;
import org.htmlunit.xpath.objects.XObject;
import org.htmlunit.xpath.patterns.NodeTest;
import org.htmlunit.xpath.patterns.StepPattern;

public class UnionPattern
extends Expression {
    private StepPattern[] patterns_;

    @Override
    public boolean canTraverseOutsideSubtree() {
        if (null != this.patterns_) {
            for (StepPattern pattern : this.patterns_) {
                if (!pattern.canTraverseOutsideSubtree()) continue;
                return true;
            }
        }
        return false;
    }

    public void setPatterns(StepPattern[] patterns) {
        this.patterns_ = patterns;
        if (null != patterns) {
            for (StepPattern pattern : patterns) {
                pattern.exprSetParent(this);
            }
        }
    }

    @Override
    public XObject execute(XPathContext xctxt) throws TransformerException {
        XObject bestScore = null;
        for (StepPattern pattern : this.patterns_) {
            XObject score = pattern.execute(xctxt);
            if (score == NodeTest.SCORE_NONE) continue;
            if (null == bestScore) {
                bestScore = score;
                continue;
            }
            if (!(score.num() > bestScore.num())) continue;
            bestScore = score;
        }
        if (null == bestScore) {
            bestScore = NodeTest.SCORE_NONE;
        }
        return bestScore;
    }

    @Override
    public void callVisitors(XPathVisitor visitor) {
        visitor.visitUnionPattern();
        if (null != this.patterns_) {
            for (StepPattern pattern : this.patterns_) {
                pattern.callVisitors(visitor);
            }
        }
    }

    @Override
    public boolean deepEquals(Expression expr) {
        if (!this.isSameClass(expr)) {
            return false;
        }
        UnionPattern up = (UnionPattern)expr;
        if (null != this.patterns_) {
            int n = this.patterns_.length;
            if (null == up.patterns_ || up.patterns_.length != n) {
                return false;
            }
            for (int i = 0; i < n; ++i) {
                if (this.patterns_[i].deepEquals(up.patterns_[i])) continue;
                return false;
            }
        } else if (up.patterns_ != null) {
            return false;
        }
        return true;
    }
}

