/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.xpath.xml.dtm.ref;

import java.util.ArrayList;
import java.util.List;
import org.htmlunit.xpath.NodeSet;
import org.htmlunit.xpath.xml.dtm.DTM;
import org.htmlunit.xpath.xml.dtm.ref.DTMChildIterNodeList;
import org.htmlunit.xpath.xml.dtm.ref.DTMNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import org.w3c.dom.TypeInfo;
import org.w3c.dom.UserDataHandler;

public class DTMNodeProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment,
DocumentFragment {
    public final DTM dtm_;
    final int node_;
    private static final String EMPTYSTRING = "";
    static final DOMImplementation implementation = new DTMNodeProxyImplementation();
    protected String fDocumentURI;
    private boolean xmlStandalone;
    private String xmlVersion;

    public DTMNodeProxy(DTM dtm, int node) {
        this.dtm_ = dtm;
        this.node_ = node;
    }

    public final int getDTMNodeNumber() {
        return this.node_;
    }

    public final boolean equals(Node node) {
        try {
            DTMNodeProxy dtmp = (DTMNodeProxy)node;
            return dtmp.node_ == this.node_ && dtmp.dtm_ == this.dtm_;
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    public final boolean equals(Object node) {
        try {
            return this.equals((Node)node);
        }
        catch (ClassCastException cce) {
            return false;
        }
    }

    @Override
    public final String getNodeName() {
        return this.dtm_.getNodeName(this.node_);
    }

    @Override
    public final String getTarget() {
        return this.dtm_.getNodeName(this.node_);
    }

    @Override
    public final String getLocalName() {
        return this.dtm_.getLocalName(this.node_);
    }

    @Override
    public final String getPrefix() {
        return this.dtm_.getPrefix(this.node_);
    }

    @Override
    public final void setPrefix(String prefix) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final String getNamespaceURI() {
        return this.dtm_.getNamespaceURI(this.node_);
    }

    @Override
    public final boolean isSupported(String feature, String version) {
        return implementation.hasFeature(feature, version);
    }

    @Override
    public final String getNodeValue() throws DOMException {
        return this.dtm_.getNodeValue(this.node_);
    }

    @Override
    public final void setNodeValue(String nodeValue) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final short getNodeType() {
        return this.dtm_.getNodeType(this.node_);
    }

    @Override
    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int newnode = this.dtm_.getParent(this.node_);
        return newnode == -1 ? null : this.dtm_.getNode(newnode);
    }

    @Override
    public final NodeList getChildNodes() {
        return new DTMChildIterNodeList(this.dtm_, this.node_);
    }

    @Override
    public final Node getFirstChild() {
        int newnode = this.dtm_.getFirstChild(this.node_);
        return newnode == -1 ? null : this.dtm_.getNode(newnode);
    }

    @Override
    public final Node getLastChild() {
        int newnode = this.dtm_.getLastChild(this.node_);
        return newnode == -1 ? null : this.dtm_.getNode(newnode);
    }

    @Override
    public final Node getPreviousSibling() {
        int newnode = this.dtm_.getPreviousSibling(this.node_);
        return newnode == -1 ? null : this.dtm_.getNode(newnode);
    }

    @Override
    public final Node getNextSibling() {
        if (this.dtm_.getNodeType(this.node_) == 2) {
            return null;
        }
        int newnode = this.dtm_.getNextSibling(this.node_);
        return newnode == -1 ? null : this.dtm_.getNode(newnode);
    }

    @Override
    public final NamedNodeMap getAttributes() {
        return new DTMNamedNodeMap(this.dtm_, this.node_);
    }

    @Override
    public boolean hasAttribute(String name) {
        return -1 != this.dtm_.getAttributeNode(this.node_, null, name);
    }

    @Override
    public boolean hasAttributeNS(String namespaceURI, String localName) {
        return -1 != this.dtm_.getAttributeNode(this.node_, namespaceURI, localName);
    }

    @Override
    public final Document getOwnerDocument() {
        return (Document)this.dtm_.getNode(this.dtm_.getOwnerDocument(this.node_));
    }

    @Override
    public final Node insertBefore(Node newChild, Node refChild) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final Node replaceChild(Node newChild, Node oldChild) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final Node removeChild(Node oldChild) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final Node appendChild(Node newChild) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final boolean hasChildNodes() {
        return -1 != this.dtm_.getFirstChild(this.node_);
    }

    @Override
    public final Node cloneNode(boolean deep) {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final DocumentType getDoctype() {
        return null;
    }

    @Override
    public final DOMImplementation getImplementation() {
        return implementation;
    }

    @Override
    public final Element getDocumentElement() {
        int dochandle = this.dtm_.getDocument();
        int elementhandle = -1;
        int kidhandle = this.dtm_.getFirstChild(dochandle);
        while (kidhandle != -1) {
            switch (this.dtm_.getNodeType(kidhandle)) {
                case 1: {
                    if (elementhandle != -1) {
                        elementhandle = -1;
                        kidhandle = this.dtm_.getLastChild(dochandle);
                        break;
                    }
                    elementhandle = kidhandle;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    elementhandle = -1;
                    kidhandle = this.dtm_.getLastChild(dochandle);
                }
            }
            kidhandle = this.dtm_.getNextSibling(kidhandle);
        }
        if (elementhandle == -1) {
            throw new DOMException(9, EMPTYSTRING);
        }
        return (Element)this.dtm_.getNode(elementhandle);
    }

    @Override
    public final Element createElement(String tagName) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final DocumentFragment createDocumentFragment() {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Text createTextNode(String data) {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Comment createComment(String data) {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final CDATASection createCDATASection(String data) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final ProcessingInstruction createProcessingInstruction(String target, String data) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Attr createAttribute(String name) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final EntityReference createEntityReference(String name) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final NodeList getElementsByTagName(String tagname) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node retNode = this.dtm_.getNode(this.node_);
        if (retNode != null) {
            boolean isTagNameWildCard = "*".equals(tagname);
            if (1 == retNode.getNodeType()) {
                NodeList nodeList = retNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.traverseChildren(nodes, nodeList.item(i), tagname, isTagNameWildCard);
                }
            } else if (9 == retNode.getNodeType()) {
                this.traverseChildren(nodes, this.dtm_.getNode(this.node_), tagname, isTagNameWildCard);
            }
        }
        return new NodeSet(nodes);
    }

    private void traverseChildren(List<Node> listVector, Node tempNode, String tagname, boolean isTagNameWildCard) {
        if (tempNode != null) {
            if (tempNode.getNodeType() == 1 && (isTagNameWildCard || tempNode.getNodeName().equals(tagname))) {
                listVector.add(tempNode);
            }
            if (tempNode.hasChildNodes()) {
                NodeList nodeList = tempNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.traverseChildren(listVector, nodeList.item(i), tagname, isTagNameWildCard);
                }
            }
        }
    }

    @Override
    public final Node importNode(Node importedNode, boolean deep) throws DOMException {
        throw new DOMException(7, EMPTYSTRING);
    }

    @Override
    public final Element createElementNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Attr createAttributeNS(String namespaceURI, String qualifiedName) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final NodeList getElementsByTagNameNS(String namespaceURI, String localName) {
        ArrayList<Node> nodes = new ArrayList<Node>();
        Node retNode = this.dtm_.getNode(this.node_);
        if (retNode != null) {
            boolean isNamespaceURIWildCard = "*".equals(namespaceURI);
            boolean isLocalNameWildCard = "*".equals(localName);
            if (1 == retNode.getNodeType()) {
                NodeList nodeList = retNode.getChildNodes();
                for (int i = 0; i < nodeList.getLength(); ++i) {
                    this.traverseChildren(nodes, nodeList.item(i), namespaceURI, localName, isNamespaceURIWildCard, isLocalNameWildCard);
                }
            } else if (9 == retNode.getNodeType()) {
                this.traverseChildren(nodes, this.dtm_.getNode(this.node_), namespaceURI, localName, isNamespaceURIWildCard, isLocalNameWildCard);
            }
        }
        return new NodeSet(nodes);
    }

    private void traverseChildren(List<Node> listVector, Node tempNode, String namespaceURI, String localname, boolean isNamespaceURIWildCard, boolean isLocalNameWildCard) {
        if (tempNode != null) {
            if (tempNode.getNodeType() == 1 && (isLocalNameWildCard || tempNode.getLocalName().equals(localname))) {
                String nsURI = tempNode.getNamespaceURI();
                if (namespaceURI == null && nsURI == null || isNamespaceURIWildCard || namespaceURI != null && namespaceURI.equals(nsURI)) {
                    listVector.add(tempNode);
                }
            }
            if (tempNode.hasChildNodes()) {
                NodeList nl = tempNode.getChildNodes();
                for (int i = 0; i < nl.getLength(); ++i) {
                    this.traverseChildren(listVector, nl.item(i), namespaceURI, localname, isNamespaceURIWildCard, isLocalNameWildCard);
                }
            }
        }
    }

    @Override
    public final Element getElementById(String elementId) {
        return (Element)this.dtm_.getNode(this.dtm_.getElementById(elementId));
    }

    @Override
    public final Text splitText(int offset) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final String getData() throws DOMException {
        return this.dtm_.getNodeValue(this.node_);
    }

    @Override
    public final void setData(String data) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final int getLength() {
        return this.dtm_.getNodeValue(this.node_).length();
    }

    @Override
    public final String substringData(int offset, int count) throws DOMException {
        return this.getData().substring(offset, offset + count);
    }

    @Override
    public final void appendData(String arg) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final void insertData(int offset, String arg) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final void deleteData(int offset, int count) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final void replaceData(int offset, int count, String arg) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final String getTagName() {
        return this.dtm_.getNodeName(this.node_);
    }

    @Override
    public final String getAttribute(String name) {
        DTMNamedNodeMap map = new DTMNamedNodeMap(this.dtm_, this.node_);
        Node n = map.getNamedItem(name);
        return null == n ? EMPTYSTRING : n.getNodeValue();
    }

    @Override
    public final void setAttribute(String name, String value) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final void removeAttribute(String name) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Attr getAttributeNode(String name) {
        DTMNamedNodeMap map = new DTMNamedNodeMap(this.dtm_, this.node_);
        return (Attr)map.getNamedItem(name);
    }

    @Override
    public final Attr setAttributeNode(Attr newAttr) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Attr removeAttributeNode(Attr oldAttr) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public boolean hasAttributes() {
        return -1 != this.dtm_.getFirstAttribute(this.node_);
    }

    @Override
    public final void normalize() {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final String getAttributeNS(String namespaceURI, String localName) {
        Node retNode = null;
        int n = this.dtm_.getAttributeNode(this.node_, namespaceURI, localName);
        if (n != -1) {
            retNode = this.dtm_.getNode(n);
        }
        return null == retNode ? EMPTYSTRING : retNode.getNodeValue();
    }

    @Override
    public final void setAttributeNS(String namespaceURI, String qualifiedName, String value) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final void removeAttributeNS(String namespaceURI, String localName) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Attr getAttributeNodeNS(String namespaceURI, String localName) {
        Attr retAttr = null;
        int n = this.dtm_.getAttributeNode(this.node_, namespaceURI, localName);
        if (n != -1) {
            retAttr = (Attr)this.dtm_.getNode(n);
        }
        return retAttr;
    }

    @Override
    public final Attr setAttributeNodeNS(Attr newAttr) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final String getName() {
        return this.dtm_.getNodeName(this.node_);
    }

    @Override
    public final boolean getSpecified() {
        return true;
    }

    @Override
    public final String getValue() {
        return this.dtm_.getNodeValue(this.node_);
    }

    @Override
    public final void setValue(String value) {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public final Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            return null;
        }
        int newnode = this.dtm_.getParent(this.node_);
        return newnode == -1 ? null : (Element)this.dtm_.getNode(newnode);
    }

    @Override
    public Node adoptNode(Node source) throws DOMException {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public String getInputEncoding() {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public boolean getStrictErrorChecking() {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public void setStrictErrorChecking(boolean strictErrorChecking) {
        throw new DOMException(9, EMPTYSTRING);
    }

    @Override
    public Object setUserData(String key, Object data, UserDataHandler handler) {
        return this.getOwnerDocument().setUserData(key, data, handler);
    }

    @Override
    public Object getUserData(String key) {
        return this.getOwnerDocument().getUserData(key);
    }

    @Override
    public Object getFeature(String feature, String version) {
        return this.isSupported(feature, version) ? this : null;
    }

    @Override
    public boolean isEqualNode(Node arg) {
        if (arg == this) {
            return true;
        }
        if (arg.getNodeType() != this.getNodeType()) {
            return false;
        }
        if (this.getNodeName() == null ? arg.getNodeName() != null : !this.getNodeName().equals(arg.getNodeName())) {
            return false;
        }
        if (this.getLocalName() == null ? arg.getLocalName() != null : !this.getLocalName().equals(arg.getLocalName())) {
            return false;
        }
        if (this.getNamespaceURI() == null ? arg.getNamespaceURI() != null : !this.getNamespaceURI().equals(arg.getNamespaceURI())) {
            return false;
        }
        if (this.getPrefix() == null ? arg.getPrefix() != null : !this.getPrefix().equals(arg.getPrefix())) {
            return false;
        }
        if (this.getNodeValue() == null) {
            return arg.getNodeValue() == null;
        }
        return this.getNodeValue().equals(arg.getNodeValue());
    }

    @Override
    public String lookupNamespaceURI(String specifiedPrefix) {
        short type = this.getNodeType();
        switch (type) {
            case 1: {
                String namespace = this.getNamespaceURI();
                String prefix = this.getPrefix();
                if (namespace != null) {
                    if (specifiedPrefix == null && prefix == specifiedPrefix) {
                        return namespace;
                    }
                    if (prefix != null && prefix.equals(specifiedPrefix)) {
                        return namespace;
                    }
                }
                if (this.hasAttributes()) {
                    NamedNodeMap map = this.getAttributes();
                    int length = map.getLength();
                    for (int i = 0; i < length; ++i) {
                        Node attr = map.item(i);
                        String attrPrefix = attr.getPrefix();
                        String value = attr.getNodeValue();
                        namespace = attr.getNamespaceURI();
                        if (namespace == null || !namespace.equals("http://www.w3.org/2000/xmlns/")) continue;
                        if (specifiedPrefix == null && attr.getNodeName().equals("xmlns")) {
                            return value;
                        }
                        if (attrPrefix == null || !attrPrefix.equals("xmlns") || !attr.getLocalName().equals(specifiedPrefix)) continue;
                        return value;
                    }
                }
                return null;
            }
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupNamespaceURI(specifiedPrefix);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isDefaultNamespace(String namespaceURI) {
        return false;
    }

    @Override
    public String lookupPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        short type = this.getNodeType();
        switch (type) {
            case 6: 
            case 10: 
            case 11: 
            case 12: {
                return null;
            }
            case 2: {
                if (this.getOwnerElement().getNodeType() == 1) {
                    return this.getOwnerElement().lookupPrefix(namespaceURI);
                }
                return null;
            }
        }
        return null;
    }

    @Override
    public boolean isSameNode(Node other) {
        return this == other;
    }

    @Override
    public void setTextContent(String textContent) throws DOMException {
        this.setNodeValue(textContent);
    }

    @Override
    public String getTextContent() throws DOMException {
        return this.dtm_.getStringValue(this.node_).toString();
    }

    @Override
    public short compareDocumentPosition(Node other) throws DOMException {
        return 0;
    }

    @Override
    public String getBaseURI() {
        return null;
    }

    @Override
    public Node renameNode(Node n, String namespaceURI, String name) throws DOMException {
        return n;
    }

    @Override
    public void normalizeDocument() {
    }

    @Override
    public DOMConfiguration getDomConfig() {
        return null;
    }

    @Override
    public void setDocumentURI(String documentURI) {
        this.fDocumentURI = documentURI;
    }

    @Override
    public String getDocumentURI() {
        return this.fDocumentURI;
    }

    @Override
    public Text replaceWholeText(String content) throws DOMException {
        return null;
    }

    @Override
    public String getWholeText() {
        return null;
    }

    @Override
    public boolean isElementContentWhitespace() {
        return false;
    }

    @Override
    public void setIdAttribute(String name, boolean makeId) {
    }

    @Override
    public void setIdAttributeNode(Attr at, boolean makeId) {
    }

    @Override
    public void setIdAttributeNS(String namespaceURI, String localName, boolean makeId) {
    }

    @Override
    public TypeInfo getSchemaTypeInfo() {
        return null;
    }

    @Override
    public boolean isId() {
        return false;
    }

    @Override
    public String getXmlEncoding() {
        return null;
    }

    @Override
    public boolean getXmlStandalone() {
        return this.xmlStandalone;
    }

    @Override
    public void setXmlStandalone(boolean xmlStandalone) throws DOMException {
        this.xmlStandalone = xmlStandalone;
    }

    @Override
    public String getXmlVersion() {
        return this.xmlVersion;
    }

    @Override
    public void setXmlVersion(String xmlVersion) throws DOMException {
        this.xmlVersion = xmlVersion;
    }

    static class DTMNodeProxyImplementation
    implements DOMImplementation {
        DTMNodeProxyImplementation() {
        }

        @Override
        public DocumentType createDocumentType(String qualifiedName, String publicId, String systemId) {
            throw new DOMException(9, DTMNodeProxy.EMPTYSTRING);
        }

        @Override
        public Document createDocument(String namespaceURI, String qualfiedName, DocumentType doctype) {
            throw new DOMException(9, DTMNodeProxy.EMPTYSTRING);
        }

        @Override
        public boolean hasFeature(String feature, String version) {
            return !(!"CORE".equalsIgnoreCase(feature) && !"XML".equalsIgnoreCase(feature) || !"1.0".equals(version) && !"2.0".equals(version));
        }

        @Override
        public Object getFeature(String feature, String version) {
            return null;
        }
    }
}

