/*
 * Decompiled with CFR 0.152.
 */
package org.htmlunit.csp.value;

import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import org.htmlunit.csp.Constants;
import org.htmlunit.csp.url.URI;

public final class Host {
    private final String scheme_;
    private final String host_;
    private final int port_;
    private final String path_;

    private Host(String scheme, String host, int port, String path) {
        this.scheme_ = scheme;
        this.host_ = host;
        this.port_ = port;
        this.path_ = path;
    }

    public String getScheme() {
        return this.scheme_;
    }

    public String getHost() {
        return this.host_;
    }

    public int getPort() {
        return this.port_;
    }

    public String getPath() {
        return this.path_;
    }

    public static Optional<Host> parseHost(String value) {
        Matcher matcher = Constants.HOST_SOURCE_PATTERN.matcher(value);
        if (matcher.find()) {
            String portString;
            String scheme = matcher.group("scheme");
            if (scheme != null) {
                scheme = scheme.substring(0, scheme.length() - 3).toLowerCase(Locale.ROOT);
            }
            int port = (portString = matcher.group("port")) == null ? -1 : (":*".equals(portString) ? -200 : Integer.parseInt(portString.substring(1)));
            String host = matcher.group("host").toLowerCase(Locale.ROOT);
            String path = matcher.group("path");
            return Optional.of(new Host(scheme, host, port, path));
        }
        return Optional.empty();
    }

    public String toString() {
        boolean isDefaultPort = this.port_ == -1 || this.scheme_ != null && this.port_ == URI.defaultPortForProtocol(this.scheme_);
        return (this.scheme_ == null ? "" : this.scheme_ + "://") + this.host_ + (isDefaultPort ? "" : ":" + (this.port_ == -200 ? "*" : Integer.valueOf(this.port_))) + (this.path_ == null ? "" : this.path_);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Host that = (Host)o;
        return this.port_ == that.port_ && Objects.equals(this.scheme_, that.scheme_) && Objects.equals(this.host_, that.host_) && Objects.equals(this.path_, that.path_);
    }

    public int hashCode() {
        return Objects.hash(this.scheme_, this.host_, this.port_, this.path_);
    }
}

