/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.web.datasource.strategy;

import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.hswebframework.web.aop.MethodInterceptorContext;
import org.hswebframework.web.datasource.strategy.TableSwitchStrategyMatcher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public abstract class CachedTableSwitchStrategyMatcher
implements TableSwitchStrategyMatcher {
    private static final Logger log = LoggerFactory.getLogger(CachedTableSwitchStrategyMatcher.class);
    static Map<CacheKey, TableSwitchStrategyMatcher.Strategy> cache = new ConcurrentHashMap<CacheKey, TableSwitchStrategyMatcher.Strategy>();

    public abstract TableSwitchStrategyMatcher.Strategy createStrategyIfMatch(Class var1, Method var2);

    @Override
    public boolean match(Class target, Method method) {
        TableSwitchStrategyMatcher.Strategy strategy = this.createStrategyIfMatch(target, method);
        if (null != strategy) {
            if (log.isDebugEnabled()) {
                log.debug("create table switcher strategy:{} for method:{}", (Object)strategy, (Object)method);
            }
            CacheKey cacheKey = new CacheKey(target, method);
            cache.put(cacheKey, strategy);
            return true;
        }
        return false;
    }

    @Override
    public TableSwitchStrategyMatcher.Strategy getStrategy(MethodInterceptorContext context) {
        Method method = context.getMethod();
        Class target = ClassUtils.getUserClass((Object)context.getTarget());
        return cache.get(new CacheKey(target, method));
    }

    public static class CacheKey {
        private Class target;
        private Method method;

        public boolean equals(Object obj) {
            if (!(obj instanceof CacheKey)) {
                return false;
            }
            CacheKey target = (CacheKey)obj;
            return target.target == this.target && target.method == this.method;
        }

        public int hashCode() {
            int result = this.target != null ? this.target.hashCode() : 0;
            result = 31 * result + (this.method != null ? this.method.hashCode() : 0);
            return result;
        }

        public CacheKey(Class target, Method method) {
            this.target = target;
            this.method = method;
        }
    }
}

