/*
 * Decompiled with CFR 0.152.
 */
package org.hswebframework.utils;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.function.Supplier;
import org.hswebframework.utils.StringUtils;

public class MapUtils {
    public static boolean isNullOrEmpty(Map map) {
        return map == null || map.isEmpty();
    }

    public static Map<String, Object> removeEmptyValue(Map<String, Object> map) {
        HashMap<String, Object> newMap = new HashMap<String, Object>();
        if (map == null) {
            return newMap;
        }
        map.entrySet().stream().filter(entry -> !StringUtils.isNullOrEmpty(entry.getValue())).forEach(entry -> newMap.put((String)entry.getKey(), entry.getValue()));
        return newMap;
    }

    public static <K extends Comparable, V> Map<K, V> sortMapByKey(Map<K, V> data) {
        LinkedHashMap<Comparable, V> data_ = new LinkedHashMap<Comparable, V>();
        LinkedList<K> list = new LinkedList<K>(data.keySet());
        Collections.sort(list);
        for (Comparable k : list) {
            data_.put(k, data.get(k));
        }
        return data_;
    }

    public static <K, V> Map<K, V> merge(Map<K, V> map, Map<K, V> maps) {
        return MapUtils.merge(new HashMap(), map, maps);
    }

    public static <K, V> Map<K, V> merge(Map<K, V> target, Map<K, V> map, Map<K, V> ... maps) {
        target.putAll(map);
        for (int i = 0; i < maps.length; ++i) {
            target.putAll(maps[i]);
        }
        return target;
    }

    public static <K, V> Map<K, V> merge(Supplier<Map<K, V>> supplier, Map<K, V> map, Map<K, V> ... maps) {
        return MapUtils.merge(supplier.get(), map, maps);
    }
}

