/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.slf4j;

import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.slf4j.LevelledLocationAwareLoggerWrapper;
import org.hisrc.jsonix.slf4j.LevelledLoggerWrapper;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.spi.LocationAwareLogger;

public abstract class LevelledLoggerFactoryWrapper
implements ILoggerFactory {
    protected final ILoggerFactory loggerFactory;

    public LevelledLoggerFactoryWrapper(ILoggerFactory loggerFactory) {
        this.loggerFactory = (ILoggerFactory)Validate.notNull((Object)loggerFactory);
    }

    protected abstract int getLevel();

    public Logger getLogger(String name) {
        Logger logger = this.loggerFactory.getLogger(name);
        if (logger instanceof LocationAwareLogger) {
            return new LevelledLocationAwareLoggerWrapper((LocationAwareLogger)logger){

                @Override
                protected int getLevel() {
                    return LevelledLoggerFactoryWrapper.this.getLevel();
                }
            };
        }
        return new LevelledLoggerWrapper(logger){

            @Override
            protected int getLevel() {
                return LevelledLoggerFactoryWrapper.this.getLevel();
            }
        };
    }
}

