/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.jsonschema;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonObjectBuilder;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.json.util.JsonBuilderUtils;
import org.hisrc.jsonix.json.util.JsonObjectBuildable;

public class JsonSchemaBuilder
implements JsonObjectBuildable {
    private String $ref;
    private String id;
    private String $schema;
    private String title;
    private String description;
    private Object _default;
    private String format;
    private BigDecimal multipleOf;
    private BigDecimal maximum;
    private Boolean exclusiveMaximum;
    private BigDecimal minimum;
    private Boolean exclusiveMinimum;
    private BigInteger maxLength;
    private BigInteger minLength;
    private String pattern;
    private Boolean hasAdditionalItems;
    private JsonSchemaBuilder additionalItem;
    private List<JsonSchemaBuilder> items;
    private BigInteger minItems;
    private BigInteger maxItems;
    private Boolean uniqueItems;
    private BigInteger maxProperties;
    private BigInteger minProperties;
    private Set<String> required;
    private JsonSchemaBuilder additionalProperties;
    private Boolean hasAdditionalProperties;
    private Map<String, JsonSchemaBuilder> definitions;
    private Map<String, JsonSchemaBuilder> properties;
    private Map<String, JsonSchemaBuilder> patternProperties;
    private Map<String, Set<String>> propertyDependencies;
    private Map<String, JsonSchemaBuilder> schemaDependencies;
    private Set<Object> _enum;
    private Set<String> types;
    private List<JsonSchemaBuilder> allOf;
    private List<JsonSchemaBuilder> anyOf;
    private List<JsonSchemaBuilder> oneOf;
    private JsonSchemaBuilder not;
    private Map<String, Object> anyProperties;

    public JsonSchemaBuilder addRef(String $ref) {
        Validate.notNull((Object)$ref);
        this.$ref = $ref;
        return this;
    }

    public JsonSchemaBuilder addId(String id) {
        this.id = id;
        return this;
    }

    public JsonSchemaBuilder addSchema(String $schema) {
        Validate.notNull((Object)$schema);
        this.$schema = $schema;
        return this;
    }

    public JsonSchemaBuilder addTitle(String title) {
        Validate.notNull((Object)title);
        this.title = title;
        return this;
    }

    public JsonSchemaBuilder addDescription(String description) {
        Validate.notNull((Object)description);
        this.description = description;
        return this;
    }

    public JsonSchemaBuilder addDefault(Object _default) {
        Validate.notNull((Object)_default);
        this._default = _default;
        return this;
    }

    public JsonSchemaBuilder addFormat(String format) {
        Validate.notNull((Object)format);
        this.format = format;
        return this;
    }

    public JsonSchemaBuilder addMultipleOf(BigDecimal multipleOf) {
        this.multipleOf = multipleOf;
        return this;
    }

    public JsonSchemaBuilder addMaximum(BigDecimal maximum, Boolean exclusive) {
        this.maximum = maximum;
        this.exclusiveMaximum = exclusive;
        return this;
    }

    public JsonSchemaBuilder addMinimum(BigDecimal minimum, Boolean exclusive) {
        this.minimum = minimum;
        this.exclusiveMinimum = exclusive;
        return this;
    }

    public JsonSchemaBuilder addMaxLength(long maxLength) {
        this.maxLength = BigInteger.valueOf(maxLength);
        return this;
    }

    public JsonSchemaBuilder addMaxLength(BigInteger maxLength) {
        Validate.notNull((Object)maxLength);
        this.maxLength = maxLength;
        return this;
    }

    public JsonSchemaBuilder addMinLength(long minLength) {
        this.minLength = BigInteger.valueOf(minLength);
        return this;
    }

    public JsonSchemaBuilder addMinLength(BigInteger minLength) {
        Validate.notNull((Object)minLength);
        this.minLength = minLength;
        return this;
    }

    public JsonSchemaBuilder addPattern(String pattern) {
        Validate.notNull((Object)pattern);
        this.pattern = pattern;
        return this;
    }

    public JsonSchemaBuilder addAdditionalItems(boolean additionalItems) {
        this.hasAdditionalItems = additionalItems;
        return this;
    }

    public JsonSchemaBuilder addAdditionalItem(JsonSchemaBuilder additionalItem) {
        this.additionalItem = additionalItem;
        return this;
    }

    public JsonSchemaBuilder addItem(JsonSchemaBuilder schema) {
        Validate.notNull((Object)schema);
        if (this.items == null) {
            this.items = new LinkedList<JsonSchemaBuilder>();
        }
        this.items.add(schema);
        return this;
    }

    public JsonSchemaBuilder addMaxItems(BigInteger maxItems) {
        this.maxItems = maxItems;
        return this;
    }

    public JsonSchemaBuilder addMaxItems(long maxItems) {
        return this.addMaxItems(BigInteger.valueOf(maxItems));
    }

    public JsonSchemaBuilder addMinItems(BigInteger minItems) {
        this.minItems = minItems;
        return this;
    }

    public JsonSchemaBuilder addMinItems(long minItems) {
        return this.addMinItems(BigInteger.valueOf(minItems));
    }

    public JsonSchemaBuilder addUniqueItems(Boolean uniqueItems) {
        this.uniqueItems = uniqueItems;
        return this;
    }

    public JsonSchemaBuilder addMaxProperties(BigInteger maxProperties) {
        this.maxProperties = maxProperties;
        return this;
    }

    public JsonSchemaBuilder addMaxProperties(long maxProperties) {
        return this.addMaxProperties(maxProperties);
    }

    public JsonSchemaBuilder addMinProperties(BigInteger minProperties) {
        this.minProperties = minProperties;
        return this;
    }

    public JsonSchemaBuilder addMinProperties(long minProperties) {
        return this.addMinProperties(minProperties);
    }

    public JsonSchemaBuilder addRequired(String name) {
        Validate.notNull((Object)name);
        if (this.required == null) {
            this.required = new LinkedHashSet<String>();
        }
        this.required.add(name);
        return this;
    }

    public JsonSchemaBuilder addAdditionalProperties(Boolean hasAdditionalProperties) {
        this.hasAdditionalProperties = hasAdditionalProperties;
        return this;
    }

    public JsonSchemaBuilder addAdditionalProperties(JsonSchemaBuilder additionalProperties) {
        Validate.notNull((Object)additionalProperties);
        this.additionalProperties = additionalProperties;
        return this;
    }

    public JsonSchemaBuilder addDefinition(String name, JsonSchemaBuilder schema) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)schema);
        if (this.definitions == null) {
            this.definitions = new LinkedHashMap<String, JsonSchemaBuilder>();
        }
        this.definitions.put(name, schema);
        return this;
    }

    public JsonSchemaBuilder addProperty(String name, JsonSchemaBuilder schema) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)schema);
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, JsonSchemaBuilder>();
        }
        this.properties.put(name, schema);
        return this;
    }

    public JsonSchemaBuilder addProperties(Map<String, JsonSchemaBuilder> properties) {
        Validate.notNull(properties);
        if (this.properties == null) {
            this.properties = new LinkedHashMap<String, JsonSchemaBuilder>();
        }
        this.properties.putAll(properties);
        return this;
    }

    public JsonSchemaBuilder addPatternProperty(String pattern, JsonSchemaBuilder schema) {
        Validate.notNull((Object)pattern);
        Validate.notNull((Object)schema);
        if (this.patternProperties == null) {
            this.patternProperties = new LinkedHashMap<String, JsonSchemaBuilder>();
        }
        this.patternProperties.put(pattern, schema);
        return this;
    }

    public JsonSchemaBuilder addPropertyDependency(String name, String dependency) {
        Set<String> dependencies;
        Validate.notNull((Object)name);
        Validate.notNull((Object)dependency);
        if (this.propertyDependencies == null) {
            this.propertyDependencies = new LinkedHashMap<String, Set<String>>();
        }
        if ((dependencies = this.propertyDependencies.get(name)) == null) {
            dependencies = new LinkedHashSet<String>();
            this.propertyDependencies.put(name, dependencies);
        }
        dependencies.add(dependency);
        return this;
    }

    public JsonSchemaBuilder addSchemaDependency(String name, JsonSchemaBuilder schema) {
        Validate.notNull((Object)name);
        Validate.notNull((Object)schema);
        if (this.schemaDependencies == null) {
            this.schemaDependencies = new LinkedHashMap<String, JsonSchemaBuilder>();
        }
        this.schemaDependencies.put(name, schema);
        return this;
    }

    public JsonSchemaBuilder addEnum(Object enumValue) {
        Validate.notNull((Object)enumValue);
        if (this._enum == null) {
            this._enum = new LinkedHashSet<Object>();
        }
        this._enum.add(enumValue);
        return this;
    }

    public JsonSchemaBuilder addType(String type) {
        Validate.notNull((Object)type);
        if (this.types == null) {
            this.types = new LinkedHashSet<String>();
        }
        this.types.add(type);
        return this;
    }

    public JsonSchemaBuilder addAllOf(JsonSchemaBuilder schema) {
        Validate.notNull((Object)schema);
        if (this.allOf == null) {
            this.allOf = new LinkedList<JsonSchemaBuilder>();
        }
        this.allOf.add(schema);
        return this;
    }

    public void addAllOf(Iterable<JsonSchemaBuilder> schemas) {
        Validate.notNull(schemas);
        for (JsonSchemaBuilder schema : schemas) {
            this.addAllOf(schema);
        }
    }

    public JsonSchemaBuilder addAnyOf(JsonSchemaBuilder schema) {
        Validate.notNull((Object)schema);
        if (this.anyOf == null) {
            this.anyOf = new LinkedList<JsonSchemaBuilder>();
        }
        this.anyOf.add(schema);
        return this;
    }

    public void addAnyOf(Iterable<JsonSchemaBuilder> schemas) {
        Validate.notNull(schemas);
        for (JsonSchemaBuilder schema : schemas) {
            this.addAnyOf(schema);
        }
    }

    public JsonSchemaBuilder addOneOf(JsonSchemaBuilder schema) {
        Validate.notNull((Object)schema);
        if (this.oneOf == null) {
            this.oneOf = new LinkedList<JsonSchemaBuilder>();
        }
        this.oneOf.add(schema);
        return this;
    }

    public void addOneOf(Iterable<JsonSchemaBuilder> schemas) {
        Validate.notNull(schemas);
        for (JsonSchemaBuilder schema : schemas) {
            this.addOneOf(schema);
        }
    }

    public JsonSchemaBuilder addNot(JsonSchemaBuilder schema) {
        Validate.notNull((Object)schema);
        this.not = schema;
        return this;
    }

    public JsonSchemaBuilder add(String name, Object value) {
        if (this.anyProperties == null) {
            this.anyProperties = new LinkedHashMap<String, Object>();
        }
        this.anyProperties.put(name, value);
        return this;
    }

    @Override
    public JsonObject build(JsonBuilderFactory builderFactory) {
        return this.build(builderFactory, builderFactory.createObjectBuilder()).build();
    }

    @Override
    public JsonObjectBuilder build(JsonBuilderFactory builderFactory, JsonObjectBuilder builder) {
        Validate.notNull((Object)builderFactory);
        Validate.notNull((Object)builder);
        if (this.$ref != null) {
            builder.add("$ref", this.$ref);
        }
        if (this.id != null) {
            builder.add("id", this.id);
        }
        if (this.$schema != null) {
            builder.add("$schema", this.$schema);
        }
        if (this.types != null) {
            if (this.types.size() == 1) {
                builder.add("type", this.types.iterator().next());
            } else {
                JsonBuilderUtils.add(builderFactory, builder, "type", this.types);
            }
        }
        if (this.title != null) {
            builder.add("title", this.title);
        }
        if (this.description != null) {
            builder.add("description", this.description);
        }
        if (this._default != null) {
            JsonBuilderUtils.add(builderFactory, builder, "default", this._default);
        }
        if (this.format != null) {
            builder.add("format", this.format);
        }
        if (this.multipleOf != null) {
            builder.add("multipleOf", this.multipleOf);
        }
        if (this.maximum != null) {
            builder.add("maximum", this.maximum);
        }
        if (this.exclusiveMaximum != null) {
            builder.add("exclusiveMaximum", this.exclusiveMaximum.booleanValue());
        }
        if (this.minimum != null) {
            builder.add("minimum", this.minimum);
        }
        if (this.exclusiveMinimum != null) {
            builder.add("exclusiveMinimum", this.exclusiveMinimum.booleanValue());
        }
        if (this.maxLength != null) {
            builder.add("maxLength", this.maxLength);
        }
        if (this.minLength != null) {
            builder.add("minLength", this.minLength);
        }
        if (this.pattern != null) {
            builder.add("pattern", this.pattern);
        }
        if (this.additionalItem != null) {
            builder.add("additionalItems", this.additionalItem.build(builderFactory, builderFactory.createObjectBuilder()));
        }
        if (this.hasAdditionalItems != null) {
            builder.add("additionalItems", this.hasAdditionalItems.booleanValue());
        }
        if (this.items != null) {
            if (this.items.size() == 1) {
                builder.add("items", this.items.iterator().next().build(builderFactory, builderFactory.createObjectBuilder()));
            } else {
                JsonBuilderUtils.add(builderFactory, builder, "items", this.items);
            }
        }
        if (this.maxItems != null) {
            builder.add("maxItems", this.maxItems);
        }
        if (this.minItems != null) {
            builder.add("minItems", this.minItems);
        }
        if (this.uniqueItems != null) {
            builder.add("uniqueItems", this.uniqueItems.booleanValue());
        }
        if (this.maxProperties != null) {
            builder.add("maxProperties", this.maxProperties);
        }
        if (this.minProperties != null) {
            builder.add("minProperties", this.minProperties);
        }
        if (this.required != null) {
            JsonBuilderUtils.add(builderFactory, builder, "required", this.required);
        }
        if (this.additionalProperties != null) {
            builder.add("additionalProperties", this.additionalProperties.build(builderFactory, builderFactory.createObjectBuilder()));
        }
        if (this.hasAdditionalProperties != null) {
            builder.add("additionalProperties", this.hasAdditionalProperties.booleanValue());
        }
        if (this.definitions != null) {
            JsonBuilderUtils.add(builderFactory, builder, "definitions", this.definitions);
        }
        if (this.properties != null) {
            JsonBuilderUtils.add(builderFactory, builder, "properties", this.properties);
        }
        if (this.patternProperties != null) {
            JsonBuilderUtils.add(builderFactory, builder, "patternProperties", this.patternProperties);
        }
        if (this.schemaDependencies != null) {
            JsonBuilderUtils.add(builderFactory, builder, "dependencies", this.schemaDependencies);
        }
        if (this.propertyDependencies != null) {
            JsonBuilderUtils.add(builderFactory, builder, "dependencies", this.propertyDependencies);
        }
        if (this._enum != null) {
            JsonBuilderUtils.add(builderFactory, builder, "enum", this._enum);
        }
        if (this.allOf != null) {
            JsonBuilderUtils.add(builderFactory, builder, "allOf", this.allOf);
        }
        if (this.anyOf != null) {
            JsonBuilderUtils.add(builderFactory, builder, "anyOf", this.anyOf);
        }
        if (this.oneOf != null) {
            JsonBuilderUtils.add(builderFactory, builder, "oneOf", this.oneOf);
        }
        if (this.not != null) {
            JsonBuilderUtils.add(builderFactory, builder, "not", this.not);
        }
        if (this.anyProperties != null) {
            for (Map.Entry<String, Object> entry : this.anyProperties.entrySet()) {
                JsonBuilderUtils.add(builderFactory, builder, entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }
}

