/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.execution;

import com.sun.tools.xjc.model.Model;
import com.sun.tools.xjc.model.nav.NClass;
import com.sun.tools.xjc.model.nav.NType;
import org.hisrc.jsonix.compilation.jsonschema.JsonSchemaModulesGenerator;
import org.hisrc.jsonix.compilation.jsonschema.JsonStructureWriter;
import org.hisrc.jsonix.compilation.mapping.ModulesCompiler;
import org.hisrc.jsonix.compilation.mapping.ProgramWriter;
import org.hisrc.jsonix.configuration.JsonSchemaConfiguration;
import org.hisrc.jsonix.configuration.ModulesConfiguration;
import org.hisrc.jsonix.configuration.ModulesConfigurationUnmarshaller;
import org.hisrc.jsonix.configuration.OutputConfiguration;
import org.hisrc.jsonix.context.DefaultJsonixContext;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.settings.Settings;
import org.jvnet.jaxb2_commons.xjc.model.concrete.XJCCMInfoFactory;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.slf4j.Logger;

public class JsonixInvoker {
    public void execute(Settings settings, Model model, ProgramWriter<NType, NClass> programWriter, JsonStructureWriter<NType, NClass> jsonStructureWriter) {
        DefaultJsonixContext context = new DefaultJsonixContext();
        context.setLogLevel(settings.getLogLevel().asInt());
        Logger logger = context.getLoggerFactory().getLogger(JsonixInvoker.class.getName());
        if (model == null) {
            logger.error("The model is null, there was probably a problem parsing schemas.");
            return;
        }
        ModulesConfigurationUnmarshaller customizationHandler = new ModulesConfigurationUnmarshaller(context);
        OutputConfiguration defaultOutputConfiguration = new OutputConfiguration(settings.getDefaultNaming().getName(), "${module.name}.js");
        JsonSchemaConfiguration defaultJsonSchemaConfiguration = settings.isGenerateJsonSchema() ? new JsonSchemaConfiguration("${module.name}.jsonschema") : null;
        ModulesConfiguration modulesConfiguration = customizationHandler.unmarshal(model, defaultOutputConfiguration, defaultJsonSchemaConfiguration);
        MModelInfo modelinfo = new XJCCMInfoFactory(model).createModel();
        Modules modules = modulesConfiguration.build(context, modelinfo);
        ModulesCompiler<NType, NClass> modulesCompiler = new ModulesCompiler<NType, NClass>(modules);
        modulesCompiler.compile(programWriter);
        JsonSchemaModulesGenerator<NType, NClass> jsonSchemaModulesGenerator = new JsonSchemaModulesGenerator<NType, NClass>(modules);
        jsonSchemaModulesGenerator.generate(jsonStructureWriter);
    }
}

