/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.definition;

import java.text.MessageFormat;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.DefaultInfoVertexVisitor;
import org.hisrc.jsonix.analysis.DependencyEdge;
import org.hisrc.jsonix.analysis.DependencyType;
import org.hisrc.jsonix.analysis.ElementInfoVertex;
import org.hisrc.jsonix.analysis.InfoVertex;
import org.hisrc.jsonix.analysis.InfoVertexVisitor;
import org.hisrc.jsonix.analysis.ModelInfoGraphAnalyzer;
import org.hisrc.jsonix.analysis.PackageInfoVertex;
import org.hisrc.jsonix.analysis.PropertyInfoVertex;
import org.hisrc.jsonix.analysis.TypeInfoVertex;
import org.hisrc.jsonix.context.JsonixContext;
import org.hisrc.jsonix.definition.ContainmentType;
import org.hisrc.jsonix.definition.MappingDependency;
import org.jgrapht.DirectedGraph;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.util.DefaultTypeInfoVisitor;
import org.slf4j.Logger;

public class Mapping<T, C extends T> {
    private final Logger logger;
    private final ModelInfoGraphAnalyzer<T, C> analyzer;
    private final MPackageInfo packageInfo;
    private final Collection<MClassInfo<T, C>> classInfos = new HashSet<MClassInfo<T, C>>();
    private final Collection<MPropertyInfo<T, C>> propertyInfos = new HashSet<MPropertyInfo<T, C>>();
    private final Collection<MEnumLeafInfo<T, C>> enumLeafInfos = new HashSet<MEnumLeafInfo<T, C>>();
    private final Collection<MElementInfo<T, C>> elementInfos = new HashSet<MElementInfo<T, C>>();
    private final Collection<InfoVertex<T, C>> infoVertices = new HashSet<InfoVertex<T, C>>();
    private final String packageName;
    private final String mappingName;
    private final String schemaId;
    private final String targetNamespaceURI;
    private final String defaultElementNamespaceURI;
    private final String defaultAttributeNamespaceURI;
    private final Map<InfoVertex<T, C>, ContainmentType> verticesContainmentMap = new HashMap<InfoVertex<T, C>, ContainmentType>();
    private final InfoVertexVisitor<T, C, Void> infoVertexAdder = new DefaultInfoVertexVisitor<T, C, Void>(){

        @Override
        public Void visitTypeInfoVertex(TypeInfoVertex<T, C> vertex) {
            Mapping.this.addTypeInfo(vertex.getTypeInfo());
            return null;
        }

        @Override
        public Void visitElementInfoVertex(ElementInfoVertex<T, C> vertex) {
            Mapping.this.addElementInfo(vertex.getElementInfo());
            return null;
        }

        @Override
        public Void visitPropertyInfoVertex(PropertyInfoVertex<T, C> vertex) {
            Mapping.this.addPropertyInfo(vertex.getPropertyInfo());
            return null;
        }
    };
    private final MTypeInfoVisitor<T, C, Void> typeInfoAdder = new DefaultTypeInfoVisitor<T, C, Void>(){

        public Void visitClassInfo(MClassInfo<T, C> info) {
            Mapping.this.addClassInfo(info);
            return null;
        }

        public Void visitEnumLeafInfo(MEnumLeafInfo<T, C> info) {
            Mapping.this.addEnumLeafInfo(info);
            return null;
        }
    };

    public Mapping(JsonixContext context, ModelInfoGraphAnalyzer<T, C> analyzer, MPackageInfo packageInfo, String mappingName, String schemaId, String targetNamespaceURI, String defaultElementNamespaceURI, String defaultAttributeNamespaceURI) {
        this.logger = ((JsonixContext)Validate.notNull((Object)context)).getLoggerFactory().getLogger(Mapping.class.getName());
        Validate.notNull(analyzer);
        Validate.notNull((Object)packageInfo);
        Validate.notNull((Object)mappingName);
        Validate.notNull((Object)schemaId);
        Validate.notNull((Object)defaultElementNamespaceURI);
        Validate.notNull((Object)defaultAttributeNamespaceURI);
        this.analyzer = analyzer;
        this.packageInfo = packageInfo;
        this.packageName = packageInfo.getPackageName();
        this.mappingName = mappingName;
        this.schemaId = schemaId;
        this.targetNamespaceURI = targetNamespaceURI;
        this.defaultElementNamespaceURI = defaultElementNamespaceURI;
        this.defaultAttributeNamespaceURI = defaultAttributeNamespaceURI;
    }

    public boolean isEmpty() {
        return this.elementInfos.isEmpty() && this.classInfos.isEmpty() && this.enumLeafInfos.isEmpty();
    }

    public void includePackage(MPackageInfo packageInfo) {
        Validate.notNull((Object)packageInfo);
        PackageInfoVertex vertex = new PackageInfoVertex(packageInfo);
        this.includeInfoVertex(vertex);
    }

    public void includePropertyInfo(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        PropertyInfoVertex<T, C> vertex = new PropertyInfoVertex<T, C>(propertyInfo);
        this.includeInfoVertex(vertex);
    }

    public void includeElementInfo(MElementInfo<T, C> elementInfo) {
        Validate.notNull(elementInfo);
        ElementInfoVertex<T, C> vertex = new ElementInfoVertex<T, C>(elementInfo);
        this.includeInfoVertex(vertex);
    }

    public void includeTypeInfo(MTypeInfo<T, C> typeInfo) {
        Validate.notNull(typeInfo);
        TypeInfoVertex<T, C> vertex = new TypeInfoVertex<T, C>(this.packageInfo, typeInfo);
        this.includeInfoVertex(vertex);
    }

    public void includeDependenciesOfMapping(Mapping<T, C> mapping) {
        InfoVertex<T, C> dependendMappingVertex;
        ContainmentType dependendMappingVertexContainmentType;
        Validate.notNull(mapping);
        Map<InfoVertex<T, C>, ContainmentType> dependendMappingVerticesContainmentMap = mapping.verticesContainmentMap;
        for (Map.Entry<InfoVertex<T, C>, ContainmentType> entry : dependendMappingVerticesContainmentMap.entrySet()) {
            ContainmentType containmentType;
            ContainmentType newContainmentType;
            dependendMappingVertexContainmentType = entry.getValue();
            if (dependendMappingVertexContainmentType.isIncluded() || (newContainmentType = dependendMappingVertexContainmentType.combineWith(containmentType = this.verticesContainmentMap.get(dependendMappingVertex = entry.getKey()))) == containmentType) continue;
            this.verticesContainmentMap.put(dependendMappingVertex, newContainmentType);
        }
        for (Map.Entry<InfoVertex<T, C>, ContainmentType> entry : dependendMappingVerticesContainmentMap.entrySet()) {
            dependendMappingVertexContainmentType = entry.getValue();
            if (!dependendMappingVertexContainmentType.isIncluded()) continue;
            dependendMappingVertex = entry.getKey();
            this.includeInfoVertex(dependendMappingVertex);
        }
    }

    public Collection<MappingDependency<T, C>> getDirectDependencies() {
        HashMap dependencies = new HashMap();
        DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph = this.analyzer.getGraph();
        HashSet<InfoVertex<T, C>> vertices = new HashSet<InfoVertex<T, C>>(this.getInfoVertices());
        for (InfoVertex infoVertex : vertices) {
            Set edges = graph.outgoingEdgesOf((Object)infoVertex);
            for (DependencyEdge edge : edges) {
                InfoVertex targetVertex;
                MPackageInfo packageInfo;
                if (edge.getType() != DependencyType.HARD || (packageInfo = (targetVertex = (InfoVertex)graph.getEdgeTarget((Object)edge)).getPackageInfo()) == null || this.packageInfo.equals(packageInfo)) continue;
                MappingDependency dependency = (MappingDependency)dependencies.get(packageInfo);
                if (dependency == null) {
                    dependency = new MappingDependency(packageInfo);
                    dependencies.put(packageInfo, dependency);
                }
                dependency.addInfoVertex(targetVertex);
            }
        }
        return dependencies.values();
    }

    public void excludePropertyInfo(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        PropertyInfoVertex<T, C> vertex = new PropertyInfoVertex<T, C>(propertyInfo);
        this.excludeInfoVertex(vertex);
    }

    public void excludeElementInfo(MElementInfo<T, C> elementInfo) {
        Validate.notNull(elementInfo);
        ElementInfoVertex<T, C> vertex = new ElementInfoVertex<T, C>(elementInfo);
        this.excludeInfoVertex(vertex);
    }

    public void excludeTypeInfo(MTypeInfo<T, C> typeInfo) {
        Validate.notNull(typeInfo);
        TypeInfoVertex<T, C> vertex = new TypeInfoVertex<T, C>(this.packageInfo, typeInfo);
        this.excludeInfoVertex(vertex);
    }

    private void includeInfoVertex(InfoVertex<T, C> initialVertex) {
        this.logger.trace(MessageFormat.format("Including the vertex [{0}].", initialVertex));
        DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph = this.analyzer.getGraph();
        TreeMap deques = new TreeMap();
        deques.put(ContainmentType.INCLUDED_EXPLICITLY, new LinkedList());
        deques.put(ContainmentType.INCLUDED_AS_HARD_DEPENDENCY, new LinkedList());
        deques.put(ContainmentType.INCLUDED_AS_SOFT_DEPENDENCY, new LinkedList());
        ((Deque)deques.get((Object)ContainmentType.INCLUDED_EXPLICITLY)).add(initialVertex);
        for (Map.Entry dequeEntry : deques.entrySet()) {
            ContainmentType dequeContainmentType = (ContainmentType)((Object)dequeEntry.getKey());
            Deque deque = (Deque)dequeEntry.getValue();
            while (!deque.isEmpty()) {
                InfoVertex sourceVertex = (InfoVertex)deque.removeFirst();
                ContainmentType currentSourceContainmentType = this.getInfoVertexContainmentType(sourceVertex);
                ContainmentType sourceContainmentType = dequeContainmentType.combineWith(currentSourceContainmentType);
                if (currentSourceContainmentType == null || currentSourceContainmentType.compareTo(sourceContainmentType) > 0) {
                    if (currentSourceContainmentType != null && !currentSourceContainmentType.isIncluded()) {
                        this.logger.warn(MessageFormat.format("The vertex [{0}] was excluded with the containment type [{1}], but it must be included with containment type [{2}], otherwise mappings will not be consistent.", new Object[]{sourceVertex, currentSourceContainmentType, sourceContainmentType}));
                    } else {
                        this.logger.trace(MessageFormat.format("Including the vertex [{0}] with the containment type [{1}].", new Object[]{sourceVertex, dequeContainmentType}));
                    }
                    this.setInfoVertexContainmentType(sourceVertex, sourceContainmentType);
                    Set edges = graph.outgoingEdgesOf((Object)sourceVertex);
                    for (DependencyEdge edge : edges) {
                        Deque targetDeque;
                        InfoVertex targetVertex = (InfoVertex)graph.getEdgeTarget((Object)edge);
                        DependencyType dependencyType = edge.getType();
                        ContainmentType targetContainmentType = dependencyType.combineWith(sourceContainmentType);
                        if (targetContainmentType == null || (targetDeque = (Deque)deques.get((Object)targetContainmentType)) == null) continue;
                        this.logger.trace(MessageFormat.format("Queueing the inclusion of the vertex [{0}] with the containment type [{1}].", new Object[]{targetVertex, targetContainmentType}));
                        targetDeque.add(targetVertex);
                    }
                    continue;
                }
                this.logger.trace(MessageFormat.format("Vertex [{0}] is already included with the containment type [{1}].", new Object[]{sourceVertex, currentSourceContainmentType}));
            }
        }
    }

    private ContainmentType getInfoVertexContainmentType(InfoVertex<T, C> sourceVertex) {
        ContainmentType sourceContainmentType = this.verticesContainmentMap.get(sourceVertex);
        return sourceContainmentType;
    }

    private void excludeInfoVertex(InfoVertex<T, C> vertex) {
        Validate.notNull(vertex);
        this.logger.trace(MessageFormat.format("Excluding [{0}].", vertex));
        DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph = this.analyzer.getGraph();
        TreeMap deques = new TreeMap();
        deques.put(ContainmentType.EXCLUDED_EXPLICITLY, new LinkedList());
        deques.put(ContainmentType.EXCLUDED_AS_HARD_DEPENDENCY, new LinkedList());
        ((Deque)deques.get((Object)ContainmentType.EXCLUDED_EXPLICITLY)).add(vertex);
        for (Map.Entry dequeEntry : deques.entrySet()) {
            ContainmentType dequeContainmentType = (ContainmentType)((Object)dequeEntry.getKey());
            Deque deque = (Deque)dequeEntry.getValue();
            while (!deque.isEmpty()) {
                InfoVertex targetVertex = (InfoVertex)deque.removeFirst();
                ContainmentType currentTargetContainmentType = this.getInfoVertexContainmentType(targetVertex);
                ContainmentType targetContainmentType = dequeContainmentType.combineWith(currentTargetContainmentType);
                if (currentTargetContainmentType == null || currentTargetContainmentType.compareTo(targetContainmentType) > 0) {
                    this.logger.trace(MessageFormat.format("Excluding the vertex [{0}] with the containment type [{1}].", new Object[]{targetVertex, targetContainmentType}));
                    this.setInfoVertexContainmentType(targetVertex, targetContainmentType);
                    Set edges = graph.incomingEdgesOf((Object)targetVertex);
                    for (DependencyEdge edge : edges) {
                        Deque sourceDeque;
                        InfoVertex sourceVertex = (InfoVertex)graph.getEdgeSource((Object)edge);
                        DependencyType dependencyType = edge.getType();
                        ContainmentType sourceContainmentType = dependencyType.combineWith(targetContainmentType);
                        if (sourceContainmentType == null || (sourceDeque = (Deque)deques.get((Object)sourceContainmentType)) == null) continue;
                        this.logger.trace(MessageFormat.format("Queueing the exclusion of the vertex [{0}] with the containment type [{1}].", new Object[]{sourceVertex, sourceContainmentType}));
                        sourceDeque.add(sourceVertex);
                    }
                    continue;
                }
                this.logger.trace(MessageFormat.format("Vertex [{0}] is already excluded with the containment type [{1}].", new Object[]{targetVertex, targetContainmentType}));
            }
        }
    }

    private void setInfoVertexContainmentType(InfoVertex<T, C> vertex, ContainmentType containmentType) {
        Validate.notNull(vertex);
        this.verticesContainmentMap.put(vertex, containmentType);
        if (containmentType.isIncluded()) {
            vertex.accept(this.infoVertexAdder);
        }
    }

    private void addTypeInfo(MTypeInfo<T, C> typeInfo) {
        Validate.notNull(typeInfo);
        typeInfo.acceptTypeInfoVisitor(this.typeInfoAdder);
    }

    private void addElementInfo(MElementInfo<T, C> elementInfo) {
        Validate.notNull(elementInfo);
        if (this.packageInfo.equals(elementInfo.getPackageInfo())) {
            this.elementInfos.add(elementInfo);
            this.infoVertices.add(new ElementInfoVertex<T, C>(elementInfo));
        }
    }

    private void addClassInfo(MClassInfo<T, C> classInfo) {
        Validate.notNull(classInfo);
        if (this.packageInfo.equals(classInfo.getPackageInfo())) {
            this.classInfos.add(classInfo);
            this.infoVertices.add(new TypeInfoVertex<T, C>(classInfo.getPackageInfo(), classInfo));
        }
    }

    private void addEnumLeafInfo(MEnumLeafInfo<T, C> enumLeafInfo) {
        Validate.notNull(enumLeafInfo);
        if (this.packageInfo.equals(enumLeafInfo.getPackageInfo())) {
            this.enumLeafInfos.add(enumLeafInfo);
            this.infoVertices.add(new TypeInfoVertex<T, C>(enumLeafInfo.getPackageInfo(), enumLeafInfo));
        }
    }

    private void addPropertyInfo(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        if (this.packageInfo.equals(propertyInfo.getClassInfo().getPackageInfo())) {
            this.propertyInfos.add(propertyInfo);
            this.infoVertices.add(new PropertyInfoVertex<T, C>(propertyInfo));
        }
    }

    private Collection<InfoVertex<T, C>> getInfoVertices() {
        return this.infoVertices;
    }

    public MPackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getMappingName() {
        return this.mappingName;
    }

    public String getSchemaId() {
        return this.schemaId;
    }

    public String getTargetNamespaceURI() {
        return this.targetNamespaceURI;
    }

    public String getDefaultElementNamespaceURI() {
        return this.defaultElementNamespaceURI;
    }

    public String getDefaultAttributeNamespaceURI() {
        return this.defaultAttributeNamespaceURI;
    }

    public Collection<MClassInfo<T, C>> getClassInfos() {
        return this.classInfos;
    }

    public Collection<MPropertyInfo<T, C>> getPropertyInfos() {
        return this.propertyInfos;
    }

    public Collection<MEnumLeafInfo<T, C>> getEnumLeafInfos() {
        return this.enumLeafInfos;
    }

    public Collection<MElementInfo<T, C>> getElementInfos() {
        return this.elementInfos;
    }

    public String toString() {
        return MessageFormat.format("Mapping [{0}]", this.mappingName);
    }
}

