/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.configuration;

import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.configuration.exception.UnsupportedNamingException;
import org.hisrc.jsonix.definition.Output;
import org.hisrc.jsonix.naming.CompactNaming;
import org.hisrc.jsonix.naming.Naming;
import org.hisrc.jsonix.naming.StandardNaming;

@XmlRootElement(name="output")
@XmlType(propOrder={})
public class OutputConfiguration {
    public static final String LOCAL_ELEMENT_NAME = "output";
    public static final String COMPACT_FILE_NAME_PATTERN = "${module.name}.compact.js";
    public static final String STANDARD_FILE_NAME_PATTERN = "${module.name}.js";
    private String fileName;
    private String naming;
    public static final QName OUTPUT_NAME = new QName("http://jsonix.highsource.org/customizations", "output", "jsonix");

    public OutputConfiguration() {
    }

    public OutputConfiguration(String naming) {
        this.naming = naming;
    }

    public OutputConfiguration(String naming, String fileName) {
        this.naming = naming;
        this.fileName = fileName;
    }

    @XmlAttribute(name="fileName")
    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @XmlAttribute(name="naming")
    public String getNaming() {
        return this.naming;
    }

    public void setNaming(String naming) {
        this.naming = naming;
    }

    public Output build(String moduleName) {
        String defaultFileNamePattern;
        Naming naming;
        Validate.notNull((Object)moduleName);
        if (null == this.naming || "standard".equals(this.naming)) {
            naming = StandardNaming.INSTANCE;
            defaultFileNamePattern = STANDARD_FILE_NAME_PATTERN;
        } else if ("compact".equals(this.naming)) {
            naming = CompactNaming.INSTANCE;
            defaultFileNamePattern = COMPACT_FILE_NAME_PATTERN;
        } else {
            throw new UnsupportedNamingException(this.naming);
        }
        String fileNamePattern = this.fileName == null ? defaultFileNamePattern : this.fileName;
        String fileName = fileNamePattern.replace("${module.name}", moduleName);
        return new Output(fileName, naming);
    }
}

