/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.configuration;

import java.text.MessageFormat;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlType;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.ModelInfoGraphAnalyzer;
import org.hisrc.jsonix.configuration.DependenciesOfMappingConfiguration;
import org.hisrc.jsonix.configuration.ElementInfoConfiguration;
import org.hisrc.jsonix.configuration.ExcludesConfiguration;
import org.hisrc.jsonix.configuration.IncludesConfiguration;
import org.hisrc.jsonix.configuration.ModuleConfiguration;
import org.hisrc.jsonix.configuration.PropertyInfoConfiguration;
import org.hisrc.jsonix.configuration.TypeInfoConfiguration;
import org.hisrc.jsonix.configuration.exception.MissingMappingWithIdException;
import org.hisrc.jsonix.context.JsonixContext;
import org.hisrc.jsonix.definition.Mapping;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.util.PackageInfoQNameAnalyzer;
import org.slf4j.Logger;

@XmlRootElement(name="mapping")
@XmlType(propOrder={})
public class MappingConfiguration {
    public static final String MAPPING_NAME_PROPERTY = "${mapping.name}";
    public static final String MAPPING_TARGET_NAMESPACE_URI_PROPERTY = "${mapping.targetNamespace}";
    public static final String LOCAL_ELEMENT_NAME = "mapping";
    private ModuleConfiguration moduleConfiguration;
    private String id;
    private String name;
    private String _package;
    private String schemaId = "${mapping.targetNamespace}#";
    private String targetNamespaceURI;
    private String defaultElementNamespaceURI;
    private String defaultAttributeNamespaceURI;
    private IncludesConfiguration includesConfiguration;
    private ExcludesConfiguration excludesConfiguration;
    public static final QName MAPPING_NAME = new QName("http://jsonix.highsource.org/customizations", "mapping", "jsonix");

    @XmlAttribute(name="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @XmlAttribute(name="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @XmlAttribute(name="package")
    public String getPackage() {
        return this._package;
    }

    public void setPackage(String _package) {
        this._package = _package;
    }

    @XmlAttribute(name="schemaId")
    public String getSchemaId() {
        return this.schemaId;
    }

    public void setSchemaId(String schemaId) {
        this.schemaId = schemaId;
    }

    @XmlAttribute(name="targetNamespace")
    public String getTargetNamespaceURI() {
        return this.targetNamespaceURI;
    }

    public void setTargetNamespaceURI(String targetNamespaceURI) {
        this.targetNamespaceURI = targetNamespaceURI;
    }

    @XmlAttribute(name="defaultElementNamespaceURI")
    public String getDefaultElementNamespaceURI() {
        return this.defaultElementNamespaceURI;
    }

    public void setDefaultElementNamespaceURI(String defaultElementNamespaceURI) {
        this.defaultElementNamespaceURI = defaultElementNamespaceURI;
    }

    @XmlAttribute(name="defaultAttributeNamespaceURI")
    public String getDefaultAttributeNamespaceURI() {
        return this.defaultAttributeNamespaceURI;
    }

    public void setDefaultAttributeNamespaceURI(String defaultAttributeNamespaceURI) {
        this.defaultAttributeNamespaceURI = defaultAttributeNamespaceURI;
    }

    @XmlElement(name="includes")
    public IncludesConfiguration getIncludesConfiguration() {
        return this.includesConfiguration;
    }

    public void setIncludesConfiguration(IncludesConfiguration includesConfiguration) {
        this.includesConfiguration = includesConfiguration;
    }

    @XmlElement(name="excludes")
    public ExcludesConfiguration getExcludesConfiguration() {
        return this.excludesConfiguration;
    }

    public void setExcludesConfiguration(ExcludesConfiguration excludesConfiguration) {
        this.excludesConfiguration = excludesConfiguration;
    }

    public <T, C extends T> Mapping<T, C> build(JsonixContext context, ModelInfoGraphAnalyzer<T, C> analyzer, MModelInfo<T, C> modelInfo, MPackageInfo packageInfo, Map<String, Mapping<T, C>> mappings) {
        MPropertyInfo<T, C> propertyInfo;
        MElementInfo<T, C> elementInfo;
        MTypeInfo<T, C> typeInfo;
        String defaultAttributeNamespaceURI;
        String mostUsedAttributeNamespaceURI;
        String targetNamespaceURI;
        String mostUsedElementNamespaceURI;
        Validate.notNull(modelInfo);
        Validate.notNull((Object)packageInfo);
        Validate.notNull(mappings);
        String packageName = this.getPackage();
        String mappingName = this.getName();
        Logger logger = context.getLoggerFactory().getLogger(MappingConfiguration.class.getName());
        logger.debug(MessageFormat.format("Package [{0}] will be mapped by the mapping [{1}].", packageName, mappingName));
        PackageInfoQNameAnalyzer qnameAnalyzer = new PackageInfoQNameAnalyzer(modelInfo);
        String draftMostUsedElementNamespaceURI = qnameAnalyzer.getMostUsedElementNamespaceURI(packageInfo);
        String string = mostUsedElementNamespaceURI = draftMostUsedElementNamespaceURI == null ? "" : draftMostUsedElementNamespaceURI;
        if (this.targetNamespaceURI != null) {
            targetNamespaceURI = this.targetNamespaceURI;
        } else {
            logger.debug(MessageFormat.format("Mapping [{0}] will use \"{1}\" as the target namespace as it is the most used element namespace URI in the package [{2}].", mappingName, mostUsedElementNamespaceURI, packageName));
            targetNamespaceURI = mostUsedElementNamespaceURI;
        }
        String defaultElementNamespaceURI = this.defaultElementNamespaceURI != null ? this.defaultElementNamespaceURI : targetNamespaceURI;
        String draftMostUsedAttributeNamespaceURI = qnameAnalyzer.getMostUsedAttributeNamespaceURI(packageInfo);
        String string2 = mostUsedAttributeNamespaceURI = draftMostUsedAttributeNamespaceURI == null ? "" : draftMostUsedAttributeNamespaceURI;
        if (this.defaultAttributeNamespaceURI != null) {
            defaultAttributeNamespaceURI = this.defaultAttributeNamespaceURI;
        } else {
            logger.debug(MessageFormat.format("Mapping [{0}] will use \"{1}\" as it is the most used attribute namespace URI in the package [{2}].", mappingName, mostUsedAttributeNamespaceURI, packageName));
            defaultAttributeNamespaceURI = mostUsedAttributeNamespaceURI;
        }
        String mappingSchemaId = this.schemaId.replace("${module.schemaId}", this.getModuleConfiguration().getSchemaId()).replace("${module.name}", this.getModuleConfiguration().getName()).replace(MAPPING_NAME_PROPERTY, this.getName()).replace(MAPPING_TARGET_NAMESPACE_URI_PROPERTY, targetNamespaceURI);
        Mapping<T, C> mapping = new Mapping<T, C>(context, analyzer, packageInfo, mappingName, mappingSchemaId, targetNamespaceURI, defaultElementNamespaceURI, defaultAttributeNamespaceURI);
        if (this.getExcludesConfiguration() != null) {
            ExcludesConfiguration excludesConfiguration = this.getExcludesConfiguration();
            for (TypeInfoConfiguration typeInfoConfiguration : excludesConfiguration.getTypeInfoConfigurations()) {
                typeInfo = typeInfoConfiguration.findTypeInfo(context, analyzer, packageInfo);
                if (typeInfo == null) continue;
                mapping.excludeTypeInfo(typeInfo);
            }
            for (ElementInfoConfiguration elementInfoConfiguration : excludesConfiguration.getElementInfoConfigurations()) {
                elementInfo = elementInfoConfiguration.findElementInfo(context, analyzer, packageInfo);
                if (elementInfo == null) continue;
                mapping.excludeElementInfo(elementInfo);
            }
            for (PropertyInfoConfiguration propertyInfoConfiguration : excludesConfiguration.getPropertyInfoConfigurations()) {
                propertyInfo = propertyInfoConfiguration.findPropertyInfo(context, analyzer, packageInfo);
                if (propertyInfo == null) continue;
                mapping.excludePropertyInfo(propertyInfo);
            }
        }
        if (this.getIncludesConfiguration() == null) {
            logger.trace(MessageFormat.format("Includes configuration for the mapping [{0}] is not provided, including the whole package.", mappingName));
            mapping.includePackage(packageInfo);
        } else {
            IncludesConfiguration includesConfiguration = this.getIncludesConfiguration();
            for (TypeInfoConfiguration typeInfoConfiguration : includesConfiguration.getTypeInfoConfigurations()) {
                typeInfo = typeInfoConfiguration.findTypeInfo(context, analyzer, packageInfo);
                if (typeInfo == null) continue;
                mapping.includeTypeInfo(typeInfo);
            }
            for (ElementInfoConfiguration elementInfoConfiguration : includesConfiguration.getElementInfoConfigurations()) {
                elementInfo = elementInfoConfiguration.findElementInfo(context, analyzer, packageInfo);
                if (elementInfo == null) continue;
                mapping.includeElementInfo(elementInfo);
            }
            for (PropertyInfoConfiguration propertyInfoConfiguration : includesConfiguration.getPropertyInfoConfigurations()) {
                propertyInfo = propertyInfoConfiguration.findPropertyInfo(context, analyzer, packageInfo);
                if (propertyInfo == null) continue;
                mapping.includePropertyInfo(propertyInfo);
            }
            for (DependenciesOfMappingConfiguration dependenciesOfMappingConfiguration : includesConfiguration.getDependenciesOfMappingConfiguration()) {
                String id = dependenciesOfMappingConfiguration.getId();
                Mapping<T, C> dependingMapping = mappings.get(id);
                if (dependingMapping == null) {
                    throw new MissingMappingWithIdException(id);
                }
                mapping.includeDependenciesOfMapping(dependingMapping);
            }
        }
        return mapping;
    }

    public String toString() {
        return MessageFormat.format("[{0}:{1}]", this.getId(), this.getName());
    }

    public ModuleConfiguration getModuleConfiguration() {
        return this.moduleConfiguration;
    }

    public void setModuleConfiguration(ModuleConfiguration moduleConfiguration) {
        if (this.moduleConfiguration != null) {
            throw new IllegalStateException("Module configuration was already assigned.");
        }
        this.moduleConfiguration = moduleConfiguration;
    }
}

