/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping.typeinfo;

import com.sun.xml.xsom.XSComponent;
import com.sun.xml.xsom.visitor.XSVisitor;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.compilation.mapping.typeinfo.BuiltinLeafInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.ClassInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.ClassRefCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.EnumLeafInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.ListCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.TypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.Base64BinaryTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.BooleanTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.DecimalTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.DurationTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.HexBinaryTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.IntegerTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.NormalizedStringTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.QNameTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.StringTypeInfoCompiler;
import org.hisrc.jsonix.compilation.mapping.typeinfo.builtin.XMLGregorianCalendarTypeInfoCompiler;
import org.hisrc.jsonix.xml.xsom.CollectSimpleTypeNamesVisitor;
import org.hisrc.xml.xsom.SchemaComponentAware;
import org.jvnet.jaxb2_commons.xml.bind.model.MBuiltinLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassRef;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MID;
import org.jvnet.jaxb2_commons.xml.bind.model.MIDREF;
import org.jvnet.jaxb2_commons.xml.bind.model.MIDREFS;
import org.jvnet.jaxb2_commons.xml.bind.model.MList;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MWildcardTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.origin.MOriginated;
import org.jvnet.jaxb2_commons.xmlschema.XmlSchemaConstants;

public class CreateTypeInfoCompiler<T, C extends T, O>
implements MTypeInfoVisitor<T, C, TypeInfoCompiler<T, C>> {
    private static final String IDREFS_TYPE_INFO_NAME = "IDREFS";
    private static final String IDREF_TYPE_INFO_NAME = "IDREF";
    private static final String ID_TYPE_INFO_NAME = "ID";
    private Map<QName, TypeInfoCompiler<T, C>> XSD_TYPE_MAPPING = new HashMap<QName, TypeInfoCompiler<T, C>>();
    private final MOriginated<O> originated;

    public CreateTypeInfoCompiler(MOriginated<O> originated) {
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ANYTYPE, new BuiltinLeafInfoCompiler("AnyType", XmlSchemaConstants.ANYTYPE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ANYSIMPLETYPE, new BuiltinLeafInfoCompiler("AnySimpleType", XmlSchemaConstants.ANYSIMPLETYPE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.STRING, new StringTypeInfoCompiler("String", XmlSchemaConstants.STRING));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NORMALIZEDSTRING, new NormalizedStringTypeInfoCompiler("NormalizedString", XmlSchemaConstants.NORMALIZEDSTRING));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.TOKEN, new NormalizedStringTypeInfoCompiler("Token", XmlSchemaConstants.TOKEN));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.LANGUAGE, new NormalizedStringTypeInfoCompiler("Language", XmlSchemaConstants.LANGUAGE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NAME, new NormalizedStringTypeInfoCompiler("Name", XmlSchemaConstants.NAME));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NCNAME, new NormalizedStringTypeInfoCompiler("NCName", XmlSchemaConstants.NCNAME));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ID, new BuiltinLeafInfoCompiler(ID_TYPE_INFO_NAME, XmlSchemaConstants.ID));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ID, new BuiltinLeafInfoCompiler("String", XmlSchemaConstants.ID));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.IDREF, new BuiltinLeafInfoCompiler(IDREF_TYPE_INFO_NAME, XmlSchemaConstants.IDREF));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.IDREF, new BuiltinLeafInfoCompiler("String", XmlSchemaConstants.IDREF));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.IDREFS, new BuiltinLeafInfoCompiler(IDREFS_TYPE_INFO_NAME, XmlSchemaConstants.IDREFS));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.IDREFS, new BuiltinLeafInfoCompiler("Strings", XmlSchemaConstants.IDREFS));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NMTOKEN, new NormalizedStringTypeInfoCompiler("NMToken", XmlSchemaConstants.NMTOKEN));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NMTOKENS, new NormalizedStringTypeInfoCompiler("NMTokens", XmlSchemaConstants.NMTOKENS));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.BOOLEAN, new BooleanTypeInfoCompiler());
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.BASE64BINARY, new Base64BinaryTypeInfoCompiler());
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.HEXBINARY, new HexBinaryTypeInfoCompiler());
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.FLOAT, new DecimalTypeInfoCompiler("Float", XmlSchemaConstants.FLOAT));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.DECIMAL, new DecimalTypeInfoCompiler("Decimal", XmlSchemaConstants.DECIMAL));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.INTEGER, new IntegerTypeInfoCompiler("Integer", XmlSchemaConstants.INTEGER));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NONPOSITIVEINTEGER, new IntegerTypeInfoCompiler("NonPositiveInteger", XmlSchemaConstants.NONPOSITIVEINTEGER));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NEGATIVEINTEGER, new IntegerTypeInfoCompiler("NegativeInteger", XmlSchemaConstants.NEGATIVEINTEGER));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.LONG, new IntegerTypeInfoCompiler("Long", XmlSchemaConstants.LONG));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.INT, new IntegerTypeInfoCompiler("Int", XmlSchemaConstants.INT));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.SHORT, new IntegerTypeInfoCompiler("Short", XmlSchemaConstants.SHORT));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.BYTE, new IntegerTypeInfoCompiler("Byte", XmlSchemaConstants.BYTE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.NONNEGATIVEINTEGER, new IntegerTypeInfoCompiler("NonNegativeInteger", XmlSchemaConstants.NONNEGATIVEINTEGER));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.UNSIGNEDLONG, new IntegerTypeInfoCompiler("UnsignedLong", XmlSchemaConstants.UNSIGNEDLONG));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.UNSIGNEDINT, new IntegerTypeInfoCompiler("UnsignedInt", XmlSchemaConstants.UNSIGNEDINT));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.UNSIGNEDSHORT, new IntegerTypeInfoCompiler("UnsignedShort", XmlSchemaConstants.UNSIGNEDSHORT));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.UNSIGNEDBYTE, new IntegerTypeInfoCompiler("UnsignedByte", XmlSchemaConstants.UNSIGNEDBYTE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.POSITIVEINTEGER, new IntegerTypeInfoCompiler("PositiveInteger", XmlSchemaConstants.POSITIVEINTEGER));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.DOUBLE, new DecimalTypeInfoCompiler("Double", XmlSchemaConstants.DOUBLE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ANYURI, new NormalizedStringTypeInfoCompiler("AnyURI", XmlSchemaConstants.ANYURI));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.ANYURI, new NormalizedStringTypeInfoCompiler("String", XmlSchemaConstants.ANYURI));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.QNAME, new QNameTypeInfoCompiler());
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.DURATION, new DurationTypeInfoCompiler());
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.DATETIME, new XMLGregorianCalendarTypeInfoCompiler("DateTime", XmlSchemaConstants.DATETIME));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.TIME, new XMLGregorianCalendarTypeInfoCompiler("Time", XmlSchemaConstants.TIME));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.DATE, new XMLGregorianCalendarTypeInfoCompiler("Date", XmlSchemaConstants.DATE));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.GYEARMONTH, new XMLGregorianCalendarTypeInfoCompiler("GYearMonth", XmlSchemaConstants.GYEARMONTH));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.GYEAR, new XMLGregorianCalendarTypeInfoCompiler("GYear", XmlSchemaConstants.GYEAR));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.GMONTHDAY, new XMLGregorianCalendarTypeInfoCompiler("GMonthDay", XmlSchemaConstants.GMONTHDAY));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.GDAY, new XMLGregorianCalendarTypeInfoCompiler("GDay", XmlSchemaConstants.GDAY));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.GMONTH, new XMLGregorianCalendarTypeInfoCompiler("GMonth", XmlSchemaConstants.GMONTH));
        this.XSD_TYPE_MAPPING.put(XmlSchemaConstants.CALENDAR, new BuiltinLeafInfoCompiler("Calendar", XmlSchemaConstants.CALENDAR));
        Validate.notNull(originated);
        this.originated = originated;
    }

    public TypeInfoCompiler<T, C> visitEnumLeafInfo(MEnumLeafInfo<T, C> info) {
        return new EnumLeafInfoCompiler<T, C>(info);
    }

    public TypeInfoCompiler<T, C> visitClassInfo(MClassInfo<T, C> info) {
        return new ClassInfoCompiler<T, C>(info);
    }

    public TypeInfoCompiler<T, C> visitClassRef(MClassRef<T, C> info) {
        return new ClassRefCompiler<T, C>(info);
    }

    public TypeInfoCompiler<T, C> visitList(MList<T, C> info) {
        return new ListCompiler<T, C>(info, (TypeInfoCompiler)info.getItemTypeInfo().acceptTypeInfoVisitor((MTypeInfoVisitor)this));
    }

    public TypeInfoCompiler<T, C> visitBuiltinLeafInfo(MBuiltinLeafInfo<T, C> info) {
        XSComponent component;
        Object origin = this.originated.getOrigin();
        LinkedList<QName> simpleTypeNames = new LinkedList<QName>();
        if (origin instanceof SchemaComponentAware && (component = ((SchemaComponentAware)origin).getSchemaComponent()) != null) {
            CollectSimpleTypeNamesVisitor visitor = new CollectSimpleTypeNamesVisitor();
            component.visit((XSVisitor)visitor);
            simpleTypeNames.addAll(visitor.getTypeNames());
        }
        simpleTypeNames.add(info.getTypeName());
        for (QName candidateName : simpleTypeNames) {
            TypeInfoCompiler<T, C> typeInfoCompiler = this.XSD_TYPE_MAPPING.get(candidateName);
            if (typeInfoCompiler == null) continue;
            return typeInfoCompiler;
        }
        return null;
    }

    public TypeInfoCompiler<T, C> visitWildcardTypeInfo(MWildcardTypeInfo<T, C> info) {
        throw new UnsupportedOperationException();
    }

    public TypeInfoCompiler<T, C> visitID(MID<T, C> info) {
        return new BuiltinLeafInfoCompiler(ID_TYPE_INFO_NAME, XmlSchemaConstants.ID);
    }

    public TypeInfoCompiler<T, C> visitIDREF(MIDREF<T, C> info) {
        return new BuiltinLeafInfoCompiler(IDREF_TYPE_INFO_NAME, XmlSchemaConstants.IDREF);
    }

    public TypeInfoCompiler<T, C> visitIDREFS(MIDREFS<T, C> info) {
        return new BuiltinLeafInfoCompiler(IDREFS_TYPE_INFO_NAME, XmlSchemaConstants.IDREFS);
    }
}

