/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.mapping;

import org.apache.commons.lang3.Validate;
import org.hisrc.jscm.codemodel.JSCodeModel;
import org.hisrc.jscm.codemodel.JSProgram;
import org.hisrc.jscm.codemodel.expression.JSAssignmentExpression;
import org.hisrc.jscm.codemodel.expression.JSBitwiseORExpression;
import org.hisrc.jscm.codemodel.expression.JSExpression;
import org.hisrc.jscm.codemodel.expression.JSFunctionExpression;
import org.hisrc.jscm.codemodel.expression.JSGlobalVariable;
import org.hisrc.jscm.codemodel.expression.JSObjectLiteral;
import org.hisrc.jscm.codemodel.expression.JSRelationalExpression;
import org.hisrc.jscm.codemodel.statement.JSBlock;
import org.hisrc.jscm.codemodel.statement.JSIfStatement;
import org.hisrc.jscm.codemodel.statement.JSVariableStatement;
import org.hisrc.jsonix.compilation.mapping.MappingCompiler;
import org.hisrc.jsonix.definition.Mapping;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.definition.Output;

public class ModuleCompiler<T, C extends T> {
    private final JSCodeModel codeModel;
    private final Modules<T, C> modules;
    private final Module<T, C> module;
    private final String moduleName;
    private final Output output;

    public ModuleCompiler(JSCodeModel codeModel, Modules<T, C> modules, Module<T, C> module, Output output) {
        Validate.notNull((Object)codeModel);
        Validate.notNull(modules);
        Validate.notNull(module);
        Validate.notNull((Object)output);
        this.codeModel = codeModel;
        this.modules = modules;
        this.module = module;
        this.moduleName = module.getName();
        this.output = output;
    }

    public JSProgram compile() {
        JSProgram moduleProgram = this.codeModel.program();
        JSFunctionExpression.Function moduleFactoryFunction = this.codeModel.function();
        JSVariableStatement moduleFactoryVariable = moduleProgram.var(this.moduleName + "_Module_Factory", (JSAssignmentExpression)moduleFactoryFunction);
        JSObjectLiteral moduleFactoryResult = this.codeModel.object();
        for (Mapping<T, C> mapping : this.module.getMappings()) {
            if (mapping.isEmpty()) continue;
            String mappingName = mapping.getMappingName();
            MappingCompiler<T, C> mappingCompiler = new MappingCompiler<T, C>(this.codeModel, this.modules, this.module, this.output, mapping);
            JSObjectLiteral mappingBody = mappingCompiler.compile();
            JSVariableStatement mappingVariable = moduleFactoryFunction.getBody().var(mappingName, (JSAssignmentExpression)mappingBody);
            moduleFactoryResult.append(mappingName, (JSAssignmentExpression)mappingVariable.getVariable());
        }
        moduleFactoryFunction.getBody()._return((JSExpression)moduleFactoryResult);
        JSGlobalVariable define = this.codeModel.globalVariable("define");
        JSIfStatement ifDefine = moduleProgram._if((JSExpression)define.typeof().eeq((JSRelationalExpression)this.codeModel.string("function")).and((JSBitwiseORExpression)define.p("amd")));
        ifDefine._then().block().expression((JSExpression)define.i().args(new JSAssignmentExpression[]{this.codeModel.array(), moduleFactoryVariable.getVariable()}));
        JSGlobalVariable module = this.codeModel.globalVariable("module");
        JSBlock ifNotDefineBlock = ifDefine._else().block();
        JSVariableStatement moduleInstance = ifNotDefineBlock.var(this.moduleName + "_Module", (JSAssignmentExpression)moduleFactoryVariable.getVariable().i());
        JSIfStatement ifModuleExports = ifNotDefineBlock._if((JSExpression)module.typeof().nee((JSRelationalExpression)this.codeModel.string("undefined")).and((JSBitwiseORExpression)module.p("exports")));
        JSBlock moduleExportsThenBlock = ifModuleExports._then().block();
        for (Mapping<T, C> mapping : this.module.getMappings()) {
            if (mapping.isEmpty()) continue;
            String mappingName = mapping.getMappingName();
            moduleExportsThenBlock.expression((JSExpression)module.p("exports").p(mappingName).assign((JSAssignmentExpression)moduleInstance.getVariable().p(mappingName)));
        }
        JSBlock moduleExportsElseBlock = ifModuleExports._else().block();
        for (Mapping<T, C> mapping : this.module.getMappings()) {
            if (mapping.isEmpty()) continue;
            String mappingName = mapping.getMappingName();
            moduleExportsElseBlock.var(mappingName, (JSAssignmentExpression)moduleInstance.getVariable().p(mappingName));
        }
        return moduleProgram;
    }
}

