/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.compilation.jsonschema;

import javax.json.JsonBuilderFactory;
import javax.json.JsonObject;
import javax.json.JsonStructure;
import javax.json.spi.JsonProvider;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.compilation.jsonschema.JsonSchemaModuleCompiler;
import org.hisrc.jsonix.compilation.jsonschema.JsonStructureWriter;
import org.hisrc.jsonix.definition.JsonSchema;
import org.hisrc.jsonix.definition.Module;
import org.hisrc.jsonix.definition.Modules;
import org.hisrc.jsonix.jsonschema.JsonSchemaBuilder;

public class JsonSchemaModulesGenerator<T, C extends T> {
    private final Modules<T, C> modules;

    public JsonSchemaModulesGenerator(Modules<T, C> modules) {
        Validate.notNull(modules);
        this.modules = modules;
    }

    public Modules<T, C> getModules() {
        return this.modules;
    }

    public void generate(JsonStructureWriter<T, C> writer) {
        JsonProvider provider = JsonProvider.provider();
        JsonBuilderFactory builderFactory = provider.createBuilderFactory(null);
        for (Module<T, C> module : this.modules.getModules()) {
            if (module.isEmpty()) continue;
            for (JsonSchema jsonSchema : module.getJsonSchemas()) {
                JsonSchemaModuleCompiler<T, C> moduleCompiler = new JsonSchemaModuleCompiler<T, C>(builderFactory, this.modules, module, jsonSchema);
                JsonSchemaBuilder moduleSchema = moduleCompiler.compile();
                JsonObject moduleSchemaJsonObject = moduleSchema.build(builderFactory);
                writer.writeJsonStructure(module, (JsonStructure)moduleSchemaJsonObject, jsonSchema.getFileName());
            }
        }
    }
}

