/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.analysis;

import java.text.MessageFormat;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.InfoVertex;
import org.hisrc.jsonix.analysis.InfoVertexVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;

public class PropertyInfoVertex<T, C extends T>
extends InfoVertex<T, C> {
    private final MPackageInfo packageInfo;
    private final MClassInfo<T, C> classInfo;
    private final MPropertyInfo<T, C> propertyInfo;

    public PropertyInfoVertex(MPropertyInfo<T, C> propertyInfo) {
        Validate.notNull(propertyInfo);
        this.propertyInfo = propertyInfo;
        this.packageInfo = propertyInfo.getClassInfo().getPackageInfo();
        this.classInfo = propertyInfo.getClassInfo();
    }

    @Override
    public MPackageInfo getPackageInfo() {
        return this.packageInfo;
    }

    public MClassInfo<T, C> getClassInfo() {
        return this.classInfo;
    }

    public MPropertyInfo<T, C> getPropertyInfo() {
        return this.propertyInfo;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.propertyInfo == null ? 0 : this.propertyInfo.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PropertyInfoVertex other = (PropertyInfoVertex)obj;
        return !(this.propertyInfo == null ? other.propertyInfo != null : !this.propertyInfo.equals(other.propertyInfo));
    }

    public String toString() {
        String propertyName = this.propertyInfo.getClassInfo().getName() + "." + this.propertyInfo.getPrivateName();
        return MessageFormat.format("Property [{0}]", propertyName);
    }

    @Override
    public <V> V accept(InfoVertexVisitor<T, C, V> visitor) {
        return visitor.visitPropertyInfoVertex(this);
    }
}

