/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.analysis;

import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.ElementInfoVertex;
import org.hisrc.jsonix.analysis.ModelInfoGraphBuilder;
import org.hisrc.jsonix.analysis.PropertyInfoVertex;
import org.hisrc.jsonix.analysis.TypeInfoVertex;
import org.jvnet.jaxb2_commons.xml.bind.model.MAnyAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MAnyElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MAttributePropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElement;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementRefsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementTypeInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementTypeRef;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementsPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfoVisitor;
import org.jvnet.jaxb2_commons.xml.bind.model.MTyped;
import org.jvnet.jaxb2_commons.xml.bind.model.MValuePropertyInfo;

public final class PropertyInfoGraphBuilder<T, C extends T>
implements MPropertyInfoVisitor<T, C, PropertyInfoVertex<T, C>> {
    private final ModelInfoGraphBuilder<T, C> modelInfoGraphBuilder;
    private final MModelInfo<T, C> modelInfo;
    private final PropertyInfoVertex<T, C> vertex;

    public PropertyInfoGraphBuilder(ModelInfoGraphBuilder<T, C> modelInfoGraphBuilder, MModelInfo<T, C> modelInfo, PropertyInfoVertex<T, C> vertex) {
        Validate.notNull(modelInfoGraphBuilder);
        Validate.notNull(modelInfo);
        Validate.notNull(vertex);
        this.modelInfoGraphBuilder = modelInfoGraphBuilder;
        this.modelInfo = modelInfo;
        this.vertex = vertex;
    }

    private void addHardDependencyOnType(PropertyInfoVertex<T, C> propertyInfoVertex, MTyped<T, C> info) {
        TypeInfoVertex<T, C> typeInfoVertex = this.modelInfoGraphBuilder.typeInfo(propertyInfoVertex.getPackageInfo(), info.getTypeInfo());
        this.modelInfoGraphBuilder.addHardDependency(propertyInfoVertex, typeInfoVertex);
    }

    private void addSoftDependencyOnType(PropertyInfoVertex<T, C> propertyInfoVertex, MTyped<T, C> info) {
        TypeInfoVertex<T, C> typeInfoVertex = this.modelInfoGraphBuilder.typeInfo(propertyInfoVertex.getPackageInfo(), info.getTypeInfo());
        this.modelInfoGraphBuilder.addSoftDependency(propertyInfoVertex, typeInfoVertex);
    }

    public PropertyInfoVertex<T, C> visitValuePropertyInfo(MValuePropertyInfo<T, C> info) {
        this.addHardDependencyOnType(this.vertex, (MTyped<T, C>)info);
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitAttributePropertyInfo(MAttributePropertyInfo<T, C> info) {
        this.addHardDependencyOnType(this.vertex, (MTyped<T, C>)info);
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitAnyAttributePropertyInfo(MAnyAttributePropertyInfo<T, C> info) {
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitAnyElementPropertyInfo(MAnyElementPropertyInfo<T, C> info) {
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitElementPropertyInfo(MElementPropertyInfo<T, C> info) {
        this.addHardDependencyOnType(this.vertex, (MTyped<T, C>)info);
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitElementsPropertyInfo(MElementsPropertyInfo<T, C> info) {
        for (MElementTypeRef elementTypeInfo : info.getElementTypeInfos()) {
            this.addSoftDependencyOnType(this.vertex, (MTyped<T, C>)elementTypeInfo);
        }
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitElementRefPropertyInfo(MElementRefPropertyInfo<T, C> info) {
        this.addHardDependencyOnType(this.vertex, (MTyped<T, C>)info);
        this.addSubstitutionHeadDependencies((MElementTypeInfo)info, this.vertex);
        return this.vertex;
    }

    public PropertyInfoVertex<T, C> visitElementRefsPropertyInfo(MElementRefsPropertyInfo<T, C> info) {
        for (MElement elementTypeInfo : info.getElementTypeInfos()) {
            this.addSoftDependencyOnType(this.vertex, (MTyped<T, C>)elementTypeInfo);
            this.addSubstitutionHeadDependencies(elementTypeInfo, this.vertex);
        }
        return this.vertex;
    }

    private <M extends MElementTypeInfo<T, C, O>, O> void addSubstitutionHeadDependencies(M elementTypeInfo, PropertyInfoVertex<T, C> propertyInfoVertex) {
        MClassInfo<T, C> classInfo = propertyInfoVertex.getClassInfo();
        QName elementName = elementTypeInfo.getElementName();
        for (MElementInfo elementInfo : this.modelInfo.getElementInfos()) {
            if (!elementName.equals(elementInfo.getSubstitutionHead()) || elementInfo.getScope() != null && elementInfo.getScope() != classInfo) continue;
            ElementInfoVertex<T, C> elementInfoVertex = this.modelInfoGraphBuilder.elementInfo(elementInfo);
            this.modelInfoGraphBuilder.addSoftDependency(elementInfoVertex, propertyInfoVertex);
            this.modelInfoGraphBuilder.addSoftDependency(propertyInfoVertex, elementInfoVertex);
        }
    }
}

