/*
 * Decompiled with CFR 0.152.
 */
package org.hisrc.jsonix.analysis;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.commons.lang3.Validate;
import org.hisrc.jsonix.analysis.DefaultInfoVertexVisitor;
import org.hisrc.jsonix.analysis.DependencyEdge;
import org.hisrc.jsonix.analysis.InfoVertex;
import org.hisrc.jsonix.analysis.ModelInfoGraphBuilder;
import org.hisrc.jsonix.analysis.PackageInfoVertex;
import org.hisrc.jsonix.context.JsonixContext;
import org.jgrapht.DirectedGraph;
import org.jgrapht.traverse.BreadthFirstIterator;
import org.jvnet.jaxb2_commons.xml.bind.model.MClassInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MElementInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MEnumLeafInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MModelInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPackageInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MPropertyInfo;
import org.jvnet.jaxb2_commons.xml.bind.model.MTypeInfo;

public class ModelInfoGraphAnalyzer<T, C extends T> {
    private final DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph;
    private final Map<String, MPackageInfo> packageInfoMap;
    private final Set<String> packageNames;
    private final Collection<MPackageInfo> packageInfos;
    private final Map<String, PackageInfoVertex<T, C>> packageVertexMap;
    private final Map<String, Set<InfoVertex<T, C>>> packageVerticesMap;
    private final Map<String, MTypeInfo<T, C>> typeInfoMap;
    private final Map<String, MPropertyInfo<T, C>> propertyInfoMap;
    private final Map<QName, MElementInfo<T, C>> elementInfoMap;
    Map<InfoVertex<T, C>, Set<InfoVertex<T, C>>> vertexToConnectedSet = new HashMap<InfoVertex<T, C>, Set<InfoVertex<T, C>>>();

    public ModelInfoGraphAnalyzer(JsonixContext context, MModelInfo<T, C> modelInfo) {
        DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph = new ModelInfoGraphBuilder<T, C>(context, modelInfo).build();
        this.packageVertexMap = this.createPackageVertexMap(graph);
        this.packageInfoMap = this.createPackageInfoMap(this.packageVertexMap);
        this.packageNames = this.packageInfoMap.keySet();
        this.packageInfos = this.packageInfoMap.values();
        this.packageVerticesMap = this.createPackageVerticesMap(graph);
        this.graph = graph;
        this.typeInfoMap = this.createTypeInfoMap(modelInfo);
        this.elementInfoMap = this.createElementInfoMap(modelInfo);
        this.propertyInfoMap = this.createPropertyInfoMap(modelInfo);
    }

    private Map<QName, MElementInfo<T, C>> createElementInfoMap(MModelInfo<T, C> modelInfo) {
        HashMap<QName, MElementInfo<T, C>> elementInfoMap = new HashMap<QName, MElementInfo<T, C>>();
        for (MElementInfo elementInfo : modelInfo.getElementInfos()) {
            QName elementName = elementInfo.getElementName();
            if (elementInfo.getScope() == null) {
                elementInfoMap.put(elementName, elementInfo);
                continue;
            }
            MElementInfo existingElementinfo = (MElementInfo)elementInfoMap.get(elementName);
            if (existingElementinfo != null) continue;
            elementInfoMap.put(elementName, elementInfo);
        }
        return elementInfoMap;
    }

    private Map<String, MTypeInfo<T, C>> createTypeInfoMap(MModelInfo<T, C> modelInfo) {
        HashMap<String, MTypeInfo<T, C>> typeInfoMap = new HashMap<String, MTypeInfo<T, C>>();
        for (MClassInfo classInfo : modelInfo.getClassInfos()) {
            typeInfoMap.put(classInfo.getName(), (MTypeInfo<T, C>)classInfo);
        }
        for (MEnumLeafInfo enumLeafInfo : modelInfo.getEnumLeafInfos()) {
            typeInfoMap.put(enumLeafInfo.getName(), (MTypeInfo<T, C>)enumLeafInfo);
        }
        return typeInfoMap;
    }

    private Map<String, MPropertyInfo<T, C>> createPropertyInfoMap(MModelInfo<T, C> modelInfo) {
        HashMap<String, MPropertyInfo<T, C>> propertyInfoMap = new HashMap<String, MPropertyInfo<T, C>>();
        for (MClassInfo classInfo : modelInfo.getClassInfos()) {
            for (MPropertyInfo propertyInfo : classInfo.getProperties()) {
                String name = classInfo.getName() + "." + propertyInfo.getPrivateName();
                propertyInfoMap.put(name, propertyInfo);
            }
        }
        return propertyInfoMap;
    }

    public DirectedGraph<InfoVertex<T, C>, DependencyEdge> getGraph() {
        return this.graph;
    }

    public Collection<MPackageInfo> getPackageInfos() {
        return this.packageInfos;
    }

    public Set<String> getPackageNames() {
        return this.packageNames;
    }

    public Map<String, MPackageInfo> getPackageInfoMap() {
        return this.packageInfoMap;
    }

    private Map<String, MPackageInfo> createPackageInfoMap(Map<String, PackageInfoVertex<T, C>> packageVertexMap) {
        HashMap<String, MPackageInfo> packageInfoMap = new HashMap<String, MPackageInfo>();
        for (Map.Entry<String, PackageInfoVertex<T, C>> entry : packageVertexMap.entrySet()) {
            packageInfoMap.put(entry.getKey(), entry.getValue().getPackageInfo());
        }
        return packageInfoMap;
    }

    private Map<String, PackageInfoVertex<T, C>> createPackageVertexMap(DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph) {
        final HashMap<String, PackageInfoVertex<T, C>> packageVertexMap = new HashMap<String, PackageInfoVertex<T, C>>();
        for (InfoVertex vertex : graph.vertexSet()) {
            vertex.accept(new DefaultInfoVertexVisitor<T, C, Void>(){

                @Override
                public Void visitPackageInfoVertex(PackageInfoVertex<T, C> vertex) {
                    MPackageInfo packageInfo = vertex.getPackageInfo();
                    packageVertexMap.put(packageInfo.getPackageName(), vertex);
                    return null;
                }
            });
        }
        return packageVertexMap;
    }

    private Map<String, Set<InfoVertex<T, C>>> createPackageVerticesMap(DirectedGraph<InfoVertex<T, C>, DependencyEdge> graph) {
        HashMap<String, Set<InfoVertex<T, C>>> packageVerticesMap = new HashMap<String, Set<InfoVertex<T, C>>>();
        for (InfoVertex vertex : graph.vertexSet()) {
            MPackageInfo packageInfo = vertex.getPackageInfo();
            if (packageInfo == null) continue;
            HashSet<InfoVertex> packageVertices = (HashSet<InfoVertex>)packageVerticesMap.get(packageInfo.getPackageName());
            if (packageVertices == null) {
                packageVertices = new HashSet<InfoVertex>();
                packageVerticesMap.put(packageInfo.getPackageName(), packageVertices);
            }
            packageVertices.add(vertex);
        }
        return packageVerticesMap;
    }

    public Set<InfoVertex<T, C>> connectedSetOf(InfoVertex<T, C> vertex) {
        Set<InfoVertex<T, C>> connectedSet = this.vertexToConnectedSet.get(vertex);
        if (connectedSet == null) {
            connectedSet = new HashSet<InfoVertex<T, C>>();
            BreadthFirstIterator i = new BreadthFirstIterator(this.graph, vertex);
            while (i.hasNext()) {
                connectedSet.add((InfoVertex<T, C>)i.next());
            }
            this.vertexToConnectedSet.put(vertex, connectedSet);
        }
        return connectedSet;
    }

    public MTypeInfo<T, C> findTypeInfoByName(MPackageInfo packageInfo, String name) {
        Validate.notNull((Object)packageInfo);
        Validate.notNull((Object)name);
        String typeInfoName = packageInfo.getPackagedName(name);
        return this.typeInfoMap.get(typeInfoName);
    }

    public MPropertyInfo<T, C> findPropertyInfoByName(MPackageInfo packageInfo, String name) {
        Validate.notNull((Object)packageInfo);
        Validate.notNull((Object)name);
        String propertyInfoName = packageInfo.getPackageName() + "." + name;
        return this.propertyInfoMap.get(propertyInfoName);
    }

    public MElementInfo<T, C> findElementInfoByQName(QName name) {
        Validate.notNull((Object)name);
        return this.elementInfoMap.get(name);
    }
}

