/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import org.hibernate.mapping.Fetchable;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.Value;
import org.hibernate.tool.api.reveng.AssociationInfo;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.PropertyBinder;
import org.hibernate.tool.internal.reveng.util.RevengUtils;

class EntityPropertyBinder
extends AbstractBinder {
    private final PropertyBinder propertyBinder;

    static EntityPropertyBinder create(BinderContext binderContext) {
        return new EntityPropertyBinder(binderContext);
    }

    private EntityPropertyBinder(BinderContext binderContext) {
        super(binderContext);
        this.propertyBinder = PropertyBinder.create(binderContext);
    }

    Property bind(String propertyName, boolean mutable, Table table, ForeignKey fk, ToOne value, boolean inverseProperty) {
        AssociationInfo associationInfo = this.determineAssociationInfo(fk, inverseProperty, mutable);
        BinderUtils.updateFetchMode((Fetchable)value, associationInfo.getFetch());
        return this.propertyBinder.bind(table, propertyName, (Value)value, associationInfo);
    }

    private AssociationInfo determineAssociationInfo(ForeignKey foreignKey, boolean inverseProperty, boolean mutable) {
        AssociationInfo origin = BinderUtils.getAssociationInfo(this.getRevengStrategy(), foreignKey, inverseProperty);
        if (origin != null) {
            return RevengUtils.createAssociationInfo(origin.getCascade(), origin.getFetch(), origin.getInsert() != null ? origin.getInsert() : mutable, origin.getUpdate() != null ? origin.getUpdate() : mutable);
        }
        return RevengUtils.createAssociationInfo(null, null, mutable, mutable);
    }
}

