/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.strategy;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.commons.collections4.MultiValuedMap;
import org.apache.commons.collections4.multimap.HashSetValuedHashMap;
import org.hibernate.MappingException;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.Table;
import org.hibernate.tool.api.reveng.AssociationInfo;
import org.hibernate.tool.api.reveng.RevengStrategy;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.strategy.MetaAttributeHelper;
import org.hibernate.tool.internal.reveng.strategy.OverrideRepository;
import org.hibernate.tool.internal.reveng.strategy.SQLTypeMapping;
import org.hibernate.tool.internal.reveng.strategy.TableFilter;
import org.hibernate.tool.internal.reveng.util.RevengUtils;
import org.hibernate.tool.internal.util.JdbcToHibernateTypeHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class OverrideBinder {
    public static void bindRoot(OverrideRepository repository, Document doc) {
        Element rootElement = doc.getDocumentElement();
        OverrideBinder.bindSchemaSelections(OverrideBinder.getChildElements(rootElement, "schema-selection"), repository);
        OverrideBinder.bindTypeMappings(OverrideBinder.getChildElements(rootElement, "type-mapping"), repository);
        OverrideBinder.bindTableFilters(OverrideBinder.getChildElements(rootElement, "table-filter"), repository);
        OverrideBinder.bindTables(OverrideBinder.getChildElements(rootElement, "table"), repository);
    }

    private static void bindSchemaSelections(ArrayList<Element> schemaSelections, OverrideRepository repository) {
        for (Element schemaSelection : schemaSelections) {
            OverrideBinder.bindSchemaSelection(schemaSelection, repository);
        }
    }

    private static void bindTypeMappings(ArrayList<Element> typeMappings, OverrideRepository repository) {
        if (typeMappings.size() > 0) {
            OverrideBinder.bindTypeMapping(typeMappings.get(0), repository);
        }
    }

    private static void bindTableFilters(ArrayList<Element> tableFilters, OverrideRepository repository) {
        for (Element element : tableFilters) {
            TableFilter tableFilter = new TableFilter();
            tableFilter.setMatchCatalog(OverrideBinder.getAttribute(element, "match-catalog"));
            tableFilter.setMatchSchema(OverrideBinder.getAttribute(element, "match-schema"));
            tableFilter.setMatchName(OverrideBinder.getAttribute(element, "match-name"));
            tableFilter.setExclude(Boolean.valueOf(OverrideBinder.getAttribute(element, "exclude")));
            tableFilter.setPackage(OverrideBinder.getAttribute(element, "package"));
            MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> map = MetaAttributeHelper.loadAndMergeMetaMap(element, (MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>)new HashSetValuedHashMap());
            if (map != null && !map.isEmpty()) {
                tableFilter.setMetaAttributes(map);
            } else {
                tableFilter.setMetaAttributes(null);
            }
            repository.addTableFilter(tableFilter);
        }
    }

    private static void bindTables(ArrayList<Element> tables, OverrideRepository repository) {
        for (Element element : tables) {
            Table table = new Table();
            table.setCatalog(OverrideBinder.getAttribute(element, "catalog"));
            table.setSchema(OverrideBinder.getAttribute(element, "schema"));
            table.setName(OverrideBinder.getAttribute(element, "name"));
            ArrayList<Element> primaryKeys = OverrideBinder.getChildElements(element, "primary-key");
            if (primaryKeys.size() > 0) {
                OverrideBinder.bindPrimaryKey(primaryKeys.get(0), table, repository);
            }
            OverrideBinder.bindColumns(OverrideBinder.getChildElements(element, "column"), table, repository);
            OverrideBinder.bindForeignKeys(OverrideBinder.getChildElements(element, "foreign-key"), table, repository);
            OverrideBinder.bindMetaAttributes(element, table, repository);
            repository.addTable(table, OverrideBinder.getAttribute(element, "class"));
        }
    }

    private static void bindPrimaryKey(Element element, Table table, OverrideRepository repository) {
        String propertyName = OverrideBinder.getAttribute(element, "property");
        String compositeIdName = OverrideBinder.getAttribute(element, "id-class");
        ArrayList<Element> generators = OverrideBinder.getChildElements(element, "generator");
        if (generators.size() > 0) {
            Element generator = generators.get(0);
            String identifierClass = OverrideBinder.getAttribute(generator, "class");
            Properties params = new Properties();
            ArrayList<Element> parameterList = OverrideBinder.getChildElements(generator, "param");
            for (int i = 0; i < parameterList.size(); ++i) {
                Element parameter = parameterList.get(i);
                params.setProperty(OverrideBinder.getAttribute(parameter, "name"), parameter.getTextContent());
            }
            repository.addTableIdentifierStrategy(table, identifierClass, params);
        }
        List<String> boundColumnNames = OverrideBinder.bindColumns(OverrideBinder.getChildElements(element, "key-column"), table, repository);
        repository.addPrimaryKeyNamesForTable(table, boundColumnNames, propertyName, compositeIdName);
    }

    private static List<String> bindColumns(ArrayList<Element> columns, Table table, OverrideRepository repository) {
        ArrayList<String> columnNames = new ArrayList<String>();
        for (Element element : columns) {
            Column column = new Column();
            column.setName(OverrideBinder.getAttribute(element, "name"));
            String attributeValue = OverrideBinder.getAttribute(element, "jdbc-type");
            if (StringHelper.isNotEmpty((String)attributeValue)) {
                column.setSqlTypeCode(Integer.valueOf(JdbcToHibernateTypeHelper.getJDBCType(attributeValue)));
            }
            TableIdentifier tableIdentifier = TableIdentifier.create(table);
            if (table.getColumn(column) != null) {
                throw new MappingException("Column " + column.getName() + " already exists in table " + tableIdentifier);
            }
            MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> map = MetaAttributeHelper.loadAndMergeMetaMap(element, (MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>)new HashSetValuedHashMap());
            if (map != null && !map.isEmpty()) {
                repository.addMetaAttributeInfo(tableIdentifier, column.getName(), map);
            }
            table.addColumn(column);
            columnNames.add(column.getName());
            repository.setTypeNameForColumn(tableIdentifier, column.getName(), OverrideBinder.getAttribute(element, "type"));
            repository.setPropertyNameForColumn(tableIdentifier, column.getName(), OverrideBinder.getAttribute(element, "property"));
            boolean excluded = Boolean.valueOf(element.getAttribute("exclude"));
            if (excluded) {
                repository.setExcludedColumn(tableIdentifier, column.getName());
            }
            if (!element.hasAttribute("foreign-table")) continue;
            String foreignTableName = element.getAttribute("foreign-table");
            ArrayList<Column> localColumns = new ArrayList<Column>();
            localColumns.add(column);
            ArrayList<Column> foreignColumns = new ArrayList<Column>();
            Table foreignTable = new Table();
            foreignTable.setName(foreignTableName);
            foreignTable.setCatalog(element.hasAttribute("foreign-catalog") ? element.getAttribute("foreign-catalog") : table.getCatalog());
            foreignTable.setSchema(element.hasAttribute("foreign-schema") ? element.getAttribute("foreign-schema") : table.getSchema());
            if (!element.hasAttribute("foreign-column")) {
                throw new MappingException("foreign-column is required when foreign-table is specified on " + column);
            }
            String foreignColumnName = element.getAttribute("foreign-column");
            Column foreignColumn = new Column();
            foreignColumn.setName(foreignColumnName);
            foreignColumns.add(foreignColumn);
            ForeignKey key = table.createForeignKey(null, localColumns, foreignTableName, null, foreignColumns);
            key.setReferencedTable(foreignTable);
        }
        return columnNames;
    }

    private static void bindForeignKeys(ArrayList<Element> foreignKeys, Table table, OverrideRepository repository) {
        for (Element element : foreignKeys) {
            String constraintName = OverrideBinder.getAttribute(element, "constraint-name");
            String foreignTableName = OverrideBinder.getAttribute(element, "foreign-table");
            if (foreignTableName != null) {
                Table foreignTable = new Table();
                foreignTable.setName(foreignTableName);
                foreignTable.setCatalog(element.hasAttribute("foreign-catalog") ? element.getAttribute("foreign-catalog") : table.getCatalog());
                foreignTable.setSchema(element.hasAttribute("foreign-schema") ? element.getAttribute("foreign-schema") : table.getSchema());
                ArrayList<Column> localColumns = new ArrayList<Column>();
                ArrayList<Column> foreignColumns = new ArrayList<Column>();
                ArrayList<Element> columnRefs = OverrideBinder.getChildElements(element, "column-ref");
                for (Element columnRef : columnRefs) {
                    localColumns.add(new Column(columnRef.getAttribute("local-column")));
                    foreignColumns.add(new Column(columnRef.getAttribute("foreign-column")));
                }
                ForeignKey key = table.createForeignKey(constraintName, localColumns, foreignTableName, null, foreignColumns);
                key.setReferencedTable(foreignTable);
            }
            if (!StringHelper.isNotEmpty((String)constraintName)) continue;
            if (!OverrideBinder.validateFkAssociations(element)) {
                throw new IllegalArgumentException("you can't mix <many-to-one/> or <set/> with <(inverse-)one-to-one/> ");
            }
            if (OverrideBinder.bindManyToOneAndCollection(element, constraintName, repository)) continue;
            OverrideBinder.bindOneToOne(element, constraintName, repository);
        }
    }

    private static void bindOneToOne(Element element, String constraintName, OverrideRepository repository) {
        String oneToOneProperty = null;
        Boolean excludeOneToOne = null;
        ArrayList<Element> oneToOnes = OverrideBinder.getChildElements(element, "one-to-one");
        Element oneToOne = null;
        AssociationInfo associationInfo = null;
        if (oneToOnes.size() > 0) {
            oneToOne = oneToOnes.get(0);
            oneToOneProperty = OverrideBinder.getAttribute(oneToOne, "property");
            excludeOneToOne = Boolean.valueOf(oneToOne.getAttribute("exclude"));
            associationInfo = OverrideBinder.extractAssociationInfo(oneToOne);
        }
        String inverseOneToOneProperty = null;
        Boolean excludeInverseOneToOne = null;
        ArrayList<Element> inverseOneToOnes = OverrideBinder.getChildElements(element, "inverse-one-to-one");
        Element inverseOneToOne = null;
        AssociationInfo inverseAssociationInfo = null;
        if (inverseOneToOnes.size() > 0) {
            inverseOneToOne = inverseOneToOnes.get(0);
            inverseOneToOneProperty = OverrideBinder.getAttribute(inverseOneToOne, "property");
            excludeInverseOneToOne = Boolean.valueOf(inverseOneToOne.getAttribute("exclude"));
            inverseAssociationInfo = OverrideBinder.extractAssociationInfo(inverseOneToOne);
        }
        if (oneToOne != null) {
            repository.addForeignKeyInfo(constraintName, oneToOneProperty, excludeOneToOne, inverseOneToOneProperty, excludeInverseOneToOne, associationInfo, inverseAssociationInfo);
        }
    }

    private static boolean bindManyToOneAndCollection(Element element, String constraintName, OverrideRepository repository) {
        String manyToOneProperty = null;
        Boolean excludeManyToOne = null;
        AssociationInfo associationInfo = null;
        AssociationInfo inverseAssociationInfo = null;
        ArrayList<Element> manyToOnes = OverrideBinder.getChildElements(element, "many-to-one");
        Element manyToOne = null;
        if (manyToOnes.size() > 0) {
            manyToOne = manyToOnes.get(0);
            manyToOneProperty = OverrideBinder.getAttribute(manyToOne, "property");
            excludeManyToOne = Boolean.valueOf(manyToOne.getAttribute("exclude"));
            associationInfo = OverrideBinder.extractAssociationInfo(manyToOne);
        }
        String collectionProperty = null;
        Boolean excludeCollection = null;
        ArrayList<Element> sets = OverrideBinder.getChildElements(element, "set");
        Element set = null;
        if (sets.size() > 0) {
            set = sets.get(0);
            collectionProperty = OverrideBinder.getAttribute(set, "property");
            excludeCollection = Boolean.valueOf(set.getAttribute("exclude"));
            inverseAssociationInfo = OverrideBinder.extractAssociationInfo(set);
        }
        if (manyToOne != null || set != null) {
            repository.addForeignKeyInfo(constraintName, manyToOneProperty, excludeManyToOne, collectionProperty, excludeCollection, associationInfo, inverseAssociationInfo);
            return true;
        }
        return false;
    }

    private static AssociationInfo extractAssociationInfo(Element manyToOne) {
        return RevengUtils.createAssociationInfo(manyToOne.hasAttribute("cascade") ? manyToOne.getAttribute("cascade") : null, manyToOne.hasAttribute("fetch") ? manyToOne.getAttribute("fetch") : null, manyToOne.hasAttribute("insert") ? Boolean.valueOf(Boolean.parseBoolean(manyToOne.getAttribute("insert"))) : null, manyToOne.hasAttribute("update") ? Boolean.valueOf(Boolean.parseBoolean(manyToOne.getAttribute("update"))) : null);
    }

    private static boolean validateFkAssociations(Element element) {
        ArrayList<Element> manyToOnes = OverrideBinder.getChildElements(element, "many-to-one");
        ArrayList<Element> oneToOnes = OverrideBinder.getChildElements(element, "one-to-one");
        ArrayList<Element> sets = OverrideBinder.getChildElements(element, "set");
        ArrayList<Element> inverseOneToOnes = OverrideBinder.getChildElements(element, "inverse-one-to-one");
        if (manyToOnes.size() != 0 && (oneToOnes.size() != 0 || inverseOneToOnes.size() != 0)) {
            return false;
        }
        if (oneToOnes.size() != 0 && sets.size() != 0) {
            return false;
        }
        return inverseOneToOnes.size() == 0 || sets.size() == 0;
    }

    private static void bindMetaAttributes(Element element, Table table, OverrideRepository repository) {
        MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute> map = MetaAttributeHelper.loadAndMergeMetaMap(element, (MultiValuedMap<String, MetaAttributeHelper.SimpleMetaAttribute>)new HashSetValuedHashMap());
        if (map != null && !map.isEmpty()) {
            repository.addMetaAttributeInfo(table, map);
        }
    }

    private static void bindSchemaSelection(final Element schemaSelectionElement, OverrideRepository repository) {
        repository.addSchemaSelection(new RevengStrategy.SchemaSelection(){

            @Override
            public String getMatchCatalog() {
                return OverrideBinder.getAttribute(schemaSelectionElement, "match-catalog");
            }

            @Override
            public String getMatchSchema() {
                return OverrideBinder.getAttribute(schemaSelectionElement, "match-schema");
            }

            @Override
            public String getMatchTable() {
                return OverrideBinder.getAttribute(schemaSelectionElement, "match-table");
            }
        });
    }

    private static void bindTypeMapping(Element typeMapping, OverrideRepository repository) {
        ArrayList<Element> sqlTypes = OverrideBinder.getChildElements(typeMapping, "sql-type");
        for (int i = 0; i < sqlTypes.size(); ++i) {
            OverrideBinder.bindSqlType(sqlTypes.get(i), repository);
        }
    }

    private static void bindSqlType(Element sqlType, OverrideRepository repository) {
        int jdbcType = JdbcToHibernateTypeHelper.getJDBCType(OverrideBinder.getAttribute(sqlType, "jdbc-type"));
        SQLTypeMapping sqlTypeMapping = new SQLTypeMapping(jdbcType);
        sqlTypeMapping.setHibernateType(OverrideBinder.getHibernateType(sqlType));
        sqlTypeMapping.setLength(OverrideBinder.getInteger(OverrideBinder.getAttribute(sqlType, "length"), Integer.MAX_VALUE));
        sqlTypeMapping.setPrecision(OverrideBinder.getInteger(OverrideBinder.getAttribute(sqlType, "precision"), Integer.MAX_VALUE));
        sqlTypeMapping.setScale(OverrideBinder.getInteger(OverrideBinder.getAttribute(sqlType, "scale"), Integer.MAX_VALUE));
        String notNull = OverrideBinder.getAttribute(sqlType, "not-null");
        if (StringHelper.isEmpty((String)notNull)) {
            sqlTypeMapping.setNullable(null);
        } else {
            sqlTypeMapping.setNullable(notNull.equals("false"));
        }
        if (StringHelper.isEmpty((String)sqlTypeMapping.getHibernateType())) {
            throw new MappingException("No hibernate-type specified for " + sqlType.getAttribute("jdbc-type") + " at " + sqlType.getTagName());
        }
        repository.addTypeMapping(sqlTypeMapping);
    }

    private static String getHibernateType(Element element) {
        String attributeValue = OverrideBinder.getAttribute(element, "hibernate-type");
        if (StringHelper.isEmpty((String)attributeValue)) {
            ArrayList<Element> hibernateTypes = OverrideBinder.getChildElements(element, "hibernate-type");
            if (hibernateTypes.size() > 0) {
                Element hibernateType = hibernateTypes.get(0);
                if (hibernateType.hasAttribute("name")) {
                    return hibernateType.getAttribute("name");
                }
            } else {
                return null;
            }
        }
        return attributeValue;
    }

    private static int getInteger(String string, int defaultValue) {
        if (string == null) {
            return defaultValue;
        }
        return Integer.parseInt(string);
    }

    private static ArrayList<Element> getChildElements(Element parent, String tagName) {
        ArrayList<Element> result = new ArrayList<Element>();
        NodeList nodeList = parent.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (!(node instanceof Element) || !tagName.equals(((Element)node).getTagName())) continue;
            result.add((Element)node);
        }
        return result;
    }

    private static String getAttribute(Element element, String attributeName) {
        String result = null;
        if (element.hasAttribute(attributeName)) {
            result = element.getAttribute(attributeName);
        }
        return result;
    }
}

