/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.internal.reveng.binder;

import java.util.Set;
import org.hibernate.FetchMode;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.ForeignKey;
import org.hibernate.mapping.OneToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.ToOne;
import org.hibernate.tool.api.reveng.TableIdentifier;
import org.hibernate.tool.internal.reveng.binder.AbstractBinder;
import org.hibernate.tool.internal.reveng.binder.BinderContext;
import org.hibernate.tool.internal.reveng.binder.BinderUtils;
import org.hibernate.tool.internal.reveng.binder.EntityPropertyBinder;
import org.hibernate.tool.internal.reveng.binder.ForeignKeyUtils;
import org.hibernate.type.ForeignKeyDirection;

class OneToOneBinder
extends AbstractBinder {
    private final EntityPropertyBinder entityPropertyBinder;

    static OneToOneBinder create(BinderContext binderContext) {
        return new OneToOneBinder(binderContext);
    }

    private OneToOneBinder(BinderContext binderContext) {
        super(binderContext);
        this.entityPropertyBinder = EntityPropertyBinder.create(binderContext);
    }

    Property bind(PersistentClass rc, Table targetTable, ForeignKey fk, Set<Column> processedColumns, boolean constrained, boolean inverseProperty) {
        OneToOne value = new OneToOne(this.getMetadataBuildingContext(), targetTable, rc);
        value.setReferencedEntityName(this.getRevengStrategy().tableToClassName(TableIdentifier.create(targetTable)));
        this.addColumns(fk, value, processedColumns);
        value.setFetchMode(FetchMode.SELECT);
        value.setConstrained(constrained);
        value.setForeignKeyType(constrained ? ForeignKeyDirection.FROM_PARENT : ForeignKeyDirection.TO_PARENT);
        return this.entityPropertyBinder.bind(this.getPropertyName(fk, targetTable, inverseProperty), true, targetTable, fk, (ToOne)value, inverseProperty);
    }

    private void addColumns(ForeignKey foreignKey, OneToOne oneToOne, Set<Column> processedColumns) {
        for (Column fkcolumn : foreignKey.getColumns()) {
            BinderUtils.checkColumnForMultipleBinding(fkcolumn);
            oneToOne.addColumn(fkcolumn);
            processedColumns.add(fkcolumn);
        }
    }

    private String getPropertyName(ForeignKey foreignKey, Table table, boolean inverseProperty) {
        if (inverseProperty) {
            return this.getForeignKeyToInverseEntityName(foreignKey, table);
        }
        return this.getForeignKeyToTentityName(foreignKey, table);
    }

    private String getForeignKeyToTentityName(ForeignKey foreignKey, Table table) {
        return this.getRevengStrategy().foreignKeyToEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), TableIdentifier.create(table), foreignKey.getColumns(), ForeignKeyUtils.isUniqueReference(foreignKey));
    }

    private String getForeignKeyToInverseEntityName(ForeignKey foreignKey, Table table) {
        return this.getRevengStrategy().foreignKeyToInverseEntityName(foreignKey.getName(), TableIdentifier.create(foreignKey.getReferencedTable()), foreignKey.getReferencedColumns(), TableIdentifier.create(table), foreignKey.getColumns(), ForeignKeyUtils.isUniqueReference(foreignKey));
    }
}

