/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.time.OffsetTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.Locale;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.util.compare.ComparableComparator;
import org.hibernate.type.AbstractSingleColumnStandardBasicType;
import org.hibernate.type.LiteralType;
import org.hibernate.type.VersionType;
import org.hibernate.type.descriptor.java.JavaTypeDescriptor;
import org.hibernate.type.descriptor.java.OffsetTimeJavaDescriptor;
import org.hibernate.type.descriptor.sql.SqlTypeDescriptor;
import org.hibernate.type.descriptor.sql.TimeTypeDescriptor;

public class OffsetTimeType
extends AbstractSingleColumnStandardBasicType<OffsetTime>
implements VersionType<OffsetTime>,
LiteralType<OffsetTime> {
    public static final OffsetTimeType INSTANCE = new OffsetTimeType();
    public static final DateTimeFormatter FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.S xxxxx", Locale.ENGLISH);

    public OffsetTimeType() {
        super((SqlTypeDescriptor)TimeTypeDescriptor.INSTANCE, (JavaTypeDescriptor)OffsetTimeJavaDescriptor.INSTANCE);
    }

    public String objectToSQLString(OffsetTime value, Dialect dialect) throws Exception {
        return "{t '" + FORMATTER.format(value) + "'}";
    }

    public OffsetTime seed(SessionImplementor session) {
        return OffsetTime.now();
    }

    public OffsetTime next(OffsetTime current, SessionImplementor session) {
        return OffsetTime.now();
    }

    public Comparator<OffsetTime> getComparator() {
        return ComparableComparator.INSTANCE;
    }

    public String getName() {
        return OffsetTime.class.getSimpleName();
    }

    protected boolean registerUnderJavaType() {
        return true;
    }
}

