/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Type;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Mappings;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TypeDef;

public class SimpleValueBinder {
    private static Log log = LogFactory.getLog(SimpleValueBinder.class);
    private String propertyName;
    private String returnedClassName;
    private Ejb3Column[] columns;
    private String persistentClassName;
    private String explicitType = "";
    private Properties typeParameters = new Properties();
    private Mappings mappings;

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void setReturnedClassName(String returnedClassName) {
        this.returnedClassName = returnedClassName;
    }

    public void setColumns(Ejb3Column[] columns) {
        this.columns = columns;
    }

    public void setPersistentClassName(String persistentClassName) {
        this.persistentClassName = persistentClassName;
    }

    public void setExplicitType(String explicitType) {
        this.explicitType = explicitType;
    }

    public void setExplicitType(Type typeAnn) {
        if (typeAnn != null) {
            this.explicitType = typeAnn.type();
            for (Parameter param : typeAnn.parameters()) {
                this.typeParameters.setProperty(param.name(), param.value());
            }
        }
    }

    public void setTypeParameters(Properties typeParameters) {
        this.typeParameters = typeParameters;
    }

    public void setMappings(Mappings mappings) {
        this.mappings = mappings;
    }

    private void validate() {
        Ejb3Column.checkPropertyConsistency(this.columns, this.propertyName);
    }

    public SimpleValue make() {
        this.validate();
        log.debug((Object)("building SimpleValue for " + this.propertyName));
        Table table = this.columns[0].getTable();
        SimpleValue simpleValue = new SimpleValue(table);
        return this.fillSimpleValue(simpleValue);
    }

    private SimpleValue fillSimpleValue(SimpleValue simpleValue) {
        String type = AnnotationBinder.isDefault(this.explicitType) ? this.returnedClassName : this.explicitType;
        TypeDef typeDef = this.mappings.getTypeDef(type);
        if (typeDef != null) {
            type = typeDef.getTypeClass();
            simpleValue.setTypeParameters(typeDef.getParameters());
        }
        if (this.typeParameters != null && this.typeParameters.size() != 0) {
            simpleValue.setTypeParameters(this.typeParameters);
        }
        simpleValue.setTypeName(type);
        if (this.persistentClassName != null) {
            simpleValue.setTypeUsingReflection(this.persistentClassName, this.propertyName);
        }
        for (Ejb3Column column : this.columns) {
            column.linkWithValue(simpleValue);
        }
        return simpleValue;
    }
}

