/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.persistence.FetchType;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.OrderBy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.SortType;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.ArrayBinder;
import org.hibernate.cfg.annotations.BagBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.ListBinder;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.SetBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Backref;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

public abstract class AbstractCollectionBinder {
    private static final Log log = LogFactory.getLog(AbstractCollectionBinder.class);
    protected org.hibernate.mapping.Collection collection;
    protected String propertyName;
    FetchMode fetchMode;
    PropertyHolder propertyHolder;
    int batchSize;
    String where;
    private String mappedBy;
    private Table table;
    private Class collectionType;
    private String targetEntity;
    private ExtendedMappings mappings;
    private boolean unique;
    private Ejb3JoinColumn[] inverseJoinColumns;
    private String cascadeStrategy;
    String cacheConcurrencyStrategy;
    Map<String, String> filters = new HashMap<String, String>();
    String cacheRegionName;
    private boolean oneToMany;
    protected IndexColumn indexColumn;
    private String orderBy;
    private boolean isSorted;
    private Class comparator;
    private boolean hasToBeSorted;
    private String propertyAccessorName;
    private Ejb3JoinColumn[] joinColumns;

    public void setCascadeStrategy(String cascadeStrategy) {
        this.cascadeStrategy = cascadeStrategy;
    }

    public void setPropertyAccessorName(String propertyAccessorName) {
        this.propertyAccessorName = propertyAccessorName;
    }

    public void setUnique(boolean unique) {
        this.unique = unique;
    }

    public void setInverseJoinColumns(Ejb3JoinColumn[] inverseJoinColumns) {
        this.inverseJoinColumns = inverseJoinColumns;
    }

    public void setJoinColumns(Ejb3JoinColumn[] joinColumns) {
        this.joinColumns = joinColumns;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void setBatchSize(BatchSize batchSize) {
        this.batchSize = batchSize == null ? -1 : batchSize.size();
    }

    public void setOrderBy(OrderBy orderByAnn) {
        if (orderByAnn != null) {
            this.orderBy = orderByAnn.clause();
        }
    }

    public void setSort(Sort sortAnn) {
        if (sortAnn != null) {
            boolean bl = this.isSorted = !SortType.UNSORTED.equals((Object)sortAnn.type());
            if (this.isSorted && SortType.COMPARATOR.equals((Object)sortAnn.type())) {
                this.comparator = sortAnn.comparator();
            }
        }
    }

    public static AbstractCollectionBinder getCollectionBinder(Class returnedClass, boolean isArray) {
        AbstractCollectionBinder binder = null;
        if (isArray) {
            binder = new ArrayBinder();
        } else if (returnedClass.equals(Set.class)) {
            binder = new SetBinder();
        } else if (returnedClass.equals(SortedSet.class)) {
            binder = new SetBinder(true);
        } else if (returnedClass.equals(Collection.class)) {
            binder = new BagBinder();
        } else if (returnedClass.equals(List.class)) {
            binder = new ListBinder();
        } else {
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported");
        }
        return binder;
    }

    protected AbstractCollectionBinder() {
    }

    protected AbstractCollectionBinder(boolean sorted) {
        this.hasToBeSorted = sorted;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setCollectionType(Class collectionType) {
        this.collectionType = collectionType;
    }

    public void setTargetEntity(String targetEntity) {
        this.targetEntity = targetEntity;
    }

    public void setMappings(ExtendedMappings mappings) {
        this.mappings = mappings;
    }

    protected abstract org.hibernate.mapping.Collection createCollection(PersistentClass var1);

    public org.hibernate.mapping.Collection getCollection() {
        return this.collection;
    }

    public void setPropertyName(String propertyName) {
        this.propertyName = propertyName;
    }

    public void bind() {
        if (log.isDebugEnabled()) {
            if (!this.oneToMany) {
                if (!this.unique) {
                    log.debug((Object)("Binding as ManyToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName));
                } else {
                    log.debug((Object)("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through an association table"));
                }
            } else {
                log.debug((Object)("Binding a OneToMany: " + this.propertyHolder.getEntityName() + "." + this.propertyName + " through a foreign key"));
            }
        }
        this.collection = this.createCollection(this.propertyHolder.getPersistentClass());
        log.debug((Object)("Collection role: " + StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName)));
        this.collection.setRole(StringHelper.qualify((String)this.propertyHolder.getPath(), (String)this.propertyName));
        this.collection.setFetchMode(this.fetchMode);
        this.collection.setLazy(this.fetchMode == FetchMode.SELECT);
        this.collection.setBatchSize(this.batchSize);
        if (this.orderBy != null) {
            this.collection.setOrderBy(this.orderBy);
        }
        if (this.isSorted) {
            this.collection.setSorted(true);
            if (this.comparator != null) {
                try {
                    this.collection.setComparator((Comparator)this.comparator.newInstance());
                }
                catch (Exception e) {
                    throw new AnnotationException("Could not instantiate comparator class: " + this.comparator.getName());
                }
            }
        } else if (this.hasToBeSorted) {
            throw new AnnotationException("A sorted collection has to define @Sort: " + this.propertyHolder.getEntityName() + "." + this.propertyName);
        }
        if (StringHelper.isNotEmpty((String)this.where)) {
            this.collection.setWhere(this.where);
        }
        if (StringHelper.isNotEmpty((String)this.cacheConcurrencyStrategy)) {
            this.collection.setCacheConcurrencyStrategy(this.cacheConcurrencyStrategy);
            this.collection.setCacheRegionName(this.cacheRegionName);
        }
        for (Map.Entry<String, String> filter : this.filters.entrySet()) {
            this.collection.addFilter(filter.getKey(), filter.getValue());
        }
        boolean isMappedBy = !AnnotationBinder.isDefault(this.mappedBy);
        this.collection.setInverse(isMappedBy);
        this.collection.setCollectionTable(this.table);
        String collType = this.getCollectionType();
        if (this.oneToMany) {
            OneToMany oneToMany = new OneToMany(this.collection.getOwner());
            this.collection.setElement((Value)oneToMany);
            oneToMany.setReferencedEntityName(collType);
        } else if (isMappedBy) {
            this.mappings.addMappedBy(collType, this.mappedBy, this.propertyName);
        }
        this.mappings.addSecondPass(this.getSecondPass(this.mappings, this.joinColumns, this.inverseJoinColumns, collType, this.fetchMode, this.unique), !isMappedBy);
        this.mappings.addCollection(this.collection);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(this.propertyName);
        binder.setValue((Value)this.collection);
        binder.setCascade(this.cascadeStrategy);
        binder.setPropertyAccessorName(this.propertyAccessorName);
        Property prop = binder.make();
        this.propertyHolder.addProperty(prop);
    }

    private String getCollectionType() {
        if (AnnotationBinder.isDefault(this.targetEntity)) {
            if (this.collectionType != null) {
                return this.collectionType.getName();
            }
            throw new AnnotationException("Collection has neither generic type or OneToMany.targetEntity() defined");
        }
        return this.targetEntity;
    }

    public SecondPass getSecondPass(ExtendedMappings mappings, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final String collType, final FetchMode fetchMode, final boolean unique) {
        if (inverseColumns != null) {
            return new SecondPass(mappings, this.collection){

                public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                    AbstractCollectionBinder.bindManyToManySecondPass(this.getCollection(), persistentClasses, keyColumns, inverseColumns, collType, fetchMode, unique, (ExtendedMappings)this.getMappings());
                }
            };
        }
        return new SecondPass(mappings, this.collection){

            public void secondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
                AbstractCollectionBinder.bindCollectionSecondPass(this.getCollection(), persistentClasses, keyColumns, (ExtendedMappings)this.getMappings());
            }
        };
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegionName = AnnotationBinder.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrencyStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrencyStrategy = null;
            this.cacheRegionName = null;
        }
    }

    public void setFetchType(FetchType fetch) {
        this.fetchMode = fetch == FetchType.EAGER ? FetchMode.JOIN : FetchMode.SELECT;
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    public void setOneToMany(boolean oneToMany) {
        this.oneToMany = oneToMany;
    }

    public void setIndexColumn(IndexColumn indexColumn) {
        this.indexColumn = indexColumn;
    }

    protected static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] columns, ExtendedMappings mappings) throws MappingException {
        if (collValue.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collValue.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass associatedClass = (PersistentClass)persistentClasses.get(assocClass);
            if (mappings == null) {
                throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
            }
            Map<String, Join> joins = mappings.getJoins(assocClass);
            if (associatedClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(associatedClass);
            for (Ejb3JoinColumn column : columns) {
                column.setPersistentClass(associatedClass);
                column.setJoins(joins);
                collValue.setCollectionTable(column.getTable());
            }
            log.info((Object)("Mapping collection: " + collValue.getRole() + " -> " + collValue.getCollectionTable().getName()));
        }
        AbstractCollectionBinder.bindCollectionSecondPass(collValue, null, columns);
        if (collValue.isOneToMany() && !collValue.isInverse() && !collValue.getKey().isNullable()) {
            String entityName = ((OneToMany)collValue.getElement()).getReferencedEntityName();
            PersistentClass referenced = mappings.getClass(entityName);
            Backref prop = new Backref();
            prop.setName('_' + columns[0].getPropertyName() + "Backref");
            prop.setUpdateable(false);
            prop.setSelectable(false);
            prop.setCollectionRole(collValue.getRole());
            prop.setValue((Value)collValue.getKey());
            referenced.addProperty((Property)prop);
        }
    }

    private static SimpleValue buildCollectionKey(org.hibernate.mapping.Collection collValue, Ejb3JoinColumn[] joinColumns) {
        String propRef = collValue.getReferencedPropertyName();
        KeyValue keyVal = propRef == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        Ejb3JoinColumn.checkPropertyConsistency(joinColumns, collValue.getOwnerEntityName());
        key.setNullable(joinColumns.length == 0 ? true : joinColumns[0].isNullable());
        key.setUpdateable(joinColumns.length == 0 ? true : joinColumns[0].isUpdatable());
        collValue.setKey((KeyValue)key);
        return key;
    }

    protected static void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, String collType, FetchMode fetchMode, boolean unique, ExtendedMappings mappings) throws MappingException {
        boolean mappedBy;
        PersistentClass collectionEntity = (PersistentClass)persistentClasses.get(collType);
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        boolean bl = mappedBy = !AnnotationBinder.isDefault(joinColumns[0].getMappedBy());
        if (mappedBy) {
            Property otherSideProperty;
            try {
                otherSideProperty = collectionEntity.getProperty(joinColumns[0].getMappedBy());
            }
            catch (MappingException e) {
                throw new AnnotationException("mappedBy reference an unknown property: " + collType + "." + joinColumns[0].getMappedBy());
            }
            Table table = ((org.hibernate.mapping.Collection)otherSideProperty.getValue()).getCollectionTable();
            collValue.setCollectionTable(table);
            for (Ejb3JoinColumn column : joinColumns) {
                column.setDefaultColumnHeader(joinColumns[0].getMappedBy());
            }
        } else {
            for (Ejb3JoinColumn column : joinColumns) {
                String header = mappings.getFromMappedBy(collValue.getOwnerEntityName(), column.getPropertyName());
                header = header == null ? collValue.getOwner().getTable().getName() : header;
                column.setDefaultColumnHeader(header);
            }
            if (collValue.getCollectionTable() == null) {
                String tableName = collValue.getOwner().getTable().getName() + "_" + collectionEntity.getTable().getName();
                Table table = TableBinder.fillTable("", "", tableName, false, new ArrayList(), null, null, mappings);
                collValue.setCollectionTable(table);
            }
        }
        AbstractCollectionBinder.bindCollectionSecondPass(collValue, collectionEntity, joinColumns);
        ManyToOne element = new ManyToOne(collValue.getCollectionTable());
        collValue.setElement((Value)element);
        element.setReferencedEntityName(collType);
        element.setFetchMode(fetchMode);
        element.setLazy(fetchMode != FetchMode.JOIN);
        if (collectionEntity == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        TableBinder.bindManytoManyInverseFk(collectionEntity, inverseJoinColumns, (SimpleValue)element, unique);
    }

    private static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, PersistentClass collectionEntity, Ejb3JoinColumn[] joinColumns) {
        SimpleValue key = AbstractCollectionBinder.buildCollectionKey(collValue, joinColumns);
        TableBinder.bindFk(collValue.getOwner(), collectionEntity, joinColumns, key, false);
    }
}

