/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.beans.Introspector;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import org.hibernate.MappingException;

public class AnnotedElementInferredData {
    private String defaultAccess;
    private String propertyName;
    private Class returnedClass;
    private Class collectionType;
    private String returnedClassName;
    private final AnnotatedElement annotedElt;
    private boolean processed;
    private boolean annotable;
    private boolean skip;
    private static final String EXCEPTION_MESSAGE = "The annoted inferred element should be a field or a getter";
    private boolean isArray;

    public boolean skip() {
        this.execute(false);
        return this.skip;
    }

    public AnnotedElementInferredData(AnnotatedElement annotedElt) {
        this.annotedElt = annotedElt;
    }

    private void execute(boolean throwException) throws MappingException {
        if (!this.processed) {
            this.skip = false;
            this.annotable = true;
            if (!(this.annotedElt instanceof Member)) {
                throw new MappingException(EXCEPTION_MESSAGE);
            }
            this.propertyName = this.retrievePropertyNameFromMember((Member)((Object)this.annotedElt), throwException);
            if (this.annotedElt instanceof Field) {
                Field field = (Field)this.annotedElt;
                this.defaultAccess = "field";
                this.returnedClass = field.getType();
                this.collectionType = this.findCollectionType(field);
                if (field.isSynthetic() || Modifier.isStatic(field.getModifiers())) {
                    this.skip = true;
                }
            } else if (this.annotedElt instanceof Method) {
                Method method = (Method)this.annotedElt;
                this.defaultAccess = "property";
                this.returnedClass = method.getReturnType();
                this.collectionType = this.findCollectionType(method);
                if (method.isSynthetic() || method.isBridge() || Modifier.isStatic(method.getModifiers())) {
                    this.skip = true;
                }
            } else {
                throw new MappingException(EXCEPTION_MESSAGE);
            }
            if (this.returnedClass.isArray()) {
                this.isArray = true;
                this.returnedClass = this.returnedClass.getComponentType();
                this.collectionType = this.returnedClass;
            }
            this.returnedClassName = this.returnedClass.getName();
            if (!this.annotable) {
                this.skip = true;
            }
            this.processed = true;
        }
    }

    private Class findCollectionType(Method method) {
        Type t = method.getGenericReturnType();
        return this.extractType(t);
    }

    private Class findCollectionType(Field field) {
        Type t = field.getGenericType();
        return this.extractType(t);
    }

    private Class extractType(Type t) {
        ParameterizedType pt;
        Type[] genTypes;
        if (t != null && t instanceof ParameterizedType && (genTypes = (pt = (ParameterizedType)t).getActualTypeArguments()).length == 1 && genTypes[0] instanceof Class) {
            return (Class)genTypes[0];
        }
        return null;
    }

    private String retrievePropertyNameFromMember(Member member, boolean throwException) throws MappingException {
        if (member instanceof Field) {
            return member.getName();
        }
        if (member instanceof Method) {
            String methName = member.getName();
            if (methName.startsWith("get")) {
                return Introspector.decapitalize(methName.substring("get".length()));
            }
            if (methName.startsWith("is")) {
                return Introspector.decapitalize(methName.substring("is".length()));
            }
            this.annotable = false;
            if (throwException) {
                throw new MappingException("Annoted Method is not a proper getter: " + methName);
            }
            return methName;
        }
        throw new MappingException(EXCEPTION_MESSAGE);
    }

    public String getDefaultAccess() throws MappingException {
        this.execute(true);
        return this.defaultAccess;
    }

    public String getPropertyName() throws MappingException {
        this.execute(true);
        return this.propertyName;
    }

    public Class getReturnedClass() throws MappingException {
        this.execute(true);
        return this.returnedClass;
    }

    public String getReturnedClassName() throws MappingException {
        this.execute(true);
        return this.returnedClassName;
    }

    public Class getCollectionType() {
        return this.collectionType;
    }

    public boolean isArray() {
        return this.isArray;
    }
}

