/*
 * Decompiled with CFR 0.152.
 */
package me.prettyprint.hom;

import com.google.common.base.Splitter;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import me.prettyprint.cassandra.serializers.ObjectSerializer;
import me.prettyprint.hector.api.beans.HColumn;
import me.prettyprint.hom.CFMappingDef;
import me.prettyprint.hom.PropertyMappingDefinition;
import me.prettyprint.hom.ReflectionHelper;
import me.prettyprint.hom.cache.HectorObjectMapperException;

public class CollectionMapperHelper {
    private ReflectionHelper reflectionHelper = new ReflectionHelper();
    private ObjectSerializer objSer = ObjectSerializer.get();

    public String createCollectionItemColName(String propName, int order) {
        return propName + ":" + order;
    }

    public CollectionItemColName parseCollectionItemColName(String colName) {
        try {
            Iterable split = Splitter.on((char)':').split((CharSequence)colName);
            Iterator iter = split.iterator();
            return new CollectionItemColName((String)iter.next(), Integer.parseInt((String)iter.next()));
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while parsing collection item column name, " + colName, e);
        }
    }

    public byte[] createCollectionInfoColValue(Collection<Object> coll) {
        String className = coll.getClass().getName();
        if (className.endsWith("$SingletonList")) {
            className = "java.util.ArrayList";
        } else if (className.endsWith("$SingletonMap")) {
            className = "java.util.HashMap";
        } else if (className.endsWith("$SingletonSet")) {
            className = "java.util.HashSet";
        }
        return String.valueOf(className + ":" + coll.size()).getBytes();
    }

    public CollectionInfoColValue parseCollectionInfoColValue(byte[] val) {
        try {
            String tmp = new String(val);
            Iterable split = Splitter.on((char)':').split((CharSequence)tmp);
            Iterator iter = split.iterator();
            String className = (String)iter.next();
            return new CollectionInfoColValue(className, Integer.parseInt((String)iter.next()));
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while parsing collection info column value", e);
        }
    }

    public void instantiateCollection(Object obj, HColumn<String, byte[]> col, PropertyMappingDefinition md) {
        CollectionInfoColValue colValue = this.parseCollectionInfoColValue((byte[])col.getValue());
        try {
            Collection collObj;
            Class<?> clazz = Class.forName(colValue.getCollTypeName());
            if (ArrayList.class.isAssignableFrom(clazz)) {
                Constructor cons = ArrayList.class.getConstructor(Integer.TYPE);
                collObj = (Collection)cons.newInstance(colValue.getSize());
            } else {
                collObj = (Collection)clazz.newInstance();
            }
            PropertyDescriptor pd = md.getPropDesc();
            if (null == pd.getWriteMethod()) {
                throw new RuntimeException("property, " + pd.getName() + ", does not have a setter and therefore cannot be set");
            }
            pd.getWriteMethod().invoke(obj, collObj);
        }
        catch (Throwable e) {
            throw new HectorObjectMapperException("exception while instantiating Collection type, " + colValue.getCollTypeName(), e);
        }
    }

    public boolean addColumnToCollection(CFMappingDef<?> cfMapDef, Object obj, String colName, byte[] colValue) {
        Collection coll;
        CollectionItemColName collColumnName;
        try {
            collColumnName = this.parseCollectionItemColName(colName);
        }
        catch (HectorObjectMapperException e) {
            return false;
        }
        PropertyMappingDefinition md = cfMapDef.getPropMapByColumnName(collColumnName.getPropertyName());
        if (null == md) {
            return false;
        }
        try {
            coll = (Collection)this.reflectionHelper.invokeGetter(obj, md);
        }
        catch (HectorObjectMapperException e) {
            return false;
        }
        Object value = this.deserializeCollectionValue(colValue);
        coll.add(value);
        return true;
    }

    public byte[] serializeCollectionValue(Object obj) {
        return this.objSer.toBytes(obj);
    }

    public Object deserializeCollectionValue(byte[] bytes) {
        return this.objSer.fromBytes(bytes);
    }

    public class CollectionInfoColValue {
        private String collTypeName;
        private int size;

        public CollectionInfoColValue(String collTypeName, int size) {
            this.collTypeName = collTypeName;
            this.size = size;
        }

        public String getCollTypeName() {
            return this.collTypeName;
        }

        public int getSize() {
            return this.size;
        }

        private CollectionMapperHelper getOuterType() {
            return CollectionMapperHelper.this;
        }

        public String toString() {
            return "CollectionInfoColValue [collTypeName=" + this.collTypeName + ", size=" + this.size + "]";
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.collTypeName == null ? 0 : this.collTypeName.hashCode());
            result = 31 * result + this.size;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CollectionInfoColValue other = (CollectionInfoColValue)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.collTypeName == null ? other.collTypeName != null : !this.collTypeName.equals(other.collTypeName)) {
                return false;
            }
            return this.size == other.size;
        }
    }

    public class CollectionItemColName {
        private String propertyName;
        private int order;

        public CollectionItemColName(String propertyName, int order) {
            this.propertyName = propertyName;
            this.order = order;
        }

        public String getPropertyName() {
            return this.propertyName;
        }

        public int getOrder() {
            return this.order;
        }

        private CollectionMapperHelper getOuterType() {
            return CollectionMapperHelper.this;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + this.order;
            result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CollectionItemColName other = (CollectionItemColName)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.order != other.order) {
                return false;
            }
            return !(this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName));
        }

        public String toString() {
            return "CollectionItemColName [propertyName=" + this.propertyName + ", order=" + this.order + "]";
        }
    }
}

