/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.atomic.AtomicLongFieldUpdater;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.HdrHistogram.AbstractHistogramBase;
import org.HdrHistogram.AllValuesIterator;
import org.HdrHistogram.HistogramIterationValue;
import org.HdrHistogram.LinearIterator;
import org.HdrHistogram.LogarithmicIterator;
import org.HdrHistogram.PercentileIterator;
import org.HdrHistogram.RecordedValuesIterator;

public abstract class AbstractHistogram
extends AbstractHistogramBase
implements Serializable {
    int leadingZeroCountBase;
    int subBucketHalfCountMagnitude;
    int unitMagnitude;
    int subBucketHalfCount;
    volatile int normalizingIndexOffset;
    long subBucketMask;
    volatile long maxValue = 0L;
    volatile long minNonZeroValue = Long.MAX_VALUE;
    private static final AtomicLongFieldUpdater<AbstractHistogram> maxValueUpdater = AtomicLongFieldUpdater.newUpdater(AbstractHistogram.class, "maxValue");
    private static final AtomicLongFieldUpdater<AbstractHistogram> minNonZeroValueUpdater = AtomicLongFieldUpdater.newUpdater(AbstractHistogram.class, "minNonZeroValue");
    private static final long serialVersionUID = 44L;
    private static int ENCODING_HEADER_SIZE = 40;
    private static int V0_ENCODING_HEADER_SIZE = 32;
    private static final int V0EncodingCookieBase = 478450440;
    private static final int V0EcompressedEncodingCookieBase = 478450441;
    private static final int encodingCookieBase = 478450433;
    private static final int compressedEncodingCookieBase = 478450434;
    private static final Class[] constructorArgsTypes = new Class[]{Long.TYPE, Long.TYPE, Integer.TYPE};

    abstract long getCountAtNormalizedIndex(int var1);

    abstract void incrementCountAtNormalizedIndex(int var1);

    abstract void addToCountAtNormalizedIndex(int var1, long var2);

    abstract void setCountAtNormalizedIndex(int var1, long var2);

    abstract void setTotalCount(long var1);

    abstract void incrementTotalCount();

    abstract void addToTotalCount(long var1);

    abstract void clearCounts();

    abstract int _getEstimatedFootprintInBytes();

    public abstract long getTotalCount();

    void updatedMaxValue(long value) {
        while (value > this.maxValue) {
            maxValueUpdater.compareAndSet(this, this.maxValue, value);
        }
    }

    final void resetMaxValue(long maxValue) {
        this.maxValue = maxValue;
    }

    final void resetNormalizingIndexOffset(int normalizingIndexOffset) {
        this.normalizingIndexOffset = normalizingIndexOffset;
    }

    void updateMinNonZeroValue(long value) {
        while (value < this.minNonZeroValue) {
            minNonZeroValueUpdater.compareAndSet(this, this.minNonZeroValue, value);
        }
    }

    void resetMinNonZeroValue(long minNonZeroValue) {
        this.minNonZeroValue = minNonZeroValue;
    }

    public AbstractHistogram(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        if (lowestDiscernibleValue < 1L) {
            throw new IllegalArgumentException("lowestDiscernibleValue must be >= 1");
        }
        if (highestTrackableValue < 2L * lowestDiscernibleValue) {
            throw new IllegalArgumentException("highestTrackableValue must be >= 2 * lowestDiscernibleValue");
        }
        if (numberOfSignificantValueDigits < 0 || numberOfSignificantValueDigits > 5) {
            throw new IllegalArgumentException("numberOfSignificantValueDigits must be between 0 and 6");
        }
        if (highestTrackableValue > 0x3FFFFFFFFFFFFFFFL) {
            throw new IllegalArgumentException("highestTrackableValue must be <= (Long.MAX_VALUE / 2) (" + highestTrackableValue + ")");
        }
        this.identity = constructionIdentityCount.getAndIncrement();
        this.init(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, 1.0, 0);
    }

    public AbstractHistogram(AbstractHistogram source) {
        this(source.getLowestDiscernibleValue(), source.getHighestTrackableValue(), source.getNumberOfSignificantValueDigits());
        this.setStartTimeStamp(source.getStartTimeStamp());
        this.setEndTimeStamp(source.getEndTimeStamp());
    }

    private void init(long lowestDiscernibleValue, long highestTrackableValue, int numberOfSignificantValueDigits, double integerToDoubleValueConversionRatio, int normalizingIndexOffset) {
        this.lowestDiscernibleValue = lowestDiscernibleValue;
        this.highestTrackableValue = highestTrackableValue;
        this.numberOfSignificantValueDigits = numberOfSignificantValueDigits;
        this.integerToDoubleValueConversionRatio = integerToDoubleValueConversionRatio;
        this.normalizingIndexOffset = normalizingIndexOffset;
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        this.unitMagnitude = (int)Math.floor(Math.log(lowestDiscernibleValue) / Math.log(2.0));
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        this.subBucketHalfCountMagnitude = (subBucketCountMagnitude > 1 ? subBucketCountMagnitude : 1) - 1;
        this.subBucketCount = (int)Math.pow(2.0, this.subBucketHalfCountMagnitude + 1);
        this.subBucketHalfCount = this.subBucketCount / 2;
        this.subBucketMask = (long)this.subBucketCount - 1L << this.unitMagnitude;
        this.bucketCount = this.getBucketsNeededToCoverValue(highestTrackableValue);
        this.countsArrayLength = this.getLengthForNumberOfBuckets(this.bucketCount);
        this.leadingZeroCountBase = 64 - this.unitMagnitude - this.subBucketHalfCountMagnitude - 1;
        this.percentileIterator = new PercentileIterator(this, 1);
        this.recordedValuesIterator = new RecordedValuesIterator(this);
    }

    public void recordValue(long value) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
    }

    public void recordValueWithCount(long value, long count) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
    }

    public void recordValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    public void recordValue(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordValueWithExpectedInterval(value, expectedIntervalBetweenValueSamples);
    }

    private void updateMinAndMax(long value) {
        if (value > this.maxValue) {
            this.updatedMaxValue(value);
        }
        if (value < this.minNonZeroValue && value != 0L) {
            this.updateMinNonZeroValue(value);
        }
    }

    private void recordCountAtValue(long count, long value) throws ArrayIndexOutOfBoundsException {
        int countsIndex = this.countsArrayIndex(value);
        this.addToCountAtIndex(countsIndex, count);
        this.updateMinAndMax(value);
        this.addToTotalCount(count);
    }

    private void recordSingleValue(long value) throws ArrayIndexOutOfBoundsException {
        int countsIndex = this.countsArrayIndex(value);
        this.incrementCountAtIndex(countsIndex);
        this.updateMinAndMax(value);
        this.incrementTotalCount();
    }

    private void recordValueWithCountAndExpectedInterval(long value, long count, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordCountAtValue(count, value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordCountAtValue(count, missingValue);
        }
    }

    private void recordSingleValueWithExpectedInterval(long value, long expectedIntervalBetweenValueSamples) throws ArrayIndexOutOfBoundsException {
        this.recordSingleValue(value);
        if (expectedIntervalBetweenValueSamples <= 0L) {
            return;
        }
        for (long missingValue = value - expectedIntervalBetweenValueSamples; missingValue >= expectedIntervalBetweenValueSamples; missingValue -= expectedIntervalBetweenValueSamples) {
            this.recordSingleValue(missingValue);
        }
    }

    public void reset() {
        this.clearCounts();
        this.resetMaxValue(0L);
        this.resetMinNonZeroValue(Long.MAX_VALUE);
        this.resetNormalizingIndexOffset(0);
    }

    public abstract AbstractHistogram copy();

    public abstract AbstractHistogram copyCorrectedForCoordinatedOmission(long var1);

    public void copyInto(AbstractHistogram targetHistogram) {
        targetHistogram.reset();
        targetHistogram.add(this);
        targetHistogram.setStartTimeStamp(this.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void copyIntoCorrectedForCoordinatedOmission(AbstractHistogram targetHistogram, long expectedIntervalBetweenValueSamples) {
        targetHistogram.reset();
        targetHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        targetHistogram.setStartTimeStamp(this.startTimeStampMsec);
        targetHistogram.setEndTimeStamp(this.endTimeStampMsec);
    }

    public void add(AbstractHistogram otherHistogram) throws ArrayIndexOutOfBoundsException {
        long highestRecordableValue = this.highestEquivalentValue(this.valueFromIndex(this.countsArrayLength - 1));
        if (highestRecordableValue < otherHistogram.getMaxValue()) {
            throw new ArrayIndexOutOfBoundsException("The other histogram includes values that do not fit in this histogram's range.");
        }
        if (this.bucketCount == otherHistogram.bucketCount && this.subBucketCount == otherHistogram.subBucketCount && this.unitMagnitude == otherHistogram.unitMagnitude && this.normalizingIndexOffset == otherHistogram.normalizingIndexOffset) {
            long observedOtherTotalCount = 0L;
            for (int i = 0; i < otherHistogram.countsArrayLength; ++i) {
                long otherCount = otherHistogram.getCountAtIndex(i);
                if (otherCount <= 0L) continue;
                this.addToCountAtIndex(i, otherCount);
                observedOtherTotalCount += otherCount;
            }
            this.setTotalCount(this.getTotalCount() + observedOtherTotalCount);
            this.updatedMaxValue(Math.max(this.getMaxValue(), otherHistogram.getMaxValue()));
            this.updateMinNonZeroValue(Math.min(this.getMinNonZeroValue(), otherHistogram.getMinNonZeroValue()));
        } else {
            for (int i = 0; i < otherHistogram.countsArrayLength; ++i) {
                long otherCount = otherHistogram.getCountAtIndex(i);
                if (otherCount <= 0L) continue;
                this.recordValueWithCount(otherHistogram.valueFromIndex(i), otherCount);
            }
        }
    }

    public void subtract(AbstractHistogram otherHistogram) throws ArrayIndexOutOfBoundsException, IllegalArgumentException {
        long highestRecordableValue = this.valueFromIndex(this.countsArrayLength - 1);
        if (highestRecordableValue < otherHistogram.getMaxValue()) {
            throw new ArrayIndexOutOfBoundsException("The other histogram includes values that do not fit in this histogram's range.");
        }
        if (this.bucketCount == otherHistogram.bucketCount && this.subBucketCount == otherHistogram.subBucketCount && this.unitMagnitude == otherHistogram.unitMagnitude && this.normalizingIndexOffset == otherHistogram.normalizingIndexOffset) {
            long observedOtherTotalCount = 0L;
            for (int i = 0; i < otherHistogram.countsArrayLength; ++i) {
                long otherCount = otherHistogram.getCountAtIndex(i);
                if (otherCount <= 0L) continue;
                if (this.getCountAtIndex(i) < otherCount) {
                    throw new IllegalArgumentException("otherHistogram count (" + otherCount + ") at value " + this.valueFromIndex(i) + " is larger than this one's (" + this.getCountAtIndex(i) + ")");
                }
                this.addToCountAtIndex(i, -otherCount);
                observedOtherTotalCount += otherCount;
            }
            this.setTotalCount(this.getTotalCount() - observedOtherTotalCount);
            this.updatedMaxValue(Math.max(this.getMaxValue(), otherHistogram.getMaxValue()));
            this.updateMinNonZeroValue(Math.min(this.getMinNonZeroValue(), otherHistogram.getMinNonZeroValue()));
        } else {
            for (int i = 0; i < otherHistogram.countsArrayLength; ++i) {
                long otherCount = otherHistogram.getCountAtIndex(i);
                if (otherCount <= 0L) continue;
                long otherValue = otherHistogram.valueFromIndex(i);
                if (this.getCountAtValue(otherValue) < otherCount) {
                    throw new IllegalArgumentException("otherHistogram count (" + otherCount + ") at value " + otherValue + " is larger than this one's (" + this.getCountAtValue(otherValue) + ")");
                }
                this.recordValueWithCount(otherValue, -otherCount);
            }
        }
        if (this.getCountAtValue(this.getMaxValue()) <= 0L || this.getCountAtValue(this.getMinNonZeroValue()) <= 0L) {
            this.establishInternalTackingValues();
        }
    }

    public void addWhileCorrectingForCoordinatedOmission(AbstractHistogram otherHistogram, long expectedIntervalBetweenValueSamples) {
        AbstractHistogram toHistogram = this;
        for (HistogramIterationValue v : otherHistogram.recordedValues()) {
            toHistogram.recordValueWithCountAndExpectedInterval(v.getValueIteratedTo(), v.getCountAtValueIteratedTo(), expectedIntervalBetweenValueSamples);
        }
    }

    public void shiftValuesLeft(int numberOfBinaryOrdersOfMagnitude) {
        if (numberOfBinaryOrdersOfMagnitude < 0) {
            throw new IllegalArgumentException("Cannot shift by a negative number of magnitudes");
        }
        if (numberOfBinaryOrdersOfMagnitude == 0) {
            return;
        }
        if (this.getTotalCount() == this.getCountAtIndex(0)) {
            return;
        }
        int shiftAmount = this.subBucketHalfCount * numberOfBinaryOrdersOfMagnitude;
        int maxValueIndex = this.countsArrayIndex(this.getMaxValue());
        if (maxValueIndex >= this.countsArrayLength - shiftAmount) {
            throw new ArrayIndexOutOfBoundsException("Operation would overflow, would discard recorded value counts");
        }
        int minValueIndex = this.countsArrayIndex(this.getMinNonZeroValue());
        if (minValueIndex < this.subBucketHalfCount) {
            for (int fromIndex = this.subBucketHalfCount - 1; fromIndex > 0; --fromIndex) {
                int toIndex = (fromIndex << numberOfBinaryOrdersOfMagnitude) - shiftAmount;
                this.setCountAtIndex(toIndex, this.getCountAtIndex(fromIndex));
                this.setCountAtIndex(fromIndex, 0L);
            }
        }
        long zeroValueCount = this.getCountAtIndex(0);
        this.setCountAtIndex(0, 0L);
        this.normalizingIndexOffset += shiftAmount;
        this.maxValue <<= numberOfBinaryOrdersOfMagnitude;
        if (this.minNonZeroValue < Long.MAX_VALUE) {
            this.minNonZeroValue <<= numberOfBinaryOrdersOfMagnitude;
        }
        this.setCountAtIndex(0, zeroValueCount);
    }

    public void shiftValuesRight(int numberOfBinaryOrdersOfMagnitude) {
        if (numberOfBinaryOrdersOfMagnitude < 0) {
            throw new IllegalArgumentException("Cannot shift by a negative number of magnitudes");
        }
        if (numberOfBinaryOrdersOfMagnitude == 0) {
            return;
        }
        if (this.getTotalCount() == this.getCountAtIndex(0)) {
            return;
        }
        int shiftAmount = this.subBucketHalfCount * numberOfBinaryOrdersOfMagnitude;
        int minValueIndex = this.countsArrayIndex(this.getMinNonZeroValue());
        if (minValueIndex < shiftAmount + this.subBucketHalfCount) {
            throw new ArrayIndexOutOfBoundsException("Operation would underflow and lose precision of already recorded value counts");
        }
        long zeroValueCount = this.getCountAtIndex(0);
        this.setCountAtIndex(0, 0L);
        this.normalizingIndexOffset -= shiftAmount;
        this.maxValue >>= numberOfBinaryOrdersOfMagnitude;
        if (this.minNonZeroValue < Long.MAX_VALUE) {
            this.minNonZeroValue >>= numberOfBinaryOrdersOfMagnitude;
        }
        this.setCountAtIndex(0, zeroValueCount);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof AbstractHistogram)) {
            return false;
        }
        AbstractHistogram that = (AbstractHistogram)other;
        if (this.lowestDiscernibleValue != that.lowestDiscernibleValue || this.highestTrackableValue != that.highestTrackableValue || this.numberOfSignificantValueDigits != that.numberOfSignificantValueDigits || this.integerToDoubleValueConversionRatio != that.integerToDoubleValueConversionRatio) {
            return false;
        }
        if (this.countsArrayLength != that.countsArrayLength) {
            return false;
        }
        if (this.getTotalCount() != that.getTotalCount()) {
            return false;
        }
        for (int i = 0; i < this.countsArrayLength; ++i) {
            if (this.getCountAtIndex(i) == that.getCountAtIndex(i)) continue;
            return false;
        }
        return true;
    }

    public long getLowestDiscernibleValue() {
        return this.lowestDiscernibleValue;
    }

    public long getHighestTrackableValue() {
        return this.highestTrackableValue;
    }

    public int getNumberOfSignificantValueDigits() {
        return this.numberOfSignificantValueDigits;
    }

    public long sizeOfEquivalentValueRange(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long distanceToNextValue = 1L << this.unitMagnitude + (subBucketIndex >= this.subBucketCount ? bucketIndex + 1 : bucketIndex);
        return distanceToNextValue;
    }

    public long lowestEquivalentValue(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        long thisValueBaseLevel = this.valueFromIndex(bucketIndex, subBucketIndex);
        return thisValueBaseLevel;
    }

    public long highestEquivalentValue(long value) {
        return this.nextNonEquivalentValue(value) - 1L;
    }

    public long medianEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + (this.sizeOfEquivalentValueRange(value) >> 1);
    }

    public long nextNonEquivalentValue(long value) {
        return this.lowestEquivalentValue(value) + this.sizeOfEquivalentValueRange(value);
    }

    public boolean valuesAreEquivalent(long value1, long value2) {
        return this.lowestEquivalentValue(value1) == this.lowestEquivalentValue(value2);
    }

    public int getEstimatedFootprintInBytes() {
        return this._getEstimatedFootprintInBytes();
    }

    @Override
    public long getStartTimeStamp() {
        return this.startTimeStampMsec;
    }

    @Override
    public void setStartTimeStamp(long timeStampMsec) {
        this.startTimeStampMsec = timeStampMsec;
    }

    @Override
    public long getEndTimeStamp() {
        return this.endTimeStampMsec;
    }

    @Override
    public void setEndTimeStamp(long timeStampMsec) {
        this.endTimeStampMsec = timeStampMsec;
    }

    public long getMinValue() {
        if (this.getCountAtIndex(0) > 0L) {
            return 0L;
        }
        return this.getMinNonZeroValue();
    }

    public long getMaxValue() {
        return this.maxValue == 0L ? 0L : this.highestEquivalentValue(this.maxValue);
    }

    long getMinNonZeroValue() {
        return this.minNonZeroValue == Long.MAX_VALUE ? Long.MAX_VALUE : this.lowestEquivalentValue(this.minNonZeroValue);
    }

    @Override
    public double getMaxValueAsDouble() {
        return this.getMaxValue();
    }

    public double getMean() {
        this.recordedValuesIterator.reset();
        long totalValue = 0L;
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            totalValue = iterationValue.getTotalValueToThisValue();
        }
        return (double)totalValue * 1.0 / (double)this.getTotalCount();
    }

    public double getStdDeviation() {
        double mean = this.getMean();
        double geometric_deviation_total = 0.0;
        this.recordedValuesIterator.reset();
        while (this.recordedValuesIterator.hasNext()) {
            HistogramIterationValue iterationValue = this.recordedValuesIterator.next();
            Double deviation = (double)this.medianEquivalentValue(iterationValue.getValueIteratedTo()) * 1.0 - mean;
            geometric_deviation_total += deviation * deviation * (double)iterationValue.getCountAddedInThisIterationStep();
        }
        double std_deviation = Math.sqrt(geometric_deviation_total / (double)this.getTotalCount());
        return std_deviation;
    }

    public long getValueAtPercentile(double percentile) {
        double requestedPercentile = Math.min(percentile, 100.0);
        long countAtPercentile = (long)(requestedPercentile / 100.0 * (double)this.getTotalCount() + 0.5);
        countAtPercentile = Math.max(countAtPercentile, 1L);
        long totalToCurrentIndex = 0L;
        for (int i = 0; i < this.countsArrayLength; ++i) {
            if ((totalToCurrentIndex += this.getCountAtIndex(i)) < countAtPercentile) continue;
            long valueAtIndex = this.valueFromIndex(i);
            return this.highestEquivalentValue(valueAtIndex);
        }
        return 0L;
    }

    public double getPercentileAtOrBelowValue(long value) {
        int targetIndex = this.countsArrayIndex(value);
        long totalToCurrentIndex = 0L;
        for (int i = 0; i <= targetIndex; ++i) {
            totalToCurrentIndex += this.getCountAtIndex(i);
        }
        return 100.0 * (double)totalToCurrentIndex / (double)this.getTotalCount();
    }

    public long getCountBetweenValues(long lowValue, long highValue) throws ArrayIndexOutOfBoundsException {
        int lowIndex = this.countsArrayIndex(lowValue);
        int highIndex = this.countsArrayIndex(highValue);
        long count = 0L;
        for (int i = lowIndex; i <= highIndex; ++i) {
            count += this.getCountAtIndex(i);
        }
        return count;
    }

    public long getCountAtValue(long value) throws ArrayIndexOutOfBoundsException {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        return this.getCountAt(bucketIndex, subBucketIndex);
    }

    public Percentiles percentiles(int percentileTicksPerHalfDistance) {
        return new Percentiles(this, percentileTicksPerHalfDistance);
    }

    public LinearBucketValues linearBucketValues(long valueUnitsPerBucket) {
        return new LinearBucketValues(this, valueUnitsPerBucket);
    }

    public LogarithmicBucketValues logarithmicBucketValues(long valueUnitsInFirstBucket, double logBase) {
        return new LogarithmicBucketValues(this, valueUnitsInFirstBucket, logBase);
    }

    public RecordedValues recordedValues() {
        return new RecordedValues(this);
    }

    public AllValues allValues() {
        return new AllValues(this);
    }

    public void outputPercentileDistribution(PrintStream printStream, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, 5, outputValueUnitScalingRatio);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio) {
        this.outputPercentileDistribution(printStream, percentileTicksPerHalfDistance, outputValueUnitScalingRatio, false);
    }

    public void outputPercentileDistribution(PrintStream printStream, int percentileTicksPerHalfDistance, Double outputValueUnitScalingRatio, boolean useCsvFormat) {
        String lastLinePercentileFormatString;
        String percentileFormatString;
        if (useCsvFormat) {
            printStream.format("\"Value\",\"Percentile\",\"TotalCount\",\"1/(1-Percentile)\"\n", new Object[0]);
        } else {
            printStream.format("%12s %14s %10s %14s\n\n", "Value", "Percentile", "TotalCount", "1/(1-Percentile)");
        }
        PercentileIterator iterator = this.percentileIterator;
        iterator.reset(percentileTicksPerHalfDistance);
        if (useCsvFormat) {
            percentileFormatString = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,%.2f\n";
            lastLinePercentileFormatString = "%." + this.numberOfSignificantValueDigits + "f,%.12f,%d,Infinity\n";
        } else {
            percentileFormatString = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d %14.2f\n";
            lastLinePercentileFormatString = "%12." + this.numberOfSignificantValueDigits + "f %2.12f %10d\n";
        }
        while (iterator.hasNext()) {
            HistogramIterationValue iterationValue = iterator.next();
            if (iterationValue.getPercentileLevelIteratedTo() != 100.0) {
                printStream.format(Locale.US, percentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue(), 1.0 / (1.0 - iterationValue.getPercentileLevelIteratedTo() / 100.0));
                continue;
            }
            printStream.format(Locale.US, lastLinePercentileFormatString, (double)iterationValue.getValueIteratedTo() / outputValueUnitScalingRatio, iterationValue.getPercentileLevelIteratedTo() / 100.0, iterationValue.getTotalCountToThisValue());
        }
        if (!useCsvFormat) {
            double mean = this.getMean() / outputValueUnitScalingRatio;
            double std_deviation = this.getStdDeviation() / outputValueUnitScalingRatio;
            printStream.format(Locale.US, "#[Mean    = %12." + this.numberOfSignificantValueDigits + "f, StdDeviation   = %12." + this.numberOfSignificantValueDigits + "f]\n", mean, std_deviation);
            printStream.format(Locale.US, "#[Max     = %12." + this.numberOfSignificantValueDigits + "f, Total count    = %12d]\n", (double)this.getMaxValue() / outputValueUnitScalingRatio, this.getTotalCount());
            printStream.format(Locale.US, "#[Buckets = %12d, SubBuckets     = %12d]\n", this.bucketCount, this.subBucketCount);
        }
    }

    private void writeObject(ObjectOutputStream o) throws IOException {
        o.writeLong(this.lowestDiscernibleValue);
        o.writeLong(this.highestTrackableValue);
        o.writeInt(this.numberOfSignificantValueDigits);
        o.writeInt(this.normalizingIndexOffset);
        o.writeDouble(this.integerToDoubleValueConversionRatio);
        o.writeLong(this.getTotalCount());
        o.writeLong(this.maxValue);
        o.writeLong(this.minNonZeroValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        long lowestDiscernibleValue = o.readLong();
        long highestTrackableValue = o.readLong();
        int numberOfSignificantValueDigits = o.readInt();
        int normalizingIndexOffset = o.readInt();
        double integerToDoubleValueConversionRatio = o.readDouble();
        long indicatedTotalCount = o.readLong();
        long indicatedMaxValue = o.readLong();
        long indicatedMinNonZeroValue = o.readLong();
        this.init(lowestDiscernibleValue, highestTrackableValue, numberOfSignificantValueDigits, integerToDoubleValueConversionRatio, normalizingIndexOffset);
        this.setTotalCount(indicatedTotalCount);
        this.maxValue = indicatedMaxValue;
        this.minNonZeroValue = indicatedMinNonZeroValue;
    }

    @Override
    public int getNeededByteBufferCapacity() {
        return this.getNeededByteBufferCapacity(this.countsArrayLength);
    }

    int getNeededByteBufferCapacity(int relevantLength) {
        return this.getNeededPayloadByteBufferCapacity(relevantLength) + ENCODING_HEADER_SIZE;
    }

    int getNeededPayloadByteBufferCapacity(int relevantLength) {
        return relevantLength * this.wordSizeInBytes;
    }

    abstract void fillCountsArrayFromBuffer(ByteBuffer var1, int var2);

    abstract void fillBufferFromCountsArray(ByteBuffer var1, int var2);

    private int getV0EncodingCookie() {
        return 478450440 + (this.wordSizeInBytes << 4);
    }

    private int getEncodingCookie() {
        return 478450433 + (this.wordSizeInBytes << 4);
    }

    private int getCompressedEncodingCookie() {
        return 478450434 + (this.wordSizeInBytes << 4);
    }

    private static int getCookieBase(int cookie) {
        return cookie & 0xFFFFFF0F;
    }

    private static int getWordSizeInBytesFromCookie(int cookie) {
        return (cookie & 0xF0) >> 4;
    }

    public synchronized int encodeIntoByteBuffer(ByteBuffer buffer) {
        long maxValue = this.getMaxValue();
        int relevantLength = this.countsArrayIndex(maxValue) + 1;
        if (buffer.capacity() < this.getNeededByteBufferCapacity(relevantLength)) {
            throw new ArrayIndexOutOfBoundsException("buffer does not have capacity for" + this.getNeededByteBufferCapacity(relevantLength) + " bytes");
        }
        int initialPosition = buffer.position();
        buffer.putInt(this.getEncodingCookie());
        buffer.putInt(relevantLength * this.wordSizeInBytes);
        buffer.putInt(this.normalizingIndexOffset);
        buffer.putInt(this.numberOfSignificantValueDigits);
        buffer.putLong(this.lowestDiscernibleValue);
        buffer.putLong(this.highestTrackableValue);
        buffer.putDouble(this.getIntegerToDoubleValueConversionRatio());
        this.fillBufferFromCountsArray(buffer, relevantLength);
        int bytesWritten = this.getNeededByteBufferCapacity(relevantLength);
        buffer.position(initialPosition + bytesWritten);
        return bytesWritten;
    }

    @Override
    public synchronized int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer, int compressionLevel) {
        if (this.intermediateUncompressedByteBuffer == null) {
            this.intermediateUncompressedByteBuffer = ByteBuffer.allocate(this.getNeededByteBufferCapacity(this.countsArrayLength));
        }
        this.intermediateUncompressedByteBuffer.clear();
        int uncompressedLength = this.encodeIntoByteBuffer(this.intermediateUncompressedByteBuffer);
        int initialTargetPosition = targetBuffer.position();
        targetBuffer.putInt(this.getCompressedEncodingCookie());
        targetBuffer.putInt(0);
        Deflater compressor = new Deflater(compressionLevel);
        compressor.setInput(this.intermediateUncompressedByteBuffer.array(), 0, uncompressedLength);
        compressor.finish();
        byte[] targetArray = targetBuffer.array();
        int compressedTargetOffset = initialTargetPosition + 8;
        int compressedDataLength = compressor.deflate(targetArray, compressedTargetOffset, targetArray.length - compressedTargetOffset);
        compressor.end();
        targetBuffer.putInt(initialTargetPosition + 4, compressedDataLength);
        int bytesWritten = compressedDataLength + 8;
        targetBuffer.position(initialTargetPosition + bytesWritten);
        return bytesWritten;
    }

    public int encodeIntoCompressedByteBuffer(ByteBuffer targetBuffer) {
        return this.encodeIntoCompressedByteBuffer(targetBuffer, -1);
    }

    static AbstractHistogram decodeFromByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) {
        try {
            return AbstractHistogram.decodeFromByteBuffer(buffer, histogramClass, minBarForHighestTrackableValue, null, null);
        }
        catch (DataFormatException ex) {
            throw new RuntimeException(ex);
        }
    }

    static AbstractHistogram decodeFromByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue, Inflater decompressor, ByteBuffer intermediateUncompressedByteBuffer) throws DataFormatException {
        ByteBuffer payLoadSourceBuffer;
        AbstractHistogram histogram;
        Double integerToDoubleValueConversionRatio;
        long highestTrackableValue;
        long lowestTrackableUnitValue;
        int numberOfSignificantValueDigits;
        int normalizingIndexOffset;
        int payloadLength;
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) == 478450433) {
            payloadLength = buffer.getInt();
            normalizingIndexOffset = buffer.getInt();
            numberOfSignificantValueDigits = buffer.getInt();
            lowestTrackableUnitValue = buffer.getLong();
            highestTrackableValue = buffer.getLong();
            integerToDoubleValueConversionRatio = buffer.getDouble();
        } else if (AbstractHistogram.getCookieBase(cookie) == 478450440) {
            numberOfSignificantValueDigits = buffer.getInt();
            lowestTrackableUnitValue = buffer.getLong();
            highestTrackableValue = buffer.getLong();
            long discardTotalCount = buffer.getLong();
            payloadLength = Integer.MAX_VALUE;
            integerToDoubleValueConversionRatio = 1.0;
            normalizingIndexOffset = 0;
        } else {
            throw new IllegalArgumentException("The buffer does not contain a Histogram");
        }
        highestTrackableValue = Math.max(highestTrackableValue, minBarForHighestTrackableValue);
        try {
            Constructor constructor = histogramClass.getConstructor(constructorArgsTypes);
            histogram = (AbstractHistogram)constructor.newInstance(lowestTrackableUnitValue, highestTrackableValue, numberOfSignificantValueDigits);
            histogram.setIntegerToDoubleValueConversionRatio(integerToDoubleValueConversionRatio);
            histogram.resetNormalizingIndexOffset(normalizingIndexOffset);
            if (cookie != histogram.getEncodingCookie() && cookie != histogram.getV0EncodingCookie()) {
                throw new IllegalArgumentException("The buffer's encoded value byte size (" + AbstractHistogram.getWordSizeInBytesFromCookie(cookie) + ") does not match the Histogram's (" + histogram.wordSizeInBytes + ")");
            }
        }
        catch (IllegalAccessException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (NoSuchMethodException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InstantiationException ex) {
            throw new IllegalArgumentException(ex);
        }
        catch (InvocationTargetException ex) {
            throw new IllegalArgumentException(ex);
        }
        int expectedCapacity = Math.min(histogram.getNeededPayloadByteBufferCapacity(histogram.countsArrayLength), payloadLength);
        if (decompressor == null) {
            if (expectedCapacity > buffer.remaining()) {
                throw new IllegalArgumentException("The buffer does not contain the full Histogram payload");
            }
            payLoadSourceBuffer = buffer;
        } else {
            payLoadSourceBuffer = intermediateUncompressedByteBuffer;
            if (payLoadSourceBuffer == null) {
                payLoadSourceBuffer = ByteBuffer.allocate(expectedCapacity);
            } else {
                payLoadSourceBuffer.reset();
                if (payLoadSourceBuffer.remaining() < expectedCapacity) {
                    throw new IllegalArgumentException("Supplied intermediate not large enough (capacity = " + payLoadSourceBuffer.capacity() + ", expected = " + expectedCapacity);
                }
                payLoadSourceBuffer.limit(expectedCapacity);
            }
            int decompressedByteCount = decompressor.inflate(payLoadSourceBuffer.array());
            if (payloadLength < Integer.MAX_VALUE && decompressedByteCount < payloadLength) {
                throw new IllegalArgumentException("The buffer does not contain the indicated payload amount");
            }
        }
        histogram.fillCountsArrayFromSourceBuffer(payLoadSourceBuffer, expectedCapacity / AbstractHistogram.getWordSizeInBytesFromCookie(cookie), AbstractHistogram.getWordSizeInBytesFromCookie(cookie));
        histogram.establishInternalTackingValues();
        return histogram;
    }

    private void fillCountsArrayFromSourceBuffer(ByteBuffer sourceBuffer, int lengthInWords, int wordSizeInBytes) {
        switch (wordSizeInBytes) {
            case 2: {
                ShortBuffer source = sourceBuffer.asShortBuffer();
                for (int i = 0; i < lengthInWords; ++i) {
                    this.setCountAtNormalizedIndex(i, source.get());
                }
                break;
            }
            case 4: {
                IntBuffer source = sourceBuffer.asIntBuffer();
                for (int i = 0; i < lengthInWords; ++i) {
                    this.setCountAtNormalizedIndex(i, source.get());
                }
                break;
            }
            case 8: {
                LongBuffer source = sourceBuffer.asLongBuffer();
                for (int i = 0; i < lengthInWords; ++i) {
                    this.setCountAtNormalizedIndex(i, source.get());
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("word size must be 2, 4, or 8 bytes");
            }
        }
    }

    static AbstractHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, Class histogramClass, long minBarForHighestTrackableValue) throws DataFormatException {
        int headerSize;
        int initialTargetPosition = buffer.position();
        int cookie = buffer.getInt();
        if (AbstractHistogram.getCookieBase(cookie) == 478450434) {
            headerSize = ENCODING_HEADER_SIZE;
        } else if (AbstractHistogram.getCookieBase(cookie) == 478450441) {
            headerSize = V0_ENCODING_HEADER_SIZE;
        } else {
            throw new IllegalArgumentException("The buffer does not contain a compressed Histogram");
        }
        int lengthOfCompressedContents = buffer.getInt();
        Inflater decompressor = new Inflater();
        decompressor.setInput(buffer.array(), initialTargetPosition + 8, lengthOfCompressedContents);
        ByteBuffer headerBuffer = ByteBuffer.allocate(headerSize);
        decompressor.inflate(headerBuffer.array());
        AbstractHistogram histogram = AbstractHistogram.decodeFromByteBuffer(headerBuffer, histogramClass, minBarForHighestTrackableValue, decompressor, null);
        return histogram;
    }

    void establishInternalTackingValues() {
        this.resetMaxValue(0L);
        this.resetMinNonZeroValue(Long.MAX_VALUE);
        int maxIndex = -1;
        int minNonZeroIndex = -1;
        long observedTotalCount = 0L;
        for (int index = 0; index < this.countsArrayLength; ++index) {
            long countAtIndex = this.getCountAtIndex(index);
            if (countAtIndex <= 0L) continue;
            observedTotalCount += countAtIndex;
            maxIndex = index;
            if (minNonZeroIndex != -1 || index == 0) continue;
            minNonZeroIndex = index;
        }
        if (maxIndex >= 0) {
            this.updatedMaxValue(this.highestEquivalentValue(this.valueFromIndex(maxIndex)));
        }
        if (minNonZeroIndex >= 0) {
            this.updateMinNonZeroValue(this.valueFromIndex(minNonZeroIndex));
        }
        this.setTotalCount(observedTotalCount);
    }

    int getBucketsNeededToCoverValue(long value) {
        long smallestUntrackableValue = (long)this.subBucketCount << this.unitMagnitude;
        int bucketsNeeded = 1;
        while (smallestUntrackableValue < value) {
            smallestUntrackableValue <<= 1;
            ++bucketsNeeded;
        }
        return bucketsNeeded;
    }

    int getLengthForNumberOfBuckets(int numberOfBuckets) {
        int lengthNeeded = (numberOfBuckets + 1) * (this.subBucketCount / 2);
        return lengthNeeded;
    }

    private int countsArrayIndex(long value) {
        int bucketIndex = this.getBucketIndex(value);
        int subBucketIndex = this.getSubBucketIndex(value, bucketIndex);
        return this.countsArrayIndex(bucketIndex, subBucketIndex);
    }

    private int countsArrayIndex(int bucketIndex, int subBucketIndex) {
        assert (subBucketIndex < this.subBucketCount);
        assert (bucketIndex == 0 || subBucketIndex >= this.subBucketHalfCount);
        int bucketBaseIndex = bucketIndex + 1 << this.subBucketHalfCountMagnitude;
        int offsetInBucket = subBucketIndex - this.subBucketHalfCount;
        return bucketBaseIndex + offsetInBucket;
    }

    int getBucketIndex(long value) {
        return this.leadingZeroCountBase - Long.numberOfLeadingZeros(value | this.subBucketMask);
    }

    int getSubBucketIndex(long value, int bucketIndex) {
        return (int)(value >> bucketIndex + this.unitMagnitude);
    }

    long getCountAt(int bucketIndex, int subBucketIndex) {
        return this.getCountAtIndex(this.countsArrayIndex(bucketIndex, subBucketIndex));
    }

    void checkBounds(int index) {
        if (index > this.countsArrayLength || index < 0) {
            throw new ArrayIndexOutOfBoundsException("index out of covered value range");
        }
    }

    int normalizeIndex(int index) {
        if (this.normalizingIndexOffset == 0) {
            return index;
        }
        this.checkBounds(index);
        int normilizedIndex = index - this.normalizingIndexOffset;
        if (normilizedIndex < 0) {
            normilizedIndex += this.countsArrayLength;
        } else if (normilizedIndex >= this.countsArrayLength) {
            normilizedIndex -= this.countsArrayLength;
        }
        return normilizedIndex;
    }

    long getCountAtIndex(int index) {
        return this.getCountAtNormalizedIndex(this.normalizeIndex(index));
    }

    void incrementCountAtIndex(int index) {
        this.incrementCountAtNormalizedIndex(this.normalizeIndex(index));
    }

    void addToCountAtIndex(int index, long value) {
        this.addToCountAtNormalizedIndex(this.normalizeIndex(index), value);
    }

    void setCountAtIndex(int index, long value) {
        this.setCountAtNormalizedIndex(this.normalizeIndex(index), value);
    }

    final long valueFromIndex(int bucketIndex, int subBucketIndex) {
        return (long)subBucketIndex << bucketIndex + this.unitMagnitude;
    }

    final long valueFromIndex(int index) {
        int bucketIndex = (index >> this.subBucketHalfCountMagnitude) - 1;
        int subBucketIndex = (index & this.subBucketHalfCount - 1) + this.subBucketHalfCount;
        if (bucketIndex < 0) {
            subBucketIndex -= this.subBucketHalfCount;
            bucketIndex = 0;
        }
        return this.valueFromIndex(bucketIndex, subBucketIndex);
    }

    static int numberOfSubbuckets(int numberOfSignificantValueDigits) {
        long largestValueWithSingleUnitResolution = 2L * (long)Math.pow(10.0, numberOfSignificantValueDigits);
        int subBucketCountMagnitude = (int)Math.ceil(Math.log(largestValueWithSingleUnitResolution) / Math.log(2.0));
        int subBucketCount = (int)Math.pow(2.0, subBucketCountMagnitude);
        return subBucketCount;
    }

    public class AllValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private AllValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new AllValuesIterator(this.histogram);
        }
    }

    public class RecordedValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;

        private RecordedValues(AbstractHistogram histogram) {
            this.histogram = histogram;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new RecordedValuesIterator(this.histogram);
        }
    }

    public class LogarithmicBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final long valueUnitsInFirstBucket;
        final double logBase;

        private LogarithmicBucketValues(AbstractHistogram histogram, long valueUnitsInFirstBucket, double logBase) {
            this.histogram = histogram;
            this.valueUnitsInFirstBucket = valueUnitsInFirstBucket;
            this.logBase = logBase;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LogarithmicIterator(this.histogram, this.valueUnitsInFirstBucket, this.logBase);
        }
    }

    public class LinearBucketValues
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final long valueUnitsPerBucket;

        private LinearBucketValues(AbstractHistogram histogram, long valueUnitsPerBucket) {
            this.histogram = histogram;
            this.valueUnitsPerBucket = valueUnitsPerBucket;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new LinearIterator(this.histogram, this.valueUnitsPerBucket);
        }
    }

    public class Percentiles
    implements Iterable<HistogramIterationValue> {
        final AbstractHistogram histogram;
        final int percentileTicksPerHalfDistance;

        private Percentiles(AbstractHistogram histogram, int percentileTicksPerHalfDistance) {
            this.histogram = histogram;
            this.percentileTicksPerHalfDistance = percentileTicksPerHalfDistance;
        }

        @Override
        public Iterator<HistogramIterationValue> iterator() {
            return new PercentileIterator(this.histogram, this.percentileTicksPerHalfDistance);
        }
    }
}

