/*
 * Decompiled with CFR 0.152.
 */
package org.HdrHistogram;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.nio.ByteBuffer;
import java.nio.LongBuffer;
import java.util.Arrays;
import java.util.zip.DataFormatException;
import org.HdrHistogram.AbstractHistogram;

public class SynchronizedHistogram
extends AbstractHistogram {
    long totalCount;
    final long[] counts = new long[this.countsArrayLength];
    private LongBuffer cachedDstLongBuffer = null;
    private ByteBuffer cachedDstByteBuffer = null;
    private int cachedDstByteBufferPosition = 0;

    @Override
    long getCountAtIndex(int index) {
        return this.counts[index];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementCountAtIndex(int index) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            int n = index;
            this.counts[n] = this.counts[n] + 1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToCountAtIndex(int index, long value) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            int n = index;
            this.counts[n] = this.counts[n] + value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void clearCounts() {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            Arrays.fill(this.counts, 0L);
            this.totalCount = 0L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void add(AbstractHistogram other) {
        if (this.identity < other.identity) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                AbstractHistogram abstractHistogram = other;
                synchronized (abstractHistogram) {
                    super.add(other);
                }
            }
        }
        AbstractHistogram abstractHistogram = other;
        synchronized (abstractHistogram) {
            SynchronizedHistogram synchronizedHistogram = this;
            synchronized (synchronizedHistogram) {
                super.add(other);
            }
        }
    }

    @Override
    public SynchronizedHistogram copy() {
        SynchronizedHistogram copy = new SynchronizedHistogram(this);
        copy.add(this);
        return copy;
    }

    @Override
    public SynchronizedHistogram copyCorrectedForCoordinatedOmission(long expectedIntervalBetweenValueSamples) {
        SynchronizedHistogram toHistogram = new SynchronizedHistogram(this);
        toHistogram.addWhileCorrectingForCoordinatedOmission(this, expectedIntervalBetweenValueSamples);
        return toHistogram;
    }

    @Override
    public long getTotalCount() {
        return this.totalCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setTotalCount(long totalCount) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            this.totalCount = totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void incrementTotalCount() {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            ++this.totalCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void addToTotalCount(long value) {
        SynchronizedHistogram synchronizedHistogram = this;
        synchronized (synchronizedHistogram) {
            this.totalCount += value;
        }
    }

    @Override
    int _getEstimatedFootprintInBytes() {
        return 512 + 8 * this.counts.length;
    }

    public SynchronizedHistogram(long highestTrackableValue, int numberOfSignificantValueDigits) {
        this(1L, highestTrackableValue, numberOfSignificantValueDigits);
    }

    public SynchronizedHistogram(long lowestTrackableValue, long highestTrackableValue, int numberOfSignificantValueDigits) {
        super(lowestTrackableValue, highestTrackableValue, numberOfSignificantValueDigits);
        this.wordSizeInBytes = 8;
    }

    private SynchronizedHistogram(AbstractHistogram source) {
        super(source);
        this.wordSizeInBytes = 8;
    }

    public static SynchronizedHistogram decodeFromByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    public static SynchronizedHistogram decodeFromCompressedByteBuffer(ByteBuffer buffer, long minBarForHighestTrackableValue) throws DataFormatException {
        return (SynchronizedHistogram)SynchronizedHistogram.decodeFromCompressedByteBuffer(buffer, SynchronizedHistogram.class, minBarForHighestTrackableValue);
    }

    private void readObject(ObjectInputStream o) throws IOException, ClassNotFoundException {
        o.defaultReadObject();
    }

    @Override
    synchronized void fillCountsArrayFromBuffer(ByteBuffer buffer, int length) {
        buffer.asLongBuffer().get(this.counts, 0, length);
    }

    @Override
    synchronized void fillBufferFromCountsArray(ByteBuffer buffer, int length) {
        if (this.cachedDstLongBuffer == null || buffer != this.cachedDstByteBuffer || buffer.position() != this.cachedDstByteBufferPosition) {
            this.cachedDstByteBuffer = buffer;
            this.cachedDstByteBufferPosition = buffer.position();
            this.cachedDstLongBuffer = buffer.asLongBuffer();
        }
        this.cachedDstLongBuffer.rewind();
        this.cachedDstLongBuffer.put(this.counts, 0, length);
    }
}

