/*
 * Decompiled with CFR 0.152.
 */
package org.hbase.async;

import com.google.protobuf.AbstractMessageLite;
import org.hbase.async.BatchableRpc;
import org.hbase.async.Bytes;
import org.hbase.async.HBaseRpc;
import org.hbase.async.KeyValue;
import org.hbase.async.RegionInfo;
import org.hbase.async.RowLock;
import org.hbase.async.generated.ClientPB;
import org.jboss.netty.buffer.ChannelBuffer;

public final class PutRequest
extends BatchableRpc
implements HBaseRpc.HasTable,
HBaseRpc.HasKey,
HBaseRpc.HasFamily,
HBaseRpc.HasQualifiers,
HBaseRpc.HasValues,
HBaseRpc.IsEdit,
HBaseRpc.HasQualifier,
HBaseRpc.HasValue {
    private static final byte[] PUT = new byte[]{112, 117, 116};
    static final byte CODE = 35;
    static final PutRequest EMPTY_PUT;
    private final byte[][] qualifiers;
    private final byte[][] values;

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values) {
        this(table, key, family, qualifiers, values, Long.MAX_VALUE, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp) {
        this(table, key, family, qualifier, value, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp) {
        this(table, key, family, qualifiers, values, timestamp, -1L);
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, RowLock lock) {
        this(table, key, family, qualifier, value, Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, RowLock lock) {
        this(table, key, family, qualifier, value, timestamp, lock.id());
    }

    public PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp, RowLock lock) {
        this(table, key, family, qualifiers, values, timestamp, lock.id());
    }

    public PutRequest(String table, String key, String family, String qualifier, String value) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, -1L);
    }

    public PutRequest(String table, String key, String family, String qualifier, String value, RowLock lock) {
        this(table.getBytes(), key.getBytes(), family.getBytes(), qualifier.getBytes(), value.getBytes(), Long.MAX_VALUE, lock.id());
    }

    public PutRequest(byte[] table, KeyValue kv) {
        this(table, kv, -1L);
    }

    public PutRequest(byte[] table, KeyValue kv, RowLock lock) {
        this(table, kv, lock.id());
    }

    private PutRequest(byte[] table, KeyValue kv, long lockid) {
        super(table, kv.key(), kv.family(), kv.timestamp(), lockid);
        this.qualifiers = new byte[][]{kv.qualifier()};
        this.values = new byte[][]{kv.value()};
    }

    private PutRequest(byte[] table, byte[] key, byte[] family, byte[] qualifier, byte[] value, long timestamp, long lockid) {
        this(table, key, family, (byte[][])new byte[][]{qualifier}, (byte[][])new byte[][]{value}, timestamp, lockid);
    }

    private PutRequest(byte[] table, byte[] key, byte[] family, byte[][] qualifiers, byte[][] values, long timestamp, long lockid) {
        super(table, key, family, timestamp, lockid);
        KeyValue.checkFamily(family);
        if (qualifiers.length != values.length) {
            throw new IllegalArgumentException("Have " + qualifiers.length + " qualifiers and " + values.length + " values.  Should be equal.");
        }
        if (qualifiers.length == 0) {
            throw new IllegalArgumentException("Need at least one qualifier/value.");
        }
        for (int i = 0; i < qualifiers.length; ++i) {
            KeyValue.checkQualifier(qualifiers[i]);
            KeyValue.checkValue(values[i]);
        }
        this.qualifiers = qualifiers;
        this.values = values;
    }

    @Override
    byte[] method(byte server_version) {
        if (server_version >= 95) {
            return MUTATE;
        }
        return PUT;
    }

    @Override
    public byte[] table() {
        return this.table;
    }

    @Override
    public byte[] key() {
        return this.key;
    }

    @Override
    public byte[] qualifier() {
        return this.qualifiers[0];
    }

    @Override
    public byte[][] qualifiers() {
        return this.qualifiers;
    }

    @Override
    public byte[] value() {
        return this.values[0];
    }

    @Override
    public byte[][] values() {
        return this.values;
    }

    @Override
    public String toString() {
        return super.toStringWithQualifiers("PutRequest", this.family, this.qualifiers, this.values, ", timestamp=" + this.timestamp + ", lockid=" + this.lockid + ", durable=" + this.durable + ", bufferable=" + this.bufferable);
    }

    @Override
    byte version(byte server_version) {
        if (server_version >= 29) {
            return 2;
        }
        return 1;
    }

    @Override
    byte code() {
        return 35;
    }

    @Override
    int numKeyValues() {
        return this.qualifiers.length;
    }

    @Override
    int payloadSize() {
        int size = 0;
        for (int i = 0; i < this.qualifiers.length; ++i) {
            size += KeyValue.predictSerializedSize(this.key, this.family, this.qualifiers[i], this.values[i]);
        }
        return size;
    }

    @Override
    void serializePayload(ChannelBuffer buf) {
        for (int i = 0; i < this.qualifiers.length; ++i) {
            KeyValue.serialize(buf, (byte)4, this.timestamp, this.key, this.family, this.qualifiers[i], this.values[i]);
        }
    }

    private int predictSerializedSize() {
        int size = 0;
        size += 4;
        ++size;
        size += 3;
        size += this.region.name().length;
        return size += this.predictPutSize();
    }

    int predictPutSize() {
        int size = 0;
        ++size;
        ++size;
        ++size;
        size += 3;
        size += this.key.length;
        size += 8;
        size += 8;
        ++size;
        size += 4;
        ++size;
        size += this.family.length;
        size += 4;
        size += 4;
        return size += this.payloadSize();
    }

    @Override
    ClientPB.MutationProto toMutationProto() {
        ClientPB.MutationProto.ColumnValue.Builder columns = ClientPB.MutationProto.ColumnValue.newBuilder().setFamily(Bytes.wrap(this.family));
        for (int i = 0; i < this.qualifiers.length; ++i) {
            ClientPB.MutationProto.ColumnValue.QualifierValue column = ClientPB.MutationProto.ColumnValue.QualifierValue.newBuilder().setQualifier(Bytes.wrap(this.qualifiers[i])).setValue(Bytes.wrap(this.values[i])).setTimestamp(this.timestamp).build();
            columns.addQualifierValue(column);
        }
        ClientPB.MutationProto.Builder put = ClientPB.MutationProto.newBuilder().setRow(Bytes.wrap(this.key)).setMutateType(ClientPB.MutationProto.MutationType.PUT).addColumnValue(columns);
        if (!this.durable) {
            put.setDurability(ClientPB.MutationProto.Durability.SKIP_WAL);
        }
        return put.build();
    }

    @Override
    ChannelBuffer serialize(byte server_version) {
        if (server_version < 95) {
            return this.serializeOld(server_version);
        }
        ClientPB.MutateRequest req = ClientPB.MutateRequest.newBuilder().setRegion(this.region.toProtobuf()).setMutation(this.toMutationProto()).build();
        return PutRequest.toChannelBuffer(MUTATE, (AbstractMessageLite)req);
    }

    private ChannelBuffer serializeOld(byte server_version) {
        ChannelBuffer buf = this.newBuffer(server_version, this.predictSerializedSize());
        buf.writeInt(2);
        PutRequest.writeHBaseByteArray(buf, this.region.name());
        this.serializeInto(buf);
        return buf;
    }

    @Override
    Object deserialize(ChannelBuffer buf, int cell_size) {
        HBaseRpc.ensureNoCell(cell_size);
        ClientPB.MutateResponse resp = PutRequest.readProtobuf(buf, ClientPB.MutateResponse.PARSER);
        return null;
    }

    void serializeInto(ChannelBuffer buf) {
        buf.writeByte(35);
        buf.writeByte(35);
        buf.writeByte(1);
        PutRequest.writeByteArray(buf, this.key);
        buf.writeLong(this.timestamp);
        buf.writeLong(this.lockid);
        buf.writeByte(this.durable ? 1 : 0);
        buf.writeInt(1);
        PutRequest.writeByteArray(buf, this.family);
        buf.writeInt(this.qualifiers.length);
        buf.writeInt(this.payloadSize());
        this.serializePayload(buf);
    }

    static {
        byte[] zero = new byte[]{0};
        byte[][] onezero = new byte[][]{zero};
        EMPTY_PUT = new PutRequest(zero, zero, zero, onezero, onezero);
        EMPTY_PUT.setRegion(new RegionInfo(zero, zero, zero));
    }
}

