/*
 * Copyright 2025 GWT Project Authors
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package com.google.gwt.dev.util;

import com.google.gwt.core.ext.TreeLogger;
import com.google.gwt.dev.About;

import java.net.MalformedURLException;
import java.net.URL;

/**
 * Reference to a help document on the GWT project website.
 */
public class GwtprojectOrgHelpInfo extends TreeLogger.HelpInfo {
  private URL url;

  public GwtprojectOrgHelpInfo(String relativeUrl) {
    try {
      String gwtVersion  = About.getGwtVersion();
      int hashIndex = relativeUrl.indexOf('#');

      if (hashIndex < 0) {
        relativeUrl = relativeUrl + '#' + gwtVersion;
      } else {
        String base = relativeUrl.substring(0, hashIndex + 1);
        String existingFragment = relativeUrl.substring(hashIndex + 1);
        if (existingFragment.isEmpty()) {
          relativeUrl =  base + gwtVersion;
        } else {
          relativeUrl = base + existingFragment + '/' + gwtVersion;
        }
      }
      url = new URL("https://gwtproject.org/doc/latest/gwt-dev-help/" + relativeUrl);
    } catch (MalformedURLException ignored) {
      // ignore, url will be null
    }
  }

  @Override
  public URL getURL() {
    return url;
  }
}
