/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.gridkit.jvmtool.stacktrace.FlatSampleReader;
import org.gridkit.jvmtool.stacktrace.FlatSampleWriter;
import org.gridkit.jvmtool.stacktrace.RotatingStringDictionary;

public class BsvCodec {
    private static final Charset UTF8 = Charset.forName("UTF8");
    private static final byte[] MAGIC1 = "BSV1".getBytes(UTF8);
    static final byte SVI_ZERO = 1;
    static final byte SVI_MINUS_ONE = 2;
    static final byte SVI_MIN32 = 3;
    static final byte SVI_MAX32 = 4;
    static final byte SVI_MIN64 = 5;
    static final byte SVI_MAX64 = 6;
    static final byte SVD_MIN = 8;
    static final byte SVD_ZERO = 8;
    static final byte SVD_NAN = 9;
    static final byte SVD_NINF = 10;
    static final byte SVD_PINF = 11;
    static final byte TAG_MDIC = 0;
    static final byte TAG_DDIC = 1;
    static final byte TAG_FRANGE = 2;
    static final byte TAG_FLIST = 3;
    static final byte TAG_SAMPLE = 4;
    static final byte WT_STRING = 0;
    static final byte WT_LONG = 1;
    static final byte WT_DOUBLE = 2;
    static final byte WT_SPEC = 3;
    static final long DRANGE_TARGET = 0x100000L;
    static final long DRANGE_NEG_THRESHOLD = -17592186044416L;

    public static FlatSampleReader createReader(InputStream stream) throws IOException {
        byte[] mgc = new byte[4];
        int n = stream.read(mgc);
        if (n == 4 && Arrays.equals(MAGIC1, mgc)) {
            return new BsvReader(new GZIPInputStream(stream));
        }
        throw new IOException("Unsupported file format");
    }

    public static FlatSampleWriter createWriter(OutputStream stream) throws IOException {
        stream.write(MAGIC1);
        GZIPOutputStream gzout = new GZIPOutputStream(stream);
        return new BsvWriter(gzout);
    }

    static int readVarInt(DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        int v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7F & b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7F & b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFF & b) << 21;
    }

    static long readVarLong(DataInputStream dis) throws IOException {
        byte b = dis.readByte();
        if ((b & 0x80) == 0) {
            return 0x7F & b;
        }
        long v = 0x7F & b;
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 7;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 14;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 21;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 28;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 35;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 42;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        v |= (0x7FL & (long)b) << 49;
        if ((b & 0x80) == 0) {
            return v;
        }
        b = dis.readByte();
        return v |= (0xFFL & (long)b) << 56;
    }

    static void writeVarInt(DataOutputStream dos, int v) throws IOException {
        if (v < 0) {
            throw new IllegalArgumentException("Out of bounds: " + v);
        }
        int val = v;
        if ((val & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF80) == 0) {
            dos.write(val);
            return;
        }
        dos.write(0x80 | 0x7F & val);
        if (((val >>= 7) & 0xFFFFFF00) == 0) {
            dos.write(val);
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    static void writeVarLong(DataOutputStream dos, long v) throws IOException {
        long val = v;
        if ((val & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF80L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        dos.write(0x80 | (int)(0x7FL & val));
        if (((val >>>= 7) & 0xFFFFFFFFFFFFFF00L) == 0L) {
            dos.write((int)(0xFFL & val));
            return;
        }
        throw new IllegalArgumentException("Out of bounds: " + v);
    }

    private static class ValueMap {
        static final byte FSTRING = 0;
        static final byte FLONG = 1;
        static final byte FDOUBLE = 2;
        String[] keys = new String[16];
        byte[] type = new byte[16];
        String[] svalues = new String[16];
        long[] lvalues = new long[16];
        double[] dvalues = new double[16];
        int size = 0;

        private ValueMap() {
        }

        public void clear() {
            this.size = 0;
            Arrays.fill(this.keys, null);
            Arrays.fill(this.svalues, null);
        }

        public String getFieldAt(int n) {
            return this.keys[n];
        }

        public boolean hasField(String field) {
            return Arrays.binarySearch(this.keys, 0, this.size, field) >= 0;
        }

        public byte getWireTypeAt(int n) {
            if (this.type[n] == 0) {
                return 0;
            }
            if (this.type[n] == 1) {
                if (this.lvalues[n] == 0L || this.lvalues[n] == -1L || this.lvalues[n] == Integer.MIN_VALUE || this.lvalues[n] == Integer.MAX_VALUE || this.lvalues[n] == Long.MIN_VALUE || this.lvalues[n] == Long.MAX_VALUE) {
                    return 3;
                }
                return 1;
            }
            if (this.dvalues[n] == 0.0 || Double.isNaN(this.dvalues[n]) || Double.isInfinite(this.dvalues[n])) {
                return 3;
            }
            return 2;
        }

        public int getSvCodeAt(int n) {
            if (this.type[n] == 1) {
                if (this.lvalues[n] == 0L) {
                    return 1;
                }
                if (this.lvalues[n] == -1L) {
                    return 2;
                }
                if (this.lvalues[n] == Integer.MIN_VALUE) {
                    return 3;
                }
                if (this.lvalues[n] == Integer.MAX_VALUE) {
                    return 4;
                }
                if (this.lvalues[n] == Long.MIN_VALUE) {
                    return 5;
                }
                if (this.lvalues[n] == Long.MAX_VALUE) {
                    return 6;
                }
                throw new RuntimeException("Unreachable");
            }
            if (this.dvalues[n] == 0.0) {
                return 8;
            }
            if (Double.isNaN(this.dvalues[n])) {
                return 9;
            }
            if (this.dvalues[n] == Double.NEGATIVE_INFINITY) {
                return 10;
            }
            if (this.dvalues[n] == Double.POSITIVE_INFINITY) {
                return 11;
            }
            throw new RuntimeException("Unreachable");
        }

        public Object getBoxed(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n < 0) {
                return null;
            }
            switch (this.type[n]) {
                case 0: {
                    return this.svalues[n];
                }
                case 1: {
                    return this.lvalues[n];
                }
                case 2: {
                    return this.dvalues[n];
                }
            }
            return null;
        }

        public Class<?> getType(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n < 0) {
                return null;
            }
            switch (this.type[n]) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Long.TYPE;
                }
                case 2: {
                    return Double.TYPE;
                }
            }
            return null;
        }

        public long getLong(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n < 0 || this.type[n] != 1) {
                throw new IllegalArgumentException("Not a long field '" + field + "'");
            }
            return this.lvalues[n];
        }

        public double getDouble(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n < 0 || this.type[n] != 2) {
                throw new IllegalArgumentException("Not a long field '" + field + "'");
            }
            return this.dvalues[n];
        }

        public String getString(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n < 0 || this.type[n] != 0) {
                throw new IllegalArgumentException("Not a long field '" + field + "'");
            }
            return this.svalues[n];
        }

        public void put(String field, String value) {
            int n = this.putKey(field);
            this.putString(n, value);
        }

        public void put(String field, long value) {
            int n = this.putKey(field);
            this.putLong(n, value);
        }

        public void put(String field, double value) {
            int n = this.putKey(field);
            this.putDouble(n, value);
        }

        private int putKey(String field) {
            int n = Arrays.binarySearch(this.keys, 0, this.size, field);
            if (n >= 0) {
                return n;
            }
            ++this.size;
            n ^= 0xFFFFFFFF;
            if (this.size > this.keys.length) {
                this.keys = Arrays.copyOf(this.keys, 2 * this.keys.length);
            }
            for (int i = this.size - 1; i != n; --i) {
                this.keys[i] = this.keys[i - 1];
            }
            this.keys[n] = field;
            return n;
        }

        private void putString(int n, String value) {
            if (this.svalues.length <= n) {
                this.svalues = Arrays.copyOf(this.svalues, Math.max(n + 1, 2 * this.svalues.length));
            }
            this.setType(n, 0);
            this.svalues[n] = value;
        }

        private void putLong(int n, long value) {
            if (this.lvalues.length <= n) {
                this.lvalues = Arrays.copyOf(this.lvalues, Math.max(n + 1, 2 * this.lvalues.length));
            }
            this.setType(n, 1);
            this.lvalues[n] = value;
        }

        private void putDouble(int n, double value) {
            if (this.dvalues.length <= n) {
                this.dvalues = Arrays.copyOf(this.dvalues, Math.max(n + 1, 2 * this.dvalues.length));
            }
            this.setType(n, 2);
            this.dvalues[n] = value;
        }

        private void setType(int n, int ftype) {
            if (this.type.length <= n) {
                this.type = Arrays.copyOf(this.type, Math.max(n + 1, 2 * this.type.length));
            }
            this.type[n] = (byte)ftype;
        }
    }

    private static class SampleMeta {
        private int id;
        private int width;
        private String[] fields = new String[16];
        private byte[] wireTypes = new byte[16];
        private int[] dynbaseId;
        private int hash = 0;

        private SampleMeta() {
        }

        void reset(int width) {
            this.hash = 0;
            this.width = width;
            if (this.fields.length < width) {
                this.fields = new String[width];
                this.wireTypes = new byte[width];
            }
            this.id = 0;
            this.dynbaseId = null;
        }

        public int hashCode() {
            if (this.hash == 0) {
                int h = 31;
                for (int i = 0; i != this.width; ++i) {
                    h ^= this.fields[i].hashCode() << this.wireTypes[i];
                    h <<= 3;
                }
                if (h == 0) {
                    h = 1;
                }
                this.hash = h;
            }
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj.getClass() != this.getClass()) {
                return false;
            }
            SampleMeta that = (SampleMeta)obj;
            if (this.width != that.width) {
                return false;
            }
            for (int i = 0; i != this.width; ++i) {
                if (this.fields[i].equals(that.fields[i]) && this.wireTypes[i] == that.wireTypes[i]) continue;
                return false;
            }
            return true;
        }

        static /* synthetic */ int[] access$302(SampleMeta x0, int[] x1) {
            x0.dynbaseId = x1;
            return x1;
        }

        static /* synthetic */ String[] access$402(SampleMeta x0, String[] x1) {
            x0.fields = x1;
            return x1;
        }

        static /* synthetic */ byte[] access$502(SampleMeta x0, byte[] x1) {
            x0.wireTypes = x1;
            return x1;
        }
    }

    private static class BsvWriter
    implements FlatSampleWriter {
        private DataOutputStream dos;
        private Map<String, Integer> permDic = new HashMap<String, Integer>();
        private RotatingStringDictionary rtrDic = new RotatingStringDictionary(20480);
        private Map<SampleMeta, SampleMeta> metaDic = new HashMap<SampleMeta, SampleMeta>();
        private int dynamicBaseCounter = 0;
        private long[] dynamicBase = new long[32];
        private SampleMeta metaLookup = new SampleMeta();
        private SampleMeta tupleMeta;
        private ValueMap tuple = new ValueMap();
        private int[] stringBuf = new int[32];

        public BsvWriter(OutputStream os) {
            this.dos = os instanceof DataOutputStream ? (DataOutputStream)os : new DataOutputStream(os);
        }

        @Override
        public FlatSampleWriter set(String field, long value) {
            this.tuple.put(field, value);
            return this;
        }

        @Override
        public FlatSampleWriter set(String field, double value) {
            this.tuple.put(field, value);
            return this;
        }

        @Override
        public FlatSampleWriter set(String field, String value) {
            this.tuple.put(field, value);
            return this;
        }

        @Override
        public void push() throws IOException {
            if (this.tuple.size == 0) {
                throw new IllegalArgumentException("Tuple has not fields");
            }
            this.ensureSampleMeta();
            this.adjustDynBase();
            this.writeSample();
            this.tuple.clear();
            this.tupleMeta = null;
        }

        private void writeSample() throws IOException {
            int i;
            if (this.tupleMeta.width > this.stringBuf.length) {
                this.stringBuf = new int[this.tupleMeta.width];
            }
            for (i = 0; i != this.tupleMeta.width; ++i) {
                if (this.tupleMeta.wireTypes[i] != 0) continue;
                this.stringBuf[i] = this.ensureRtrString(this.tuple.svalues[i]);
            }
            this.dos.writeByte(4);
            BsvCodec.writeVarInt(this.dos, this.tupleMeta.id);
            block7: for (i = 0; i != this.tupleMeta.width; ++i) {
                switch (this.tupleMeta.wireTypes[i]) {
                    case 0: {
                        BsvCodec.writeVarInt(this.dos, this.stringBuf[i]);
                        continue block7;
                    }
                    case 2: {
                        this.dos.writeDouble(this.tuple.dvalues[i]);
                        continue block7;
                    }
                    case 1: {
                        long base = this.getBase(this.tupleMeta.dynbaseId[i]);
                        BsvCodec.writeVarLong(this.dos, this.tuple.lvalues[i] - base);
                        continue block7;
                    }
                    case 3: {
                        BsvCodec.writeVarInt(this.dos, this.tuple.getSvCodeAt(i));
                        continue block7;
                    }
                    default: {
                        throw new RuntimeException("Unreachable");
                    }
                }
            }
        }

        private void adjustDynBase() throws IOException {
            for (int i = 0; i != this.tupleMeta.width; ++i) {
                if (this.tupleMeta.wireTypes[i] != 1) continue;
                int dr = this.tupleMeta.dynbaseId[i];
                long l = this.tuple.lvalues[i];
                this.adjustDynBase(dr, l);
            }
        }

        private void adjustDynBase(int dr, long l) throws IOException {
            long base = this.getBase(dr);
            long m = l - base;
            if (m < 0L && m > -17592186044416L) {
                base = l;
                this.setBase(dr, base);
                this.dos.writeByte(2);
                BsvCodec.writeVarInt(this.dos, dr);
                BsvCodec.writeVarLong(this.dos, base);
            } else if (m > 0x100000L && base == 0L) {
                base = l;
                this.setBase(dr, base);
                this.dos.writeByte(2);
                BsvCodec.writeVarInt(this.dos, dr);
                BsvCodec.writeVarLong(this.dos, base);
            }
        }

        private long getBase(int dr) {
            return dr >= this.dynamicBase.length ? 0L : this.dynamicBase[dr];
        }

        private void setBase(int dr, long value) {
            if (dr >= this.dynamicBase.length) {
                this.dynamicBase = Arrays.copyOf(this.dynamicBase, Math.max(2 * this.dynamicBase.length, dr + 1));
            }
            this.dynamicBase[dr] = value;
        }

        private int ensureSampleMeta() throws IOException {
            this.metaLookup.reset(this.tuple.size);
            for (int i = 0; i != this.tuple.size; ++i) {
                ((SampleMeta)this.metaLookup).fields[i] = this.tuple.getFieldAt(i);
                ((SampleMeta)this.metaLookup).wireTypes[i] = this.tuple.getWireTypeAt(i);
            }
            SampleMeta sm = this.metaDic.get(this.metaLookup);
            if (sm == null) {
                int i;
                sm = new SampleMeta();
                sm.id = this.metaDic.size();
                sm.width = this.metaLookup.width;
                SampleMeta.access$402(sm, Arrays.copyOf(this.metaLookup.fields, sm.width));
                SampleMeta.access$502(sm, Arrays.copyOf(this.metaLookup.wireTypes, sm.width));
                SampleMeta.access$302(sm, new int[sm.width]);
                for (i = 0; i != sm.width; ++i) {
                    if (sm.wireTypes[i] != 1) continue;
                    ((SampleMeta)sm).dynbaseId[i] = this.dynamicBaseCounter++;
                }
                for (i = 0; i != sm.width; ++i) {
                    this.ensurePermString(sm.fields[i]);
                }
                this.metaDic.put(sm, sm);
                this.dos.writeByte(3);
                BsvCodec.writeVarInt(this.dos, sm.width);
                for (i = 0; i != sm.width; ++i) {
                    BsvCodec.writeVarInt(this.dos, this.ensurePermString(sm.fields[i]) << 2 | sm.wireTypes[i]);
                }
            }
            this.tupleMeta = sm;
            return this.tupleMeta.id;
        }

        private int ensurePermString(String str) throws IOException {
            if (str == null) {
                return 0;
            }
            Integer n = this.permDic.get(str);
            if (n == null) {
                n = this.permDic.size() + 1;
                this.permDic.put(str, n);
                this.dos.writeByte(0);
                this.dos.writeUTF(str);
            }
            return n;
        }

        private int ensureRtrString(String str) throws IOException {
            if (str == null) {
                return 0;
            }
            int n = this.rtrDic.intern(str);
            if (n < 0) {
                this.dos.writeByte(1);
                BsvCodec.writeVarInt(this.dos, (n ^= 0xFFFFFFFF) + 1);
                this.dos.writeUTF(str);
            }
            return n + 1;
        }

        @Override
        public void close() throws IOException {
            this.dos.close();
        }
    }

    private static class BsvReader
    implements FlatSampleReader {
        DataInputStream dis;
        List<String> permDic = new ArrayList<String>();
        List<String> rtrDic = new ArrayList<String>();
        List<SampleMeta> metaDic = new ArrayList<SampleMeta>();
        int dynamicBaseCounter = 0;
        long[] dynamicBase = new long[32];
        ValueMap tuple = new ValueMap();
        boolean eos = false;

        public BsvReader(InputStream is) {
            this.dis = is instanceof DataInputStream ? (DataInputStream)is : new DataInputStream(is);
            this.permDic.add(null);
            this.rtrDic.add(null);
        }

        protected void ensureHasValue() {
            if (this.tuple.size == 0) {
                throw new NoSuchElementException("Reader should be primed");
            }
        }

        @Override
        public Collection<String> getAllFields() {
            this.ensureHasValue();
            return Arrays.asList(this.tuple.keys).subList(0, this.tuple.size);
        }

        @Override
        public boolean hasField(String field) {
            this.ensureHasValue();
            return this.tuple.hasField(field);
        }

        @Override
        public Object get(String field) {
            this.ensureHasValue();
            return this.tuple.getBoxed(field);
        }

        @Override
        public Class<?> getFieldType(String field) {
            this.ensureHasValue();
            return this.tuple.getType(field);
        }

        @Override
        public long getLong(String field) {
            this.ensureHasValue();
            return this.tuple.getLong(field);
        }

        @Override
        public double getDouble(String field) {
            this.ensureHasValue();
            return this.tuple.getDouble(field);
        }

        @Override
        public String getString(String field) {
            this.ensureHasValue();
            return this.tuple.getString(field);
        }

        @Override
        public void copyTo(FlatSampleWriter writer) {
            for (int i = 0; i != this.tuple.size; ++i) {
                String f = this.tuple.getFieldAt(i);
                if (this.tuple.type[i] == 0) {
                    writer.set(f, this.tuple.svalues[i]);
                    continue;
                }
                if (this.tuple.type[i] == 1) {
                    writer.set(f, this.tuple.lvalues[i]);
                    continue;
                }
                if (this.tuple.type[i] != 2) continue;
                writer.set(f, this.tuple.dvalues[i]);
            }
        }

        @Override
        public FlatSampleReader prime() {
            if (!this.hasValue()) {
                this.advance();
            }
            return this;
        }

        @Override
        public boolean hasValue() {
            return !this.eos && this.tuple.size > 0;
        }

        @Override
        public boolean advance() {
            try {
                int tag;
                this.tuple.clear();
                block9: while (true) {
                    if ((tag = this.dis.read()) < 0) {
                        this.eos = true;
                        return false;
                    }
                    switch (tag) {
                        case 0: {
                            this.readMDicEntry();
                            continue block9;
                        }
                        case 1: {
                            this.readDDicEntry();
                            continue block9;
                        }
                        case 3: {
                            this.readFListEntry();
                            continue block9;
                        }
                        case 2: {
                            this.readFrangeEntry();
                            continue block9;
                        }
                        case 4: {
                            this.readSample();
                            return true;
                        }
                    }
                    break;
                }
                throw new IOException("Unknown tag #" + tag);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        private void readMDicEntry() throws IOException {
            String str = this.dis.readUTF();
            this.permDic.add(str);
        }

        private void readDDicEntry() throws IOException {
            int n = BsvCodec.readVarInt(this.dis) + 1;
            String str = this.dis.readUTF();
            if (this.rtrDic.size() > n) {
                this.rtrDic.set(n, str);
            } else {
                this.rtrDic.add(str);
            }
        }

        private void readFListEntry() throws IOException {
            int i;
            int n = this.metaDic.size();
            int width = BsvCodec.readVarInt(this.dis);
            SampleMeta sm = new SampleMeta();
            sm.reset(width);
            sm.id = n;
            SampleMeta.access$302(sm, new int[width]);
            for (i = 0; i != width; ++i) {
                int v = BsvCodec.readVarInt(this.dis);
                ((SampleMeta)sm).fields[i] = this.permDic.get(v >> 2);
                ((SampleMeta)sm).wireTypes[i] = (byte)(3 & v);
            }
            for (i = 0; i != width; ++i) {
                if (sm.wireTypes[i] != 1) continue;
                ((SampleMeta)sm).dynbaseId[i] = this.dynamicBaseCounter++;
            }
            this.metaDic.add(sm);
        }

        private void readFrangeEntry() throws IOException {
            int dr = BsvCodec.readVarInt(this.dis);
            long base = BsvCodec.readVarLong(this.dis);
            this.setBase(dr, base);
        }

        private void readSample() throws IOException {
            int meta = BsvCodec.readVarInt(this.dis);
            SampleMeta sm = this.metaDic.get(meta);
            for (int i = 0; i != sm.width; ++i) {
                String f = sm.fields[i];
                if (sm.wireTypes[i] == 3) {
                    int n = BsvCodec.readVarInt(this.dis);
                    switch (n) {
                        case 1: {
                            this.tuple.put(f, 0L);
                            break;
                        }
                        case 2: {
                            this.tuple.put(f, -1L);
                            break;
                        }
                        case 3: {
                            this.tuple.put(f, Integer.MIN_VALUE);
                            break;
                        }
                        case 4: {
                            this.tuple.put(f, Integer.MAX_VALUE);
                            break;
                        }
                        case 5: {
                            this.tuple.put(f, Long.MIN_VALUE);
                            break;
                        }
                        case 6: {
                            this.tuple.put(f, Long.MAX_VALUE);
                            break;
                        }
                        case 8: {
                            this.tuple.put(f, 0.0);
                            break;
                        }
                        case 9: {
                            this.tuple.put(f, Double.NaN);
                            break;
                        }
                        case 10: {
                            this.tuple.put(f, Double.NEGATIVE_INFINITY);
                            break;
                        }
                        case 11: {
                            this.tuple.put(f, Double.POSITIVE_INFINITY);
                            break;
                        }
                        default: {
                            throw new IOException("Unknown special value #" + n);
                        }
                    }
                    continue;
                }
                if (sm.wireTypes[i] == 0) {
                    int n = BsvCodec.readVarInt(this.dis);
                    this.tuple.put(f, this.rtrDic.get(n));
                    continue;
                }
                if (sm.wireTypes[i] == 1) {
                    long n = BsvCodec.readVarLong(this.dis);
                    long base = this.getBase(sm.dynbaseId[i]);
                    this.tuple.put(f, base + n);
                    continue;
                }
                if (sm.wireTypes[i] != 2) continue;
                double n = this.dis.readDouble();
                this.tuple.put(f, n);
            }
        }

        private long getBase(int dr) {
            return dr >= this.dynamicBase.length ? 0L : this.dynamicBase[dr];
        }

        private void setBase(int dr, long value) {
            if (dr >= this.dynamicBase.length) {
                this.dynamicBase = Arrays.copyOf(this.dynamicBase, Math.max(2 * this.dynamicBase.length, dr + 1));
            }
            this.dynamicBase[dr] = value;
        }
    }
}

