/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.stacktrace;

import java.lang.management.ThreadInfo;
import org.gridkit.jvmtool.stacktrace.CounterArray;
import org.gridkit.jvmtool.stacktrace.ThreadCounters;

public class ThreadCapture {
    public long threadId;
    public String threadName;
    public long timestamp;
    public StackTraceElement[] elements;
    public CounterArray counters = new CounterArray();
    public Thread.State state;

    public void copyFrom(ThreadInfo info) {
        this.threadId = info.getThreadId();
        this.threadName = info.getThreadName();
        this.elements = info.getStackTrace();
        this.state = info.getThreadState();
        if (info.getBlockedCount() > 0L) {
            this.counters.set(ThreadCounters.BLOCKED_COUNTER, info.getBlockedCount());
        }
        if (info.getBlockedTime() > 0L) {
            this.counters.set(ThreadCounters.BLOCKED_TIME_MS, info.getBlockedTime());
        }
        if (info.getWaitedCount() > 0L) {
            this.counters.set(ThreadCounters.WAIT_COUNTER, info.getWaitedCount());
        }
        if (info.getWaitedTime() > 0L) {
            this.counters.set(ThreadCounters.WAIT_TIME_MS, info.getWaitedTime());
        }
    }

    public void reset() {
        this.threadId = -1L;
        this.threadName = null;
        this.timestamp = -1L;
        this.elements = null;
        this.counters.reset();
        this.state = null;
    }
}

