/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.util.formating;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import org.gridkit.jvmtool.jackson.DefaultPrettyPrinter;
import org.gridkit.jvmtool.jackson.JsonGenerationException;
import org.gridkit.jvmtool.jackson.JsonGenerator;
import org.gridkit.jvmtool.util.json.JsonWriter;
import org.gridkit.util.formating.GridSink;
import org.gridkit.util.formating.TextTable;

public class GridExportHelper
implements GridSink {
    private final List<List<Object>> data = new ArrayList<List<Object>>();
    private List<Object> row;

    @Override
    public GridExportHelper append(Object value) {
        if (this.row == null) {
            this.row = new ArrayList<Object>();
            this.data.add(this.row);
        }
        this.row.add(value);
        return this;
    }

    @Override
    public GridExportHelper endOfRow() {
        this.row = null;
        return this;
    }

    private String[] toStrings(List<Object> row) {
        String[] trow = new String[row.size()];
        for (int i = 0; i != trow.length; ++i) {
            trow[i] = row.get(i) == null ? "" : String.valueOf(row.get(i));
        }
        return trow;
    }

    public void exportAsCsv(PrintStream printer) {
        TextTable tt = new TextTable();
        for (List<Object> row : this.data) {
            String[] trow = this.toStrings(row);
            tt.addRow(trow);
        }
        try {
            tt.formatCsv(printer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void exportAsJson(PrintStream printer) {
        try {
            String[] hdr = this.toStrings(this.data.get(0));
            OutputStreamWriter osw = new OutputStreamWriter((OutputStream)printer, Charset.forName("utf8"));
            JsonWriter writer = new JsonWriter(osw, new GridPrettyPrinter());
            writer.writeStartArray();
            for (int i = 1; i < this.data.size(); ++i) {
                writer.writeStartObject();
                List<Object> row = this.data.get(i);
                for (int n = 0; n != row.size(); ++n) {
                    Object val = row.get(n);
                    if (val == null) continue;
                    writer.writeFieldName(hdr[n]);
                    writer.writeString(String.valueOf(val));
                }
                writer.writeEndObject();
            }
            writer.writeEndArray();
            writer.flush();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static final class GridPrettyPrinter
    extends DefaultPrettyPrinter {
        public GridPrettyPrinter() {
            this._arrayIndenter = new DefaultPrettyPrinter.NopIndenter();
            this._nesting = 100;
            this._objectIndenter = new DefaultPrettyPrinter.FixedSpaceIndenter();
            this._spacesInObjectEntries = false;
        }

        @Override
        public void writeStartObject(JsonGenerator jg) throws IOException, JsonGenerationException {
            jg.writeRaw('\n');
            super.writeStartObject(jg);
        }

        @Override
        public void writeEndArray(JsonGenerator jg, int nrOfValues) throws IOException, JsonGenerationException {
            jg.writeRaw('\n');
            super.writeEndArray(jg, nrOfValues);
        }
    }
}

