/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.nps.parser;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.gridkit.jvmtool.codec.stacktrace.ThreadSnapshotEventPojo;
import org.gridkit.jvmtool.event.Event;
import org.gridkit.jvmtool.event.EventMorpher;
import org.gridkit.jvmtool.event.EventReader;
import org.gridkit.jvmtool.event.MorphingEventReader;
import org.gridkit.jvmtool.nps.parser.NpsDumpTree;
import org.gridkit.jvmtool.stacktrace.StackFrameArray;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;

public class NpsEventAdapter
implements EventReader<Event> {
    private final CPUResultsSnapshot snapshot;
    private final NpsDumpTree tree;
    private long begingTime;
    private Iterator<NpsDumpTree.Node> nextNode;
    private NpsDumpTree.Node lastNode = null;
    private int multiplier = 0;
    private ThreadSnapshotEventPojo nextEvent;

    public NpsEventAdapter(CPUResultsSnapshot snapshot) {
        this.snapshot = snapshot;
        this.tree = new NpsDumpTree(snapshot);
        this.begingTime = snapshot.getBeginTime();
        this.nextNode = this.tree.globalList.iterator();
        this.seek();
    }

    private void seek() {
        this.nextEvent = new ThreadSnapshotEventPojo();
        if (!this.next(this.nextEvent)) {
            this.nextEvent = null;
        }
    }

    @Override
    public Iterator<Event> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.nextEvent != null;
    }

    @Override
    public Event next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ThreadSnapshotEventPojo e = this.nextEvent;
        this.seek();
        return e;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <M extends Event> EventReader<M> morph(EventMorpher<Event, M> morpher) {
        return new MorphingEventReader<M>(this, morpher);
    }

    @Override
    public Event peekNext() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        return this.nextEvent;
    }

    @Override
    public void dispose() {
    }

    public boolean next(ThreadSnapshotEventPojo pojo) {
        if (this.multiplier <= 0) {
            while (this.nextNode.hasNext()) {
                this.lastNode = this.nextNode.next();
                this.multiplier = (int)this.lastNode.vsampleSelfCount;
                if (this.lastNode.vsampleSelfCount <= 0L) continue;
            }
            if (this.multiplier <= 0) {
                return false;
            }
        }
        pojo.stackTrace(new StackFrameArray(this.lastNode.path));
        pojo.threadId(this.lastNode.threadId);
        pojo.threadName(this.snapshot.getThreadNameForId(this.lastNode.threadId));
        pojo.timestamp(this.begingTime);
        --this.multiplier;
        return true;
    }
}

