/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcflow;

import java.io.IOException;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

class GcKnowledgeBase {
    private static GcTypeMatcher[] GC_CATALOG = new GcTypeMatcher[]{GcKnowledgeBase.eden("Copy", "Eden Space"), GcKnowledgeBase.survivour("Copy", "Survivor Space"), GcKnowledgeBase.tenured("MarkSweepCompact", "Tenured Gen"), GcKnowledgeBase.permanent("MarkSweepCompact", "Perm Gen"), GcKnowledgeBase.permanent("MarkSweepCompact", "Perm Gen [shared-ro]"), GcKnowledgeBase.permanent("MarkSweepCompact", "Perm Gen [shared-rw]"), GcKnowledgeBase.eden("PS Scavenge", "PS Eden Space"), GcKnowledgeBase.survivour("PS Scavenge", "PS Survivor Space"), GcKnowledgeBase.tenured("PS MarkSweep", "PS Old Gen"), GcKnowledgeBase.permanent("PS MarkSweep", "PS Perm Gen"), GcKnowledgeBase.eden("ParNew", "Par Eden Space"), GcKnowledgeBase.survivour("ParNew", "Par Survivor Space"), GcKnowledgeBase.tenured("ConcurrentMarkSweep", "CMS Old Gen"), GcKnowledgeBase.permanent("ConcurrentMarkSweep", "CMS Perm Gen"), GcKnowledgeBase.eden("G1 Young Generation", "G1 Eden"), GcKnowledgeBase.survivour("G1 Young Generation", "G1 Survivor"), GcKnowledgeBase.tenured("G1 Old Generation", "G1 Old Gen"), GcKnowledgeBase.permanent("G1 Old Generation", "G1 Perm Gen"), GcKnowledgeBase.eden("JRockit", "Nursery"), GcKnowledgeBase.tenured("JRockit", "Old Space"), GcKnowledgeBase.permanent("JRockit", "Class Memory")};
    public static ObjectName RUNTIME_MXBEAN = GcKnowledgeBase.name("java.lang:type=Runtime");
    public static ObjectName COLLECTORS_PATTERN = GcKnowledgeBase.name("java.lang:type=GarbageCollector,name=*");

    GcKnowledgeBase() {
    }

    private static ObjectName name(String name) {
        try {
            return new ObjectName(name);
        }
        catch (MalformedObjectNameException e) {
            throw new RuntimeException(e);
        }
    }

    public static Collection<String> allCollectedPools(MBeanServerConnection conn) throws IOException {
        LinkedHashSet<String> pools = new LinkedHashSet<String>();
        for (ObjectName gcn : conn.queryNames(COLLECTORS_PATTERN, null)) {
            GarbageCollectorMXBean gc = JMX.newMXBeanProxy(conn, gcn, GarbageCollectorMXBean.class);
            for (String pool : gc.getMemoryPoolNames()) {
                pools.add(pool);
            }
        }
        return pools;
    }

    public static Map<PoolType, Collection<String>> classifyMemoryPools(MBeanServerConnection conn) throws IOException {
        RuntimeMXBean rtmx = JMX.newMXBeanProxy(conn, RUNTIME_MXBEAN, RuntimeMXBean.class);
        boolean jrockit = rtmx.getVmName().toUpperCase().contains("JROCKIT");
        HashMap<PoolType, Collection<String>> map = new HashMap<PoolType, Collection<String>>();
        for (ObjectName gcn : conn.queryNames(COLLECTORS_PATTERN, null)) {
            GarbageCollectorMXBean gc = JMX.newMXBeanProxy(conn, gcn, GarbageCollectorMXBean.class);
            String gcName = jrockit ? "JRockit" : gc.getName();
            for (String pool : gc.getMemoryPoolNames()) {
                PoolType type = GcKnowledgeBase.classify(gcName, pool);
                if (type == null) continue;
                GcKnowledgeBase.add(map, type, pool);
            }
        }
        return map;
    }

    public static PoolType classify(String gcName, String pool) {
        for (GcTypeMatcher m : GC_CATALOG) {
            if (!m.gcName.equals(gcName) || !m.poolName.equals(pool)) continue;
            return m.type;
        }
        return null;
    }

    private static void add(Map<PoolType, Collection<String>> map, PoolType type, String name) {
        if (map.containsKey((Object)type)) {
            ArrayList<String> names = new ArrayList<String>();
            names.addAll(map.get((Object)type));
            names.add(name);
            map.put(type, names);
        } else {
            map.put(type, Collections.singleton(name));
        }
    }

    private static GcTypeMatcher eden(String algo, String poolName) {
        return new GcTypeMatcher(algo, poolName, PoolType.EDEN);
    }

    private static GcTypeMatcher survivour(String algo, String poolName) {
        return new GcTypeMatcher(algo, poolName, PoolType.SURVIVOR);
    }

    private static GcTypeMatcher tenured(String algo, String poolName) {
        return new GcTypeMatcher(algo, poolName, PoolType.TENURED);
    }

    private static GcTypeMatcher permanent(String algo, String poolName) {
        return new GcTypeMatcher(algo, poolName, PoolType.PERMANENT);
    }

    private static class GcTypeMatcher {
        String gcName;
        String poolName;
        PoolType type;

        public GcTypeMatcher(String gcName, String poolName, PoolType type) {
            this.gcName = gcName;
            this.poolName = poolName;
            this.type = type;
        }
    }

    static enum PoolType {
        EDEN,
        SURVIVOR,
        TENURED,
        PERMANENT;

    }
}

