/*
 * Decompiled with CFR 0.152.
 */
package org.gridkit.jvmtool.gcflow;

import com.sun.management.GarbageCollectorMXBean;
import com.sun.management.GcInfo;
import java.io.IOException;
import java.lang.management.RuntimeMXBean;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.management.JMX;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.gridkit.jvmtool.gcflow.GarbageCollectionSampler;
import org.gridkit.jvmtool.gcflow.GcKnowledgeBase;

class GcAdapter {
    private final GarbageCollectionSampler sampler;
    private final GarbageCollectorMXBean gc;
    private final String name;
    private final long processStartMs;
    private final List<String> collectedPools;
    private final List<String> allCollectedPools;
    private final List<String> edenPools;
    private final List<String> survivourPools;
    private final List<String> youngPools;
    private final List<String> oldPools;
    private final List<String> permPools;
    private final boolean isYoung;
    private final boolean isConcurent;
    private long gcCount = -1L;
    private long prevCollectionEndTime = -1L;

    public GcAdapter(MBeanServerConnection mserver, ObjectName gcname, GarbageCollectionSampler sampler) throws IOException, MalformedObjectNameException {
        this.sampler = sampler;
        this.gc = JMX.newMXBeanProxy(mserver, gcname, GarbageCollectorMXBean.class);
        this.name = this.gc.getName();
        RuntimeMXBean runtime = JMX.newMXBeanProxy(mserver, new ObjectName("java.lang:type=Runtime"), RuntimeMXBean.class);
        this.processStartMs = runtime.getStartTime();
        this.collectedPools = Arrays.asList(this.gc.getMemoryPoolNames());
        this.allCollectedPools = new ArrayList<String>(GcKnowledgeBase.allCollectedPools(mserver));
        Map<GcKnowledgeBase.PoolType, Collection<String>> types = GcKnowledgeBase.classifyMemoryPools(mserver);
        this.edenPools = this.getMemPools(types, GcKnowledgeBase.PoolType.EDEN);
        this.survivourPools = this.getMemPools(types, GcKnowledgeBase.PoolType.SURVIVOR);
        this.oldPools = this.getMemPools(types, GcKnowledgeBase.PoolType.TENURED);
        this.permPools = this.getMemPools(types, GcKnowledgeBase.PoolType.PERMANENT);
        this.youngPools = new ArrayList<String>();
        this.youngPools.addAll(this.edenPools);
        this.youngPools.addAll(this.survivourPools);
        this.isYoung = this.collectedPools.containsAll(this.oldPools);
        this.isConcurent = "ConcurrentMarkSweep".equals(this.name);
    }

    private List<String> getMemPools(Map<GcKnowledgeBase.PoolType, Collection<String>> types, GcKnowledgeBase.PoolType type) {
        List<String> pools = types.containsKey((Object)type) ? new ArrayList<String>(types.get((Object)type)) : Collections.emptyList();
        return pools;
    }

    public void report() {
        try {
            GcInfo lastGc = this.gc.getLastGcInfo();
            if (lastGc == null || lastGc.getId() == this.gcCount) {
                return;
            }
            int missed = (int)(lastGc.getId() - 1L - this.gcCount);
            if (this.gcCount < 0L) {
                missed = 0;
            }
            long gcInterval = lastGc.getStartTime() - this.prevCollectionEndTime;
            this.prevCollectionEndTime = lastGc.getEndTime();
            if (this.gcCount < 0L) {
                gcInterval = -1L;
            }
            if (lastGc.getEndTime() == 0L) {
                this.prevCollectionEndTime = 0L;
                this.gcCount = lastGc.getId();
            } else {
                this.gcCount = lastGc.getId();
                this.sampler.report(this.name, missed, new Report(lastGc, gcInterval));
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private class Report
    implements GarbageCollectionSampler.GcReport {
        private GcInfo gcInfo;
        private long gcInterval;

        public Report(GcInfo gcInfo, long gcInterval) {
            this.gcInfo = gcInfo;
            this.gcInterval = gcInterval;
        }

        @Override
        public long getId() {
            return this.gcInfo.getId();
        }

        @Override
        public long getWallClockStartTime() {
            return GcAdapter.this.processStartMs + this.gcInfo.getStartTime();
        }

        @Override
        public long getWallClockEndTime() {
            return GcAdapter.this.processStartMs + this.gcInfo.getEndTime();
        }

        @Override
        public long getJvmClockStartTime() {
            return this.gcInfo.getStartTime();
        }

        @Override
        public long getJvmClockEndTime() {
            return this.gcInfo.getEndTime();
        }

        @Override
        public long getDuration() {
            return this.gcInfo.getDuration();
        }

        @Override
        public long getTimeSincePreviousGC() {
            return this.gcInterval;
        }

        @Override
        public boolean isYoungGC() {
            return GcAdapter.this.isYoung;
        }

        @Override
        public boolean isConcurrentGC() {
            return GcAdapter.this.isConcurent;
        }

        @Override
        public long getCollectedSize() {
            return this.getTotalSizeBefore() - this.getTotalSizeAfter();
        }

        @Override
        public long getPromotedSize() {
            return this.getSizeAfter(GcAdapter.this.oldPools) - this.getSizeBefore(GcAdapter.this.oldPools);
        }

        @Override
        public long getTotalSizeBefore() {
            return this.getSizeBefore(GcAdapter.this.allCollectedPools);
        }

        @Override
        public long getTotalSizeAfter() {
            return this.getSizeAfter(GcAdapter.this.allCollectedPools);
        }

        @Override
        public Collection<String> getColletedPools() {
            return Collections.unmodifiableCollection(GcAdapter.this.collectedPools);
        }

        @Override
        public Collection<String> getAllCollectedPools() {
            return Collections.unmodifiableCollection(GcAdapter.this.allCollectedPools);
        }

        @Override
        public Collection<String> getAllMemoryPools() {
            return Collections.unmodifiableCollection(this.gcInfo.getMemoryUsageAfterGc().keySet());
        }

        @Override
        public long getSizeBefore(String pool) {
            return this.gcInfo.getMemoryUsageBeforeGc().get(pool).getUsed();
        }

        @Override
        public long getSizeAfter(String pool) {
            return this.gcInfo.getMemoryUsageAfterGc().get(pool).getUsed();
        }

        @Override
        public long getSizeBefore(Collection<String> pools) {
            long total = 0L;
            for (String pool : pools) {
                total += this.getSizeBefore(pool);
            }
            return total;
        }

        @Override
        public long getSizeAfter(Collection<String> pools) {
            long total = 0L;
            for (String pool : pools) {
                total += this.getSizeAfter(pool);
            }
            return total;
        }

        @Override
        public Collection<String> getEdenPools() {
            ArrayList<String> list = new ArrayList<String>(GcAdapter.this.edenPools);
            list.retainAll(this.gcInfo.getMemoryUsageAfterGc().keySet());
            return list;
        }

        @Override
        public Collection<String> getSurvivourPools() {
            ArrayList<String> list = new ArrayList<String>(GcAdapter.this.survivourPools);
            list.retainAll(this.gcInfo.getMemoryUsageAfterGc().keySet());
            return list;
        }

        @Override
        public Collection<String> getOldSpacePools() {
            ArrayList<String> list = new ArrayList<String>(GcAdapter.this.oldPools);
            list.retainAll(this.gcInfo.getMemoryUsageAfterGc().keySet());
            return list;
        }

        @Override
        public Collection<String> getPermSpacePools() {
            ArrayList<String> list = new ArrayList<String>(GcAdapter.this.permPools);
            list.retainAll(this.gcInfo.getMemoryUsageAfterGc().keySet());
            return list;
        }
    }
}

