/*
 * Decompiled with CFR 0.152.
 */
package net.java.btrace.runtime;

import com.sun.management.HotSpotDiagnosticMXBean;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.instrument.Instrumentation;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryNotificationInfo;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadFactory;
import javax.management.ListenerNotFoundException;
import javax.management.MBeanServer;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import javax.management.ObjectName;
import javax.management.openmbean.CompositeData;
import net.java.btrace.annotations.OnError;
import net.java.btrace.annotations.OnEvent;
import net.java.btrace.annotations.OnExit;
import net.java.btrace.annotations.OnLowMemory;
import net.java.btrace.annotations.OnTimer;
import net.java.btrace.api.core.BTraceLogger;
import net.java.btrace.api.core.PerfReader;
import net.java.btrace.api.extensions.ExtensionsRepository;
import net.java.btrace.api.server.ShutdownHandler;
import net.java.btrace.api.wireio.AbstractCommand;
import net.java.btrace.api.wireio.Channel;
import net.java.btrace.api.wireio.Response;
import net.java.btrace.runtime.BTraceMBeanImpl;
import net.java.btrace.runtime.ExitException;
import net.java.btrace.runtime.MemoryClassLoader;
import net.java.btrace.runtime.RunnableGenerator;
import net.java.btrace.runtime.ThreadEnteredMap;
import net.java.btrace.util.BTraceThreadFactory;
import net.java.btrace.wireio.commands.ErrorCommand;
import net.java.btrace.wireio.commands.ExitCommand;
import net.java.btrace.wireio.commands.MessageCommand;
import sun.misc.Perf;
import sun.misc.Unsafe;
import sun.reflect.Reflection;

public final class BTraceRuntime {
    private static final String ALLOWED_CLIENT = "net.java.btrace.server.Session";
    private static final String HOTSPOT_BEAN_NAME = "com.sun.management:type=HotSpotDiagnostic";
    private static final Unsafe unsafe = Unsafe.getUnsafe();
    private static final BTraceRuntime dummy;
    public static final BTraceRuntime NULL;
    private static final Thread samplerThread;
    public static volatile long TIMESTAMP;
    private static ThreadEnteredMap map;
    private static ConcurrentMap<String, BTraceRuntime> runtimes;
    private static volatile Perf perf;
    private static volatile PerfReader perfReader;
    private static Map<String, ByteBuffer> counters;
    private static volatile MemoryMXBean memoryMBean;
    private static volatile RuntimeMXBean runtimeMBean;
    private static volatile HotSpotDiagnosticMXBean hotspotMBean;
    private static volatile List<GarbageCollectorMXBean> gcBeanList;
    private static volatile List<MemoryPoolMXBean> memPoolList;
    private static RunnableGenerator runnableGenerator;
    private ThreadLocal<Throwable> currentException = new ThreadLocal();
    private String[] args;
    private volatile boolean disabled;
    private String className;
    private Class clazz;
    private Method exitHandler;
    private Method exceptionHandler;
    private Method[] timerHandlers;
    private Map<String, Method> eventHandlers;
    private Map<String, Method> lowMemHandlers;
    private volatile Timer timer;
    private volatile ExecutorService threadPool;
    private volatile NotificationListener memoryListener;
    private volatile LinkedBlockingQueue<AbstractCommand> queue;
    private volatile SpeculativeQueueManager specQueueManager;
    private final Instrumentation instrumentation;
    private final ExtensionsRepository repository;
    private final Channel channel;
    private final ShutdownHandler shutdown;
    private static final int V_Variable = 3;
    private static final int V_None = 1;
    private static final int V_String = 5;
    private static final int PERF_STRING_LIMIT = 256;

    private BTraceRuntime() {
        this.instrumentation = null;
        this.repository = null;
        this.channel = null;
        this.shutdown = null;
    }

    public BTraceRuntime(ShutdownHandler shutdown, String runtimeName, String[] args, Channel commChannel, Instrumentation inst, ExtensionsRepository extRepository) {
        if (!Reflection.getCallerClass((int)2).getName().startsWith("net.java.btrace")) {
            throw new IllegalArgumentException();
        }
        this.args = args;
        this.queue = new LinkedBlockingQueue();
        this.specQueueManager = new SpeculativeQueueManager();
        this.className = runtimeName;
        this.instrumentation = inst;
        this.repository = extRepository;
        this.channel = commChannel;
        runtimes.put(runtimeName, this);
        this.shutdown = shutdown;
    }

    public static String getClassName() {
        return BTraceRuntime.getCurrent().className;
    }

    public static boolean classNameExists(String name) {
        return runtimes.containsKey(name);
    }

    public static void init(PerfReader perfRead, RunnableGenerator runGen) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().startsWith(ALLOWED_CLIENT)) {
            throw new SecurityException("unsafe init");
        }
        perfReader = perfRead;
        runnableGenerator = runGen;
    }

    public Class defineClass(byte[] code) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().startsWith(ALLOWED_CLIENT)) {
            throw new SecurityException("unsafe defineClass");
        }
        return this.defineClassImpl(code, true);
    }

    public Class defineClass(byte[] code, boolean mustBeBootstrap) {
        Class caller = Reflection.getCallerClass((int)2);
        if (!caller.getName().startsWith(ALLOWED_CLIENT)) {
            throw new SecurityException("unsafe defineClass");
        }
        return this.defineClassImpl(code, mustBeBootstrap);
    }

    public static boolean enter(BTraceRuntime current) {
        if (current.disabled) {
            return false;
        }
        return map.enter(current);
    }

    public static boolean enter() {
        return BTraceRuntime.enter(dummy);
    }

    public static void leave() {
        map.exit();
    }

    public static void start() {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        if (current != null) {
            current.startImpl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(String event) {
        Method eventHandler;
        if (this.eventHandlers != null && (eventHandler = this.eventHandlers.get(event)) != null) {
            BTraceRuntime oldRuntime = (BTraceRuntime)map.get();
            BTraceRuntime.leave();
            try {
                eventHandler.invoke(null, (Object[])null);
            }
            catch (Throwable ignored) {
            }
            finally {
                if (oldRuntime != null) {
                    BTraceRuntime.enter(oldRuntime);
                }
            }
        }
    }

    public static BTraceRuntime forClass(Class cl) {
        BTraceRuntime runtime = (BTraceRuntime)runtimes.get(cl.getName());
        runtime.init(cl);
        return runtime;
    }

    public static ThreadLocal newThreadLocal(final Object initValue) {
        return new ThreadLocal(){

            protected Object initialValue() {
                if (initValue == null) {
                    return initValue;
                }
                if (initValue instanceof Cloneable) {
                    try {
                        Class<?> clz = initValue.getClass();
                        Method m = clz.getDeclaredMethod("clone", new Class[0]);
                        m.setAccessible(true);
                        return m.invoke(initValue, new Object[0]);
                    }
                    catch (Exception e) {
                        BTraceLogger.debugPrint((Throwable)e);
                        return null;
                    }
                }
                return initValue;
            }
        };
    }

    public static void newPerfCounter(String name, String desc, Object value) {
        Perf perf = BTraceRuntime.getPerf();
        char tc = desc.charAt(0);
        switch (tc) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                long initValue = value != null ? ((Number)value).longValue() : 0L;
                ByteBuffer b = perf.createLong(name, 3, 1, initValue);
                b.order(ByteOrder.nativeOrder());
                counters.put(name, b);
                break;
            }
            case '[': {
                break;
            }
            case 'L': {
                byte[] buf;
                if (!desc.equals("Ljava/lang/String;")) break;
                if (value != null) {
                    buf = BTraceRuntime.getStringBytes((String)value);
                } else {
                    buf = new byte[256];
                    buf[0] = 0;
                }
                ByteBuffer b = perf.createByteArray(name, 3, 5, buf, buf.length);
                counters.put(name, b);
            }
        }
    }

    public static int getPerfInt(String name) {
        return (int)BTraceRuntime.getPerfLong(name);
    }

    public static void putPerfInt(int value, String name) {
        long l = value;
        BTraceRuntime.putPerfLong(l, name);
    }

    public static float getPerfFloat(String name) {
        int val = BTraceRuntime.getPerfInt(name);
        return Float.intBitsToFloat(val);
    }

    public static void putPerfFloat(float value, String name) {
        int i = Float.floatToRawIntBits(value);
        BTraceRuntime.putPerfInt(i, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long getPerfLong(String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            long l = b.getLong();
            b.rewind();
            return l;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putPerfLong(long value, String name) {
        ByteBuffer b;
        ByteBuffer byteBuffer = b = counters.get(name);
        synchronized (byteBuffer) {
            b.putLong(value);
            b.rewind();
        }
    }

    public static double getPerfDouble(String name) {
        long val = BTraceRuntime.getPerfLong(name);
        return Double.longBitsToDouble(val);
    }

    public static void putPerfDouble(double value, String name) {
        long l = Double.doubleToRawLongBits(value);
        BTraceRuntime.putPerfLong(l, name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPerfString(String name) {
        ByteBuffer b = counters.get(name);
        byte[] buf = new byte[b.limit()];
        byte t = 0;
        int i = 0;
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            while ((t = b.get()) != 0) {
                buf[i++] = t;
            }
            b.rewind();
        }
        try {
            return new String(buf, 0, i, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void putPerfString(String value, String name) {
        ByteBuffer b = counters.get(name);
        byte[] v = BTraceRuntime.getStringBytes(value);
        ByteBuffer byteBuffer = b;
        synchronized (byteBuffer) {
            b.put(v);
            b.rewind();
        }
    }

    public static void handleException(Throwable th) {
        BTraceRuntime current = BTraceRuntime.getCurrent();
        if (current != null) {
            current.handleExceptionImpl(th);
        } else {
            BTraceLogger.debugPrint((Throwable)th);
        }
    }

    public static void exit(int exitCode) {
        BTraceRuntime rt = BTraceRuntime.getCurrent();
        Throwable th = rt.currentException.get();
        if (!(th instanceof ExitException)) {
            rt.currentException.set(null);
        }
        throw new ExitException(exitCode);
    }

    static long sizeof(Object obj) {
        return BTraceRuntime.getCurrent().instrumentation.getObjectSize(obj);
    }

    public int $length() {
        return this.args == null ? 0 : this.args.length;
    }

    public String[] $$() {
        String[] ret = new String[this.args.length];
        System.arraycopy(this.args, 0, ret, 0, this.args.length);
        return ret;
    }

    public String $(int n) {
        if (n >= 0 && n < this.args.length) {
            return this.args[n];
        }
        return null;
    }

    static int perfInt(String name) {
        return BTraceRuntime.getPerfReader().perfInt(name);
    }

    static long perfLong(String name) {
        return BTraceRuntime.getPerfReader().perfLong(name);
    }

    static String perfString(String name) {
        return BTraceRuntime.getPerfReader().perfString(name);
    }

    public static BTraceRuntime getCurrent() {
        BTraceRuntime current = (BTraceRuntime)map.get();
        assert (current != null) : "BTraceRuntime is null!";
        return current;
    }

    public static String getValidTraceClassName(String origClassName) {
        int cntr = 1;
        String className = origClassName;
        try {
            while (true) {
                ClassLoader.getSystemClassLoader().loadClass(className);
                className = origClassName + "$" + cntr++;
            }
        }
        catch (ClassNotFoundException e) {
            return className;
        }
    }

    public static String identityStr(Object obj) {
        int hashCode = System.identityHashCode(obj);
        return obj.getClass().getName() + "@" + Integer.toHexString(hashCode);
    }

    public static int identityHashCode(Object obj) {
        return System.identityHashCode(obj);
    }

    public static int hash(Object obj) {
        if (obj.getClass().getClassLoader() == null) {
            return obj.hashCode();
        }
        return System.identityHashCode(obj);
    }

    public static boolean compare(Object obj1, Object obj2) {
        if (obj1 instanceof String) {
            return obj1.equals(obj2);
        }
        if (obj1.getClass().getClassLoader() == null && (obj2 == null || obj2.getClass().getClassLoader() == null)) {
            return obj1.equals(obj2);
        }
        return obj1 == obj2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ExecutorService getThreadPool() {
        if (this.threadPool == null) {
            BTraceRuntime bTraceRuntime = this;
            synchronized (bTraceRuntime) {
                if (this.threadPool == null) {
                    this.threadPool = Executors.newFixedThreadPool(1, (ThreadFactory)new BTraceThreadFactory("BTrace Runtime"));
                }
            }
        }
        return this.threadPool;
    }

    private void initMemoryListener() {
        this.memoryListener = new NotificationListener(){

            @Override
            public void handleNotification(Notification notif, Object handback) {
                String notifType = notif.getType();
                if (notifType.equals("java.management.memory.threshold.exceeded")) {
                    CompositeData cd = (CompositeData)notif.getUserData();
                    final MemoryNotificationInfo info = MemoryNotificationInfo.from(cd);
                    String name = info.getPoolName();
                    final Method handler = (Method)BTraceRuntime.this.lowMemHandlers.get(name);
                    if (handler != null) {
                        BTraceRuntime.this.getThreadPool().submit(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (handler.getParameterTypes().length == 1) {
                                        handler.invoke(null, info.getUsage());
                                    } else {
                                        handler.invoke(null, (Object[])null);
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static RuntimeMXBean getRuntimeMBean() {
        if (runtimeMBean != null) return runtimeMBean;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (runtimeMBean != null) return runtimeMBean;
            try {
                // ** MonitorExit[var0] (shouldn't be in output)
                return AccessController.doPrivileged(new PrivilegedExceptionAction<RuntimeMXBean>(){

                    @Override
                    public RuntimeMXBean run() throws Exception {
                        return ManagementFactory.getRuntimeMXBean();
                    }
                });
            }
            catch (Exception exp) {
                throw new UnsupportedOperationException(exp);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        if (memPoolList != null) return memPoolList;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (memPoolList != null) return memPoolList;
            try {
                memPoolList = AccessController.doPrivileged(new PrivilegedExceptionAction<List<MemoryPoolMXBean>>(){

                    @Override
                    public List<MemoryPoolMXBean> run() throws Exception {
                        return ManagementFactory.getMemoryPoolMXBeans();
                    }
                });
            }
            catch (Exception exp) {
                throw new UnsupportedOperationException(exp);
            }
            return memPoolList;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static HotSpotDiagnosticMXBean getHotSpotMBean() {
        if (hotspotMBean != null) return hotspotMBean;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (hotspotMBean != null) return hotspotMBean;
            try {
                hotspotMBean = AccessController.doPrivileged(new PrivilegedExceptionAction<HotSpotDiagnosticMXBean>(){

                    @Override
                    public HotSpotDiagnosticMXBean run() throws Exception {
                        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
                        Set<ObjectName> s = server.queryNames(new ObjectName(BTraceRuntime.HOTSPOT_BEAN_NAME), null);
                        Iterator<ObjectName> itr = s.iterator();
                        if (itr.hasNext()) {
                            ObjectName name = itr.next();
                            HotSpotDiagnosticMXBean bean = ManagementFactory.newPlatformMXBeanProxy(server, name.toString(), HotSpotDiagnosticMXBean.class);
                            return bean;
                        }
                        return null;
                    }
                });
            }
            catch (Exception exp) {
                throw new UnsupportedOperationException(exp);
            }
            return hotspotMBean;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static List<GarbageCollectorMXBean> getGarbageCollectionMBeans() {
        if (gcBeanList != null) return gcBeanList;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (gcBeanList != null) return gcBeanList;
            try {
                gcBeanList = AccessController.doPrivileged(new PrivilegedExceptionAction<List<GarbageCollectorMXBean>>(){

                    @Override
                    public List<GarbageCollectorMXBean> run() throws Exception {
                        return ManagementFactory.getGarbageCollectorMXBeans();
                    }
                });
            }
            catch (Exception exp) {
                throw new UnsupportedOperationException(exp);
            }
            return gcBeanList;
        }
    }

    public static PerfReader getPerfReader() {
        if (perfReader == null) {
            throw new UnsupportedOperationException();
        }
        return perfReader;
    }

    private static RunnableGenerator getRunnableGenerator() {
        return runnableGenerator;
    }

    public static <T extends AbstractCommand> Response<T> send(Class<? extends T> cmdClass, AbstractCommand.Initializer<T> init) {
        return BTraceRuntime.send(cmdClass, init, BTraceRuntime.getCurrent());
    }

    private static <T extends AbstractCommand> Response<T> send(Class<? extends T> cmdClass, AbstractCommand.Initializer<T> init, BTraceRuntime rt) {
        try {
            return rt.channel.sendCommand(cmdClass, init);
        }
        catch (IOException ie) {
            BTraceLogger.debugPrint((Throwable)ie);
            return null;
        }
    }

    public int speculation() {
        return this.specQueueManager.speculation();
    }

    public void speculate(int id) {
        this.specQueueManager.speculate(id);
    }

    public void discard(int id) {
        this.specQueueManager.discard(id);
    }

    public void commit(int id) {
        this.specQueueManager.commit(id, this.queue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.disabled = true;
        if (this.timer != null) {
            this.timer.cancel();
        }
        if (this.memoryListener != null && memoryMBean != null) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)memoryMBean);
            try {
                emitter.removeNotificationListener(this.memoryListener);
            }
            catch (ListenerNotFoundException listenerNotFoundException) {
                // empty catch block
            }
        }
        BTraceRuntime bTraceRuntime = this;
        synchronized (bTraceRuntime) {
            if (this.threadPool != null) {
                this.threadPool.shutdownNow();
            }
        }
        this.specQueueManager.clear();
        runtimes.remove(this.className);
    }

    public static void retransform(String runtimeName, Class<?> clazz) {
        try {
            BTraceRuntime rt = (BTraceRuntime)runtimes.get(runtimeName);
            if (rt != null && rt.instrumentation.isModifiableClass(clazz)) {
                rt.instrumentation.retransformClasses(clazz);
            }
        }
        catch (Exception e) {
            BTraceLogger.debugPrint((Throwable)e);
        }
    }

    public static RuntimeException translate(Exception exp) {
        if (exp instanceof RuntimeException) {
            return (RuntimeException)exp;
        }
        return new RuntimeException(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExceptionImpl(final Throwable th) {
        if (this.currentException.get() != null) {
            return;
        }
        BTraceRuntime.leave();
        this.currentException.set(th);
        try {
            if (th instanceof ExitException) {
                this.exitImpl(((ExitException)th).exitCode());
            } else if (this.exceptionHandler != null) {
                try {
                    this.exceptionHandler.invoke(null, th);
                }
                catch (Throwable ignored) {}
            } else {
                try {
                    ErrorCommand ec = (ErrorCommand)this.channel.prepareCommand(ErrorCommand.class, (AbstractCommand.Initializer)new AbstractCommand.Initializer<ErrorCommand>(){

                        public void init(ErrorCommand cmd) {
                            cmd.setCause(th);
                        }
                    });
                    this.queue.put((AbstractCommand)ec);
                }
                catch (InterruptedException ie) {
                    BTraceLogger.debugPrint((Throwable)ie);
                }
            }
        }
        finally {
            this.currentException.set(null);
        }
    }

    private void startImpl() {
        if (this.timerHandlers != null && this.timerHandlers.length != 0) {
            this.timer = new Timer(true);
            RunnableGenerator gen = BTraceRuntime.getRunnableGenerator();
            Runnable[] runnables = new Runnable[this.timerHandlers.length];
            if (gen != null) {
                this.generateRunnables(gen, runnables);
            } else {
                this.wrapToRunnables(runnables);
            }
            for (int index = 0; index < this.timerHandlers.length; ++index) {
                Method m = this.timerHandlers[index];
                OnTimer tp = m.getAnnotation(OnTimer.class);
                long period = tp.value();
                final Runnable r = runnables[index];
                this.timer.schedule(new TimerTask(){

                    @Override
                    public void run() {
                        r.run();
                    }
                }, period, period);
            }
        }
        if (!this.lowMemHandlers.isEmpty()) {
            this.initMemoryListener();
            ((NotificationEmitter)((Object)BTraceRuntime.getMemoryMBean())).addNotificationListener(this.memoryListener, null, null);
        }
        BTraceRuntime.leave();
    }

    private void generateRunnables(RunnableGenerator gen, Runnable[] runnables) {
        final MemoryClassLoader loader = AccessController.doPrivileged(new PrivilegedAction<MemoryClassLoader>(){

            @Override
            public MemoryClassLoader run() {
                return new MemoryClassLoader(BTraceRuntime.this.clazz.getClassLoader());
            }
        });
        for (int index = 0; index < this.timerHandlers.length; ++index) {
            Method m = this.timerHandlers[index];
            try {
                final String className = "net/java/btrace/BTraceRunnable$" + index;
                final byte[] buf = gen.generate(m, className);
                Class cls = AccessController.doPrivileged(new PrivilegedExceptionAction<Class>(){

                    @Override
                    public Class run() throws Exception {
                        return loader.loadClass(className.replace('/', '.'), buf);
                    }
                });
                runnables[index] = (Runnable)cls.newInstance();
                continue;
            }
            catch (RuntimeException re) {
                throw re;
            }
            catch (Exception exp) {
                throw new RuntimeException(exp);
            }
        }
    }

    private void wrapToRunnables(Runnable[] runnables) {
        for (int index = 0; index < this.timerHandlers.length; ++index) {
            final Method m = this.timerHandlers[index];
            runnables[index] = new Runnable(){

                @Override
                public void run() {
                    try {
                        m.invoke(null, (Object[])null);
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            };
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void exitImpl(final int exitCode) {
        System.err.println("[btrace] Notifyng BTrace client about the application shutdown ...");
        if (this.exitHandler != null) {
            try {
                this.exitHandler.invoke(null, exitCode);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
        }
        if (this.shutdown == null) {
            this.shutdown();
            try {
                this.channel.sendCommand(ExitCommand.class, (AbstractCommand.Initializer)new AbstractCommand.Initializer<ExitCommand>(){

                    public void init(ExitCommand cmd) {
                        cmd.setExitCode(exitCode);
                    }
                });
            }
            catch (IOException e) {
                BTraceLogger.debugPrint((Throwable)e);
            }
            finally {
                this.channel.close();
            }
        } else {
            this.getThreadPool().submit(new Runnable(){

                @Override
                public void run() {
                    BTraceRuntime.this.shutdown.shutdown(exitCode);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Perf getPerf() {
        if (perf != null) return perf;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (perf != null) return perf;
            perf = (Perf)AccessController.doPrivileged(new Perf.GetPerfAction());
            // ** MonitorExit[var0] (shouldn't be in output)
            return perf;
        }
    }

    private static byte[] getStringBytes(String value) {
        byte[] v = null;
        try {
            v = value.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        byte[] v1 = new byte[v.length + 1];
        System.arraycopy(v, 0, v1, 0, v.length);
        v1[v.length] = 0;
        return v1;
    }

    private Class defineClassImpl(byte[] code, boolean mustBeBootstrap) {
        ClassLoader loader = null;
        if (!mustBeBootstrap) {
            loader = new ClassLoader(null){};
        }
        Class cl = unsafe.defineClass(this.className, code, 0, code.length, loader, null);
        unsafe.ensureClassInitialized(cl);
        return cl;
    }

    private void init(Class cl) {
        Method[] methods;
        if (this.clazz != null) {
            return;
        }
        this.clazz = cl;
        ArrayList<Method> timersList = new ArrayList<Method>();
        this.eventHandlers = new HashMap<String, Method>();
        this.lowMemHandlers = new HashMap<String, Method>();
        for (Method m : methods = this.clazz.getMethods()) {
            Class<?>[] argTypes;
            OnLowMemory olm;
            OnTimer ot;
            Class<?>[] argTypes2;
            OnExit oex;
            Class<?>[] argTypes3;
            OnError oer;
            int modifiers = m.getModifiers();
            if (!Modifier.isStatic(modifiers)) continue;
            OnEvent oev = m.getAnnotation(OnEvent.class);
            if (oev != null && m.getParameterTypes().length == 0) {
                this.eventHandlers.put(oev.value(), m);
            }
            if ((oer = m.getAnnotation(OnError.class)) != null && (argTypes3 = m.getParameterTypes()).length == 1 && argTypes3[0] == Throwable.class) {
                this.exceptionHandler = m;
            }
            if ((oex = m.getAnnotation(OnExit.class)) != null && (argTypes2 = m.getParameterTypes()).length == 1 && argTypes2[0] == Integer.TYPE) {
                this.exitHandler = m;
            }
            if ((ot = m.getAnnotation(OnTimer.class)) != null && m.getParameterTypes().length == 0) {
                timersList.add(m);
            }
            if ((olm = m.getAnnotation(OnLowMemory.class)) == null || (argTypes = m.getParameterTypes()).length != 0 && (argTypes.length != 1 || argTypes[0] != MemoryUsage.class)) continue;
            this.lowMemHandlers.put(olm.pool(), m);
        }
        for (MemoryPoolMXBean mpoolBean : BTraceRuntime.getMemoryPoolMXBeans()) {
            Method m;
            String name = mpoolBean.getName();
            if (!this.lowMemHandlers.containsKey(name)) continue;
            m = this.lowMemHandlers.get(name);
            OnLowMemory olm = m.getAnnotation(OnLowMemory.class);
            if (!mpoolBean.isUsageThresholdSupported()) continue;
            mpoolBean.setUsageThreshold(olm.threshold());
        }
        this.timerHandlers = new Method[timersList.size()];
        this.timerHandlers = timersList.toArray(this.timerHandlers);
        BTraceMBeanImpl.registerMBean(this.clazz, this.repository);
    }

    public static String resolveFileName(String name) {
        if (name.indexOf(File.separatorChar) != -1) {
            throw new IllegalArgumentException("directories are not allowed");
        }
        StringBuilder buf = new StringBuilder();
        buf.append('.');
        buf.append(File.separatorChar);
        BTraceRuntime runtime = BTraceRuntime.getCurrent();
        buf.append("btrace");
        if (runtime.args != null && runtime.args.length > 0) {
            buf.append(runtime.args[0]);
        }
        buf.append(File.separatorChar);
        buf.append(runtime.className);
        new File(buf.toString()).mkdirs();
        buf.append(File.separatorChar);
        buf.append(name);
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static MemoryMXBean getMemoryMBean() {
        if (memoryMBean != null) return memoryMBean;
        Class<BTraceRuntime> clazz = BTraceRuntime.class;
        synchronized (BTraceRuntime.class) {
            if (memoryMBean != null) return memoryMBean;
            try {
                memoryMBean = AccessController.doPrivileged(new PrivilegedExceptionAction<MemoryMXBean>(){

                    @Override
                    public MemoryMXBean run() throws Exception {
                        return ManagementFactory.getMemoryMXBean();
                    }
                });
            }
            catch (Exception exp) {
                throw new UnsupportedOperationException(exp);
            }
            return memoryMBean;
        }
    }

    static {
        TIMESTAMP = 0L;
        dummy = new BTraceRuntime();
        NULL = new BTraceRuntime();
        if (Boolean.getBoolean("btrace.timer.sampled")) {
            final long interval = Long.parseLong(System.getProperty("btrace.timer.sampled.interval", "500"));
            long time = System.nanoTime();
            for (int i = 0; i < 1000; ++i) {
                unsafe.park(false, interval);
            }
            time = System.nanoTime() - time;
            final long step = time / 1000L;
            samplerThread = new Thread(new Runnable(){

                @Override
                public void run() {
                    while (true) {
                        unsafe.park(false, interval);
                        TIMESTAMP += step;
                    }
                }
            }, "BTrace Sampled Timer");
            samplerThread.setDaemon(true);
            samplerThread.start();
        } else {
            samplerThread = null;
        }
        map = new ThreadEnteredMap(NULL);
        runtimes = new ConcurrentHashMap<String, BTraceRuntime>();
        counters = new HashMap<String, ByteBuffer>();
    }

    private static class SpeculativeQueueManager {
        private static final int MAX_SPECULATIVE_BUFFERS = Short.MAX_VALUE;
        private static final int MAX_SPECULATIVE_MSG_LIMIT = Short.MAX_VALUE;
        private int nextSpeculationId;
        private ConcurrentHashMap<Integer, LinkedBlockingQueue<AbstractCommand>> speculativeQueues = new ConcurrentHashMap();
        private ThreadLocal<Integer> currentSpeculationId = new ThreadLocal();

        SpeculativeQueueManager() {
        }

        void clear() {
            this.speculativeQueues.clear();
            this.speculativeQueues = null;
            this.currentSpeculationId.remove();
            this.currentSpeculationId = null;
        }

        int speculation() {
            int nextId = this.getNextSpeculationId();
            if (nextId != -1) {
                this.speculativeQueues.put(nextId, new LinkedBlockingQueue(Short.MAX_VALUE));
            }
            return nextId;
        }

        boolean send(AbstractCommand cmd) {
            LinkedBlockingQueue<AbstractCommand> sb;
            Integer curId;
            Integer n = curId = this.currentSpeculationId != null ? this.currentSpeculationId.get() : null;
            if (curId != null && cmd.canBeSpeculated() && (sb = this.speculativeQueues.get(curId)) != null) {
                try {
                    sb.add(cmd);
                }
                catch (IllegalStateException ise) {
                    sb.clear();
                    BTraceRuntime current = BTraceRuntime.getCurrent();
                    MessageCommand mc = (MessageCommand)current.channel.prepareCommand(MessageCommand.class, (AbstractCommand.Initializer)new AbstractCommand.Initializer<MessageCommand>(){

                        public void init(MessageCommand cmd) {
                            cmd.setMessage("speculative buffer overflow: " + curId);
                        }
                    });
                    sb.add((AbstractCommand)mc);
                }
                return true;
            }
            return false;
        }

        void speculate(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(id);
        }

        void commit(int id, LinkedBlockingQueue<AbstractCommand> result) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            LinkedBlockingQueue<AbstractCommand> sb = this.speculativeQueues.get(id);
            if (sb != null) {
                result.addAll(sb);
                sb.clear();
            }
        }

        void discard(int id) {
            this.validateId(id);
            this.currentSpeculationId.set(null);
            this.speculativeQueues.get(id).clear();
        }

        private synchronized int getNextSpeculationId() {
            if (this.nextSpeculationId == Short.MAX_VALUE) {
                return -1;
            }
            return this.nextSpeculationId++;
        }

        private void validateId(int id) {
            if (!this.speculativeQueues.containsKey(id)) {
                throw new RuntimeException("invalid speculative buffer id: " + id);
            }
        }
    }
}

