/*
 * Decompiled with CFR 0.152.
 */
package org.greenrobot.essentials.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.zip.GZIPInputStream;

public class LimitedInputStream
extends InputStream {
    private int bytesLeft;
    private final InputStream in;

    public static GZIPInputStream createGZIPInputStream(InputStream in, int maxBytes) throws IOException {
        LimitedInputStream limitedInputStream = new LimitedInputStream(in, maxBytes);
        return new GZIPInputStream(limitedInputStream);
    }

    public LimitedInputStream(InputStream in, int maxBytes) {
        this.in = in;
        this.bytesLeft = maxBytes;
    }

    @Override
    public int available() throws IOException {
        int available = this.in.available();
        return Math.min(available, this.bytesLeft);
    }

    @Override
    public int read() throws IOException {
        if (this.bytesLeft <= 0) {
            return -1;
        }
        int read = this.in.read();
        if (read != -1) {
            --this.bytesLeft;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer, int offset, int count) throws IOException {
        if (this.bytesLeft <= 0) {
            return -1;
        }
        int countToRead = Math.min(this.bytesLeft, count);
        int read = this.in.read(buffer, offset, countToRead);
        if (read > 0) {
            this.bytesLeft -= read;
        }
        return read;
    }

    @Override
    public int read(byte[] buffer) throws IOException {
        return this.read(buffer, 0, buffer.length);
    }

    @Override
    public long skip(long byteCount) throws IOException {
        if (byteCount <= 0L) {
            return 0L;
        }
        long countToSkip = Math.min((long)this.bytesLeft, byteCount);
        long skipped = this.in.skip(countToSkip);
        if (skipped > 0L) {
            this.bytesLeft = (int)((long)this.bytesLeft - skipped);
        }
        return skipped;
    }

    @Override
    public void close() throws IOException {
    }

    public int getBytesLeft() {
        return this.bytesLeft;
    }
}

